/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.util.Pack;
import org.bouncycastle.util.Arrays;

abstract class GCMUtil {
    GCMUtil() {
    }

    static byte[] oneAsBytes() {
        byte[] byArray = new byte[16];
        byArray[0] = -128;
        return byArray;
    }

    static int[] oneAsInts() {
        int[] nArray = new int[4];
        nArray[0] = Integer.MIN_VALUE;
        return nArray;
    }

    static byte[] asBytes(int[] nArray) {
        byte[] byArray = new byte[16];
        Pack.intToBigEndian(nArray, byArray, 0);
        return byArray;
    }

    static int[] asInts(byte[] byArray) {
        int[] nArray = new int[4];
        Pack.bigEndianToInt(byArray, 0, nArray);
        return nArray;
    }

    static void asInts(byte[] byArray, int[] nArray) {
        Pack.bigEndianToInt(byArray, 0, nArray);
    }

    static void multiply(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.clone(byArray);
        byte[] byArray4 = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            byte by = byArray2[i2];
            for (int i3 = 7; i3 >= 0; --i3) {
                if ((by & 1 << i3) != 0) {
                    GCMUtil.xor(byArray4, byArray3);
                }
                boolean bl = (byArray3[15] & 1) != 0;
                GCMUtil.shiftRight(byArray3);
                if (!bl) continue;
                byArray3[0] = (byte)(byArray3[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(byArray4, 0, byArray, 0, 16);
    }

    static void multiplyP(int[] nArray) {
        boolean bl = (nArray[3] & 1) != 0;
        GCMUtil.shiftRight(nArray);
        if (bl) {
            nArray[0] = nArray[0] ^ 0xE1000000;
        }
    }

    static void multiplyP(int[] nArray, int[] nArray2) {
        boolean bl = (nArray[3] & 1) != 0;
        GCMUtil.shiftRight(nArray, nArray2);
        if (bl) {
            nArray2[0] = nArray2[0] ^ 0xE1000000;
        }
    }

    static void multiplyP8(int[] nArray) {
        int n2 = nArray[3];
        GCMUtil.shiftRightN(nArray, 8);
        for (int i2 = 7; i2 >= 0; --i2) {
            if ((n2 & 1 << i2) == 0) continue;
            nArray[0] = nArray[0] ^ -520093696 >>> 7 - i2;
        }
    }

    static void multiplyP8(int[] nArray, int[] nArray2) {
        int n2 = nArray[3];
        GCMUtil.shiftRightN(nArray, 8, nArray2);
        for (int i2 = 7; i2 >= 0; --i2) {
            if ((n2 & 1 << i2) == 0) continue;
            nArray2[0] = nArray2[0] ^ -520093696 >>> 7 - i2;
        }
    }

    static void shiftRight(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = byArray[n2] & 0xFF;
            byArray[n2] = (byte)(n4 >>> 1 | n3);
            if (++n2 == 16) break;
            n3 = (n4 & 1) << 7;
        }
    }

    static void shiftRight(byte[] byArray, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = byArray[n2] & 0xFF;
            byArray2[n2] = (byte)(n4 >>> 1 | n3);
            if (++n2 == 16) break;
            n3 = (n4 & 1) << 7;
        }
    }

    static void shiftRight(int[] nArray) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = nArray[n2];
            nArray[n2] = n4 >>> 1 | n3;
            if (++n2 == 4) break;
            n3 = n4 << 31;
        }
    }

    static void shiftRight(int[] nArray, int[] nArray2) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = nArray[n2];
            nArray2[n2] = n4 >>> 1 | n3;
            if (++n2 == 4) break;
            n3 = n4 << 31;
        }
    }

    static void shiftRightN(int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = nArray[n3];
            nArray[n3] = n5 >>> n2 | n4;
            if (++n3 == 4) break;
            n4 = n5 << 32 - n2;
        }
    }

    static void shiftRightN(int[] nArray, int n2, int[] nArray2) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            int n5 = nArray[n3];
            nArray2[n3] = n5 >>> n2 | n4;
            if (++n3 == 4) break;
            n4 = n5 << 32 - n2;
        }
    }

    static void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 15; i2 >= 0; --i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    static void xor(byte[] byArray, byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n2 + n3]);
        }
    }

    static void xor(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 15; i2 >= 0; --i2) {
            byArray3[i2] = (byte)(byArray[i2] ^ byArray2[i2]);
        }
    }

    static void xor(int[] nArray, int[] nArray2) {
        for (int i2 = 3; i2 >= 0; --i2) {
            int n2 = i2;
            nArray[n2] = nArray[n2] ^ nArray2[i2];
        }
    }

    static void xor(int[] nArray, int[] nArray2, int[] nArray3) {
        for (int i2 = 3; i2 >= 0; --i2) {
            nArray3[i2] = nArray[i2] ^ nArray2[i2];
        }
    }
}

