/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ua;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public abstract class DSTU4145PointEncoder {
    private static X9IntegerConverter converter = new X9IntegerConverter();

    private static BigInteger trace(ECFieldElement eCFieldElement) {
        ECFieldElement eCFieldElement2 = eCFieldElement;
        for (int i2 = 0; i2 < eCFieldElement.getFieldSize() - 1; ++i2) {
            eCFieldElement2 = eCFieldElement2.square().add(eCFieldElement);
        }
        return eCFieldElement2.toBigInteger();
    }

    private static ECFieldElement solveQuadradicEquation(ECFieldElement eCFieldElement) {
        ECFieldElement.F2m f2m = (ECFieldElement.F2m)eCFieldElement;
        ECFieldElement.F2m f2m2 = new ECFieldElement.F2m(f2m.getM(), f2m.getK1(), f2m.getK2(), f2m.getK3(), ECConstants.ZERO);
        if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
            return f2m2;
        }
        ECFieldElement eCFieldElement2 = null;
        ECFieldElement eCFieldElement3 = f2m2;
        Random random = new Random();
        int n2 = f2m.getM();
        do {
            ECFieldElement.F2m f2m3 = new ECFieldElement.F2m(f2m.getM(), f2m.getK1(), f2m.getK2(), f2m.getK3(), new BigInteger(n2, random));
            eCFieldElement2 = f2m2;
            ECFieldElement eCFieldElement4 = eCFieldElement;
            for (int i2 = 1; i2 <= n2 - 1; ++i2) {
                ECFieldElement eCFieldElement5 = eCFieldElement4.square();
                eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement5.multiply(f2m3));
                eCFieldElement4 = eCFieldElement5.add(eCFieldElement);
            }
            if (eCFieldElement4.toBigInteger().equals(ECConstants.ZERO)) continue;
            return null;
        } while ((eCFieldElement3 = ((ECFieldElement)eCFieldElement2).square().add(eCFieldElement2)).toBigInteger().equals(ECConstants.ZERO));
        return eCFieldElement2;
    }

    public static byte[] encodePoint(ECPoint eCPoint) {
        int n2 = converter.getByteLength(eCPoint.getX());
        byte[] byArray = converter.integerToBytes(eCPoint.getX().toBigInteger(), n2);
        if (!eCPoint.getX().toBigInteger().equals(ECConstants.ZERO)) {
            ECFieldElement eCFieldElement = eCPoint.getY().multiply(eCPoint.getX().invert());
            if (DSTU4145PointEncoder.trace(eCFieldElement).equals(ECConstants.ONE)) {
                int n3 = byArray.length - 1;
                byArray[n3] = (byte)(byArray[n3] | 1);
            } else {
                int n4 = byArray.length - 1;
                byArray[n4] = (byte)(byArray[n4] & 0xFE);
            }
        }
        return byArray;
    }

    public static ECPoint decodePoint(ECCurve eCCurve, byte[] byArray) {
        BigInteger bigInteger = BigInteger.valueOf(byArray[byArray.length - 1] & 1);
        if (!DSTU4145PointEncoder.trace(eCCurve.fromBigInteger(new BigInteger(1, byArray))).equals(eCCurve.getA().toBigInteger())) {
            byArray = Arrays.clone(byArray);
            int n2 = byArray.length - 1;
            byArray[n2] = (byte)(byArray[n2] ^ 1);
        }
        ECCurve.F2m f2m = (ECCurve.F2m)eCCurve;
        ECFieldElement eCFieldElement = eCCurve.fromBigInteger(new BigInteger(1, byArray));
        ECFieldElement eCFieldElement2 = null;
        if (eCFieldElement.toBigInteger().equals(ECConstants.ZERO)) {
            eCFieldElement2 = (ECFieldElement.F2m)eCCurve.getB();
            for (int i2 = 0; i2 < f2m.getM() - 1; ++i2) {
                eCFieldElement2 = ((ECFieldElement)eCFieldElement2).square();
            }
        } else {
            ECFieldElement eCFieldElement3 = eCFieldElement.add(eCCurve.getA()).add(eCCurve.getB().multiply(eCFieldElement.square().invert()));
            ECFieldElement eCFieldElement4 = DSTU4145PointEncoder.solveQuadradicEquation(eCFieldElement3);
            if (eCFieldElement4 == null) {
                throw new RuntimeException("Invalid point compression");
            }
            if (!DSTU4145PointEncoder.trace(eCFieldElement4).equals(bigInteger)) {
                eCFieldElement4 = eCFieldElement4.add(eCCurve.fromBigInteger(ECConstants.ONE));
            }
            eCFieldElement2 = eCFieldElement.multiply(eCFieldElement4);
        }
        return new ECPoint.F2m(eCCurve, eCFieldElement, eCFieldElement2);
    }
}

