/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERObjectIdentifier
extends ASN1Primitive {
    String identifier;
    private byte[] body;
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static ASN1ObjectIdentifier[][] cache = new ASN1ObjectIdentifier[256][];

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object == null || object instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)object;
        }
        if (object instanceof DERObjectIdentifier) {
            return new ASN1ObjectIdentifier(((DERObjectIdentifier)object).getId());
        }
        if (object instanceof ASN1Encodable && ((ASN1Encodable)object).toASN1Primitive() instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)((ASN1Encodable)object).toASN1Primitive();
        }
        if (object instanceof byte[]) {
            return ASN1ObjectIdentifier.fromOctetString((byte[])object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl || aSN1Primitive instanceof DERObjectIdentifier) {
            return DERObjectIdentifier.getInstance(aSN1Primitive);
        }
        return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    DERObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (l2 <= 0xFFFFFFFFFFFF80L) {
                l2 += (long)(n2 & 0x7F);
                if ((n2 & 0x80) == 0) {
                    if (bl) {
                        if (l2 < 40L) {
                            stringBuffer.append('0');
                        } else if (l2 < 80L) {
                            stringBuffer.append('1');
                            l2 -= 40L;
                        } else {
                            stringBuffer.append('2');
                            l2 -= 80L;
                        }
                        bl = false;
                    }
                    stringBuffer.append('.');
                    stringBuffer.append(l2);
                    l2 = 0L;
                    continue;
                }
                l2 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) == 0) {
                if (bl) {
                    stringBuffer.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl = false;
                }
                stringBuffer.append('.');
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l2 = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer.toString();
        this.body = Arrays.clone(byArray);
    }

    public DERObjectIdentifier(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'identifier' cannot be null");
        }
        if (!DERObjectIdentifier.isValidIdentifier(string)) {
            throw new IllegalArgumentException("string " + string + " not an OID");
        }
        this.identifier = string;
    }

    DERObjectIdentifier(DERObjectIdentifier dERObjectIdentifier, String string) {
        if (!DERObjectIdentifier.isValidBranchID(string, 0)) {
            throw new IllegalArgumentException("string " + string + " not a valid OID branch");
        }
        this.identifier = dERObjectIdentifier.getId() + "." + string;
    }

    public String getId() {
        return this.identifier;
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, long l2) {
        byte[] byArray = new byte[9];
        int n2 = 8;
        byArray[n2] = (byte)((int)l2 & 0x7F);
        while (l2 >= 128L) {
            byArray[--n2] = (byte)((int)(l2 >>= 7) & 0x7F | 0x80);
        }
        byteArrayOutputStream.write(byArray, n2, 9 - n2);
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n2 = (bigInteger.bitLength() + 6) / 7;
        if (n2 == 0) {
            byteArrayOutputStream.write(0);
        } else {
            BigInteger bigInteger2 = bigInteger;
            byte[] byArray = new byte[n2];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                byArray[i2] = (byte)(bigInteger2.intValue() & 0x7F | 0x80);
                bigInteger2 = bigInteger2.shiftRight(7);
            }
            int n3 = n2 - 1;
            byArray[n3] = (byte)(byArray[n3] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.identifier);
        int n2 = Integer.parseInt(oIDTokenizer.nextToken()) * 40;
        String string = oIDTokenizer.nextToken();
        if (string.length() <= 18) {
            this.writeField(byteArrayOutputStream, (long)n2 + Long.parseLong(string));
        } else {
            this.writeField(byteArrayOutputStream, new BigInteger(string).add(BigInteger.valueOf(n2)));
        }
        while (oIDTokenizer.hasMoreTokens()) {
            String string2 = oIDTokenizer.nextToken();
            if (string2.length() <= 18) {
                this.writeField(byteArrayOutputStream, Long.parseLong(string2));
                continue;
            }
            this.writeField(byteArrayOutputStream, new BigInteger(string2));
        }
    }

    protected synchronized byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.doOutput(byteArrayOutputStream);
            this.body = byteArrayOutputStream.toByteArray();
        }
        return this.body;
    }

    boolean isConstructed() {
        return false;
    }

    int encodedLength() throws IOException {
        int n2 = this.getBody().length;
        return 1 + StreamUtil.calculateBodyLength(n2) + n2;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = this.getBody();
        aSN1OutputStream.write(6);
        aSN1OutputStream.writeLength(byArray.length);
        aSN1OutputStream.write(byArray);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((DERObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean isValidBranchID(String string, int n2) {
        boolean bl = false;
        int n3 = string.length();
        while (--n3 >= n2) {
            char c2 = string.charAt(n3);
            if ('0' <= c2 && c2 <= '9') {
                bl = true;
                continue;
            }
            if (c2 == '.') {
                if (!bl) {
                    return false;
                }
                bl = false;
                continue;
            }
            return false;
        }
        return bl;
    }

    private static boolean isValidIdentifier(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        return DERObjectIdentifier.isValidBranchID(string, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        if (byArray.length < 3) {
            return new ASN1ObjectIdentifier(byArray);
        }
        int n2 = byArray[byArray.length - 2] & 0xFF;
        int n3 = byArray[byArray.length - 1] & 0x7F;
        ASN1ObjectIdentifier[][] aSN1ObjectIdentifierArray = cache;
        synchronized (cache) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier;
            ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray2 = cache[n2];
            if (aSN1ObjectIdentifierArray2 == null) {
                DERObjectIdentifier.cache[n2] = new ASN1ObjectIdentifier[128];
                aSN1ObjectIdentifierArray2 = DERObjectIdentifier.cache[n2];
            }
            if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n3]) == null) {
                aSN1ObjectIdentifierArray2[n3] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n3];
            }
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifier;
            }
            aSN1ObjectIdentifierArray2 = cache[n2 = n2 + 1 & 0xFF];
            if (aSN1ObjectIdentifierArray2 == null) {
                DERObjectIdentifier.cache[n2] = new ASN1ObjectIdentifier[128];
                aSN1ObjectIdentifierArray2 = DERObjectIdentifier.cache[n2];
            }
            if ((aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n3]) == null) {
                aSN1ObjectIdentifierArray2[n3] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n3];
            }
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifier;
            }
            aSN1ObjectIdentifier = aSN1ObjectIdentifierArray2[n3 = n3 + 1 & 0x7F];
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifierArray2[n3] = new ASN1ObjectIdentifier(byArray);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return aSN1ObjectIdentifierArray2[n3];
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (Arrays.areEqual(byArray, aSN1ObjectIdentifier.getBody())) {
                return aSN1ObjectIdentifier;
            }
            return new ASN1ObjectIdentifier(byArray);
        }
    }
}

