/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.or.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.or.ObjectRenderer;

public class MessageRenderer
implements ObjectRenderer {
    public String doRender(Object o2) {
        if (o2 instanceof Message) {
            StringBuffer sbuf = new StringBuffer();
            Message m2 = (Message)o2;
            try {
                sbuf.append("DeliveryMode=");
                switch (m2.getJMSDeliveryMode()) {
                    case 1: {
                        sbuf.append("NON_PERSISTENT");
                        break;
                    }
                    case 2: {
                        sbuf.append("PERSISTENT");
                        break;
                    }
                    default: {
                        sbuf.append("UNKNOWN");
                    }
                }
                sbuf.append(", CorrelationID=");
                sbuf.append(m2.getJMSCorrelationID());
                sbuf.append(", Destination=");
                sbuf.append(m2.getJMSDestination());
                sbuf.append(", Expiration=");
                sbuf.append(m2.getJMSExpiration());
                sbuf.append(", MessageID=");
                sbuf.append(m2.getJMSMessageID());
                sbuf.append(", Priority=");
                sbuf.append(m2.getJMSPriority());
                sbuf.append(", Redelivered=");
                sbuf.append(m2.getJMSRedelivered());
                sbuf.append(", ReplyTo=");
                sbuf.append(m2.getJMSReplyTo());
                sbuf.append(", Timestamp=");
                sbuf.append(m2.getJMSTimestamp());
                sbuf.append(", Type=");
                sbuf.append(m2.getJMSType());
            }
            catch (JMSException e2) {
                LogLog.error("Could not parse Message.", e2);
            }
            return sbuf.toString();
        }
        return o2.toString();
    }
}

