/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.TokenIdentifier;
import eu.europa.esig.dss.x509.CertificateToken;
import eu.europa.esig.dss.x509.TokenValidationExtraInfo;
import java.io.Serializable;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public abstract class Token
implements Serializable {
    protected CertificateToken issuerToken;
    protected X500Principal issuerX500Principal;
    protected boolean signatureValid = false;
    protected String signatureInvalidityReason = "";
    protected SignatureAlgorithm signatureAlgorithm;
    protected TokenValidationExtraInfo extraInfo;
    private TokenIdentifier tokenIdentifier;

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Token)) {
            return false;
        }
        Token o2 = (Token)obj;
        return this.getDSSId().equals(o2.getDSSId());
    }

    public final int hashCode() {
        return this.getDSSId().hashCode();
    }

    public boolean isTrusted() {
        return false;
    }

    public boolean isSelfSigned() {
        return false;
    }

    public TokenIdentifier getDSSId() {
        if (this.tokenIdentifier == null) {
            this.tokenIdentifier = new TokenIdentifier(this);
        }
        return this.tokenIdentifier;
    }

    public X500Principal getIssuerX500Principal() {
        return this.issuerX500Principal;
    }

    public CertificateToken getIssuerToken() {
        return this.issuerToken;
    }

    public TokenIdentifier getIssuerTokenDSSId() {
        if (this.issuerToken == null) {
            return null;
        }
        return this.issuerToken.getDSSId();
    }

    public abstract boolean isSignedBy(CertificateToken var1);

    public List<String> getValidationInfo() {
        return this.extraInfo.getValidationInfo();
    }

    public String getAbbreviation() {
        return "?";
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public boolean isSignatureValid() {
        return this.isTrusted() || this.signatureValid;
    }

    public TokenValidationExtraInfo extraInfo() {
        return this.extraInfo;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public abstract byte[] getEncoded();
}

