/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.x509.TokenValidationExtraInfo;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CertificateTokenValidationExtraInfo
extends TokenValidationExtraInfo {
    public void infoOCSPSourceIsNull() {
        this.addInfo("The OCSP source is null !");
    }

    public void infoNoOcspUriFoundInCertificate() {
        this.addInfo("OSCP Uri not found in certificate meta-data !");
    }

    public void infoOCSPException(String message) {
        this.addInfo("An exception occurred during the OCSP retrieval process : " + message);
    }

    public void infoCRLSourceIsNull() {
        this.addInfo("The CRL source is null!");
    }

    public void infoNoCRLInfoFound() {
        this.addInfo("No CRL info found !");
    }

    public void infoCRLIsNotValid() {
        this.addInfo("The CRL is not valid!");
    }

    public void infoCRLException(String message) {
        this.addInfo("An exception occurred during the CRL retrieval process : " + message);
    }

    public void infoTheCertNotValidYet(Date validationDate, Date notAfter, Date notBefore) {
        String endDate = this.formatInternal(notAfter);
        String startDate = this.formatInternal(notBefore);
        String valDate = this.formatInternal(validationDate);
        this.addInfo("The certificate is not valid yet! [" + startDate + "-" + endDate + "] on " + valDate);
    }

    public void infoTheCertIsExpired(Date validationDate, Date notAfter, Date notBefore) {
        String endDate = this.formatInternal(notAfter);
        String startDate = this.formatInternal(notBefore);
        String valDate = this.formatInternal(validationDate);
        this.addInfo("The certificate is expired! [" + startDate + "-" + endDate + "] on " + valDate);
    }

    private String formatInternal(Date date) {
        String formatedDate = date == null ? "N/A" : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(date);
        return formatedDate;
    }
}

