/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.x509;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.Normalizer;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.tsl.KeyUsageBit;
import eu.europa.esig.dss.tsl.ServiceInfo;
import eu.europa.esig.dss.x509.CertificateSourceType;
import eu.europa.esig.dss.x509.CertificateTokenValidationExtraInfo;
import eu.europa.esig.dss.x509.RevocationToken;
import eu.europa.esig.dss.x509.Token;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import javax.xml.bind.DatatypeConverter;

public class CertificateToken
extends Token {
    private String dssId;
    private X509Certificate x509Certificate;
    private Set<CertificateSourceType> sources = new HashSet<CertificateSourceType>();
    private Set<ServiceInfo> associatedTSPS = new HashSet<ServiceInfo>();
    private DigestAlgorithm digestAlgorithm = DigestAlgorithm.SHA1;
    private EncryptionAlgorithm encryptionAlgorithm;
    private RevocationToken revocationToken;
    private Boolean selfSigned;
    protected CertificateTokenValidationExtraInfo extraInfo;
    private X500Principal subjectX500PrincipalNormalized = null;
    private String xmlId;
    private Set<KeyUsageBit> keyUsageBits;
    private Boolean valid;

    static CertificateToken newInstance(X509Certificate cert) {
        return new CertificateToken(cert);
    }

    public CertificateToken(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            throw new NullPointerException("X509 certificate is missing");
        }
        this.x509Certificate = x509Certificate;
        this.issuerX500Principal = Normalizer.getNormalizedX500Principal(x509Certificate.getIssuerX500Principal());
        this.signatureAlgorithm = SignatureAlgorithm.forOID(x509Certificate.getSigAlgOID());
        this.digestAlgorithm = this.signatureAlgorithm.getDigestAlgorithm();
        this.encryptionAlgorithm = this.signatureAlgorithm.getEncryptionAlgorithm();
        this.extraInfo = new CertificateTokenValidationExtraInfo();
        ((Token)this).extraInfo = this.extraInfo;
    }

    public void addSourceType(CertificateSourceType certSourceType) {
        if (certSourceType != null) {
            this.sources.add(certSourceType);
        }
    }

    public void addServiceInfo(ServiceInfo serviceInfo) {
        if (serviceInfo != null) {
            this.associatedTSPS.add(serviceInfo);
        }
    }

    public String getDSSIdAsString() {
        if (this.dssId == null) {
            this.dssId = this.getDSSId().asXmlId();
        }
        return this.dssId;
    }

    @Override
    public String getAbbreviation() {
        return this.getDSSIdAsString();
    }

    public void setRevocationToken(RevocationToken revocationToken) {
        this.revocationToken = revocationToken;
    }

    public RevocationToken getRevocationToken() {
        return this.revocationToken;
    }

    public PublicKey getPublicKey() {
        return this.x509Certificate.getPublicKey();
    }

    public Date getNotAfter() {
        return this.x509Certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.x509Certificate.getNotBefore();
    }

    public boolean isExpiredOn(Date date) {
        if (this.x509Certificate == null || date == null) {
            return true;
        }
        return this.x509Certificate.getNotAfter().before(date);
    }

    public boolean isValidOn(Date date) {
        if (this.x509Certificate == null || date == null) {
            return false;
        }
        try {
            this.x509Certificate.checkValidity(date);
            return true;
        }
        catch (CertificateExpiredException e2) {
            return false;
        }
        catch (CertificateNotYetValidException e3) {
            return false;
        }
    }

    public Boolean isRevoked() {
        if (this.isTrusted()) {
            return false;
        }
        if (this.revocationToken == null) {
            return null;
        }
        Boolean status = this.revocationToken.getStatus();
        if (status == null) {
            return null;
        }
        status = status == false;
        return status;
    }

    @Override
    public boolean isTrusted() {
        return this.sources.contains((Object)CertificateSourceType.TRUSTED_LIST) || this.sources.contains((Object)CertificateSourceType.TRUSTED_STORE);
    }

    @Override
    public boolean isSelfSigned() {
        if (this.selfSigned == null) {
            String n1 = this.x509Certificate.getSubjectX500Principal().getName("CANONICAL");
            String n2 = this.x509Certificate.getIssuerX500Principal().getName("CANONICAL");
            this.selfSigned = n1.equals(n2);
        }
        return this.selfSigned;
    }

    public X509Certificate getCertificate() {
        return this.x509Certificate;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e2) {
            throw new DSSException(e2);
        }
    }

    public Set<CertificateSourceType> getSources() {
        return this.sources;
    }

    public Set<ServiceInfo> getAssociatedTSPS() {
        if (this.isTrusted()) {
            return this.associatedTSPS;
        }
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.x509Certificate.getSerialNumber();
    }

    public X500Principal getSubjectX500Principal() {
        if (this.subjectX500PrincipalNormalized == null) {
            this.subjectX500PrincipalNormalized = Normalizer.getNormalizedX500Principal(this.x509Certificate.getSubjectX500Principal());
        }
        return this.subjectX500PrincipalNormalized;
    }

    @Override
    public boolean isSignedBy(CertificateToken issuerToken) {
        this.signatureValid = false;
        this.signatureInvalidityReason = "";
        try {
            PublicKey publicKey = issuerToken.getCertificate().getPublicKey();
            this.x509Certificate.verify(publicKey);
            this.signatureValid = true;
            if (!this.isSelfSigned()) {
                this.issuerToken = issuerToken;
            }
        }
        catch (InvalidKeyException e2) {
            this.signatureInvalidityReason = "InvalidKeyException - on incorrect key.";
        }
        catch (CertificateException e3) {
            this.signatureInvalidityReason = "CertificateException -  on encoding errors.";
        }
        catch (NoSuchAlgorithmException e4) {
            this.signatureInvalidityReason = "NoSuchAlgorithmException - on unsupported signature algorithms.";
        }
        catch (SignatureException e5) {
            this.signatureInvalidityReason = "SignatureException - on signature errors.";
        }
        catch (NoSuchProviderException e6) {
            throw new DSSException(e6);
        }
        return this.signatureValid;
    }

    @Override
    public CertificateTokenValidationExtraInfo extraInfo() {
        return this.extraInfo;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public CertificateToken getTrustAnchor() {
        if (this.isSelfSigned() && this.isTrusted()) {
            return this;
        }
        for (CertificateToken issuerCertToken = this.getIssuerToken(); issuerCertToken != null; issuerCertToken = issuerCertToken.getIssuerToken()) {
            if (!issuerCertToken.isTrusted()) continue;
            return issuerCertToken;
        }
        return null;
    }

    public boolean checkKeyUsage(KeyUsageBit keyUsageBit) {
        Set<KeyUsageBit> keyUsageBits = this.getKeyUsageBits();
        return keyUsageBits.contains((Object)keyUsageBit);
    }

    @Override
    public String toString(String indentStr) {
        try {
            StringBuffer out = new StringBuffer();
            out.append(indentStr).append("CertificateToken[\n");
            indentStr = indentStr + "\t";
            String issuerAsString = "";
            issuerAsString = this.issuerToken == null ? (this.isSelfSigned() ? "[SELF-SIGNED]" : this.getIssuerX500Principal().toString()) : this.issuerToken.getDSSIdAsString();
            String certSource = "UNKNOWN";
            if (this.sources.size() > 0) {
                for (CertificateSourceType source : this.sources) {
                    String name = source.name();
                    if ("UNKNOWN".equals(certSource)) {
                        certSource = name;
                        continue;
                    }
                    certSource = certSource + "/" + name;
                }
            }
            out.append(indentStr).append(this.getDSSIdAsString()).append("<--").append(issuerAsString).append(", source=").append(certSource);
            out.append(", serial=" + this.x509Certificate.getSerialNumber()).append('\n');
            out.append(indentStr).append("Validity period    : ").append(this.x509Certificate.getNotBefore()).append(" - ").append(this.x509Certificate.getNotAfter()).append('\n');
            out.append(indentStr).append("Subject name       : ").append(this.getSubjectX500Principal()).append('\n');
            out.append(indentStr).append("Issuer subject name: ").append(this.getIssuerX500Principal()).append('\n');
            if (this.sources.contains((Object)CertificateSourceType.TRUSTED_LIST)) {
                for (ServiceInfo si : this.associatedTSPS) {
                    out.append(indentStr).append("Service Info      :\n");
                    indentStr = indentStr + "\t";
                    out.append(si.toString(indentStr));
                    indentStr = indentStr.substring(1);
                }
            }
            out.append(indentStr).append("Signature algorithm: ").append(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm).append('\n');
            if (this.isTrusted()) {
                out.append(indentStr).append("Signature validity : Signature verification is not needed: trusted certificate\n");
            } else if (this.signatureValid) {
                out.append(indentStr).append("Signature validity : VALID").append('\n');
            } else if (!this.signatureInvalidityReason.isEmpty()) {
                out.append(indentStr).append("Signature validity : INVALID").append(" - ").append(this.signatureInvalidityReason).append('\n');
            }
            if (this.revocationToken != null) {
                out.append(indentStr).append("Revocation data[\n");
                indentStr = indentStr + "\t";
                CertificateToken revocationTokenIssuerToken = this.revocationToken.getIssuerToken();
                out.append(indentStr).append("Status: ").append(this.revocationToken.getStatus()).append(" / ").append(this.revocationToken.getIssuingTime()).append(" / issuer's certificate ").append(revocationTokenIssuerToken != null ? revocationTokenIssuerToken.getDSSIdAsString() : "null").append('\n');
                indentStr = indentStr.substring(1);
                out.append(indentStr).append("]\n");
            } else if (this.isSelfSigned()) {
                out.append(indentStr).append("Verification of revocation data is not necessary: self-signed certificate.\n");
            } else if (this.isTrusted()) {
                out.append(indentStr).append("Verification of revocation data is not necessary: trusted certificate.\n");
            } else {
                out.append(indentStr).append("There is no revocation data available!\n");
            }
            if (this.issuerToken != null) {
                out.append(indentStr).append("Issuer certificate[\n");
                indentStr = indentStr + "\t";
                if (this.issuerToken.isSelfSigned()) {
                    out.append(indentStr).append(this.issuerToken.getDSSIdAsString()).append(" SELF-SIGNED");
                } else {
                    out.append(this.issuerToken.toString(indentStr));
                }
                out.append('\n');
                indentStr = indentStr.substring(1);
                out.append(indentStr).append("]\n");
            }
            for (String info : this.extraInfo.getValidationInfo()) {
                out.append(indentStr).append("- ").append(info).append('\n');
            }
            indentStr = indentStr.substring(1);
            out.append(indentStr).append("]");
            return out.toString();
        }
        catch (Exception e2) {
            return e2.getMessage();
        }
    }

    public String getIssuerCN() {
        String[] arrayName;
        String name = this.getIssuerDN().getName();
        if (name == null || "".equals(name.trim())) {
            return "";
        }
        for (String ele : arrayName = name.split(",")) {
            if (!ele.contains("CN=")) continue;
            return ele.replaceFirst("CN=", "").trim();
        }
        return "";
    }

    public String getXmlId() {
        return this.xmlId;
    }

    public void setXmlId(String xmlId) {
        this.xmlId = xmlId;
    }

    public Set<KeyUsageBit> getKeyUsageBits() {
        if (this.keyUsageBits == null) {
            boolean[] keyUsageArray = this.x509Certificate.getKeyUsage();
            this.keyUsageBits = new HashSet<KeyUsageBit>();
            if (keyUsageArray != null) {
                for (KeyUsageBit keyUsageBit : KeyUsageBit.values()) {
                    if (!keyUsageArray[keyUsageBit.getIndex()]) continue;
                    this.keyUsageBits.add(keyUsageBit);
                }
            }
        }
        return this.keyUsageBits;
    }

    public byte[] getSignature() {
        return this.x509Certificate.getSignature();
    }

    public Principal getIssuerDN() {
        return this.x509Certificate.getIssuerDN();
    }

    public Principal getSubjectDN() {
        return this.x509Certificate.getSubjectDN();
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    private String extractCNName(X500Principal principal) {
        String name = principal.getName();
        int index = name.indexOf("CN=") + 3;
        if (index == -1) {
            return name;
        }
        int stop = name.indexOf(",", index);
        if (stop == -1) {
            return name.substring(index);
        }
        return name.substring(index, stop);
    }

    public String getSubjectShortName() {
        return this.extractCNName(this.getSubjectX500Principal());
    }

    public String getBase64Encoded() {
        return DatatypeConverter.printBase64Binary((byte[])this.getEncoded());
    }

    public String getReadableCertificate() {
        String readableCertificate = this.x509Certificate.getSubjectDN().getName();
        int dnStartIndex = readableCertificate.indexOf("CN=") + 3;
        if (dnStartIndex > 0 && readableCertificate.indexOf(",", dnStartIndex) > 0) {
            readableCertificate = readableCertificate.substring(dnStartIndex, readableCertificate.indexOf(",", dnStartIndex)) + " (SN:" + this.getSerialNumber() + ")";
        }
        return readableCertificate;
    }
}

