/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.tsl;

import eu.europa.esig.dss.tsl.Condition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = 4903410679096343832L;
    private String tspName;
    private String tspTradeName;
    private String tspPostalAddress;
    private String tspElectronicAddress;
    private String type;
    private String serviceName;
    private String status;
    private Date statusStartDate;
    private Date statusEndDate;
    private Map<String, List<Condition>> qualifiersAndConditions = new HashMap<String, List<Condition>>();
    private boolean tlWellSigned;
    private Date expiredCertsRevocationInfo;

    public void addQualifierAndCondition(String qualifier, Condition condition) {
        List<Condition> conditions = this.qualifiersAndConditions.get(qualifier);
        if (conditions == null) {
            conditions = new ArrayList<Condition>();
            this.qualifiersAndConditions.put(qualifier, conditions);
        }
        conditions.add(condition);
    }

    public Map<String, List<Condition>> getQualifiersAndConditions() {
        return this.qualifiersAndConditions;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getStatusEndDate() {
        return this.statusEndDate;
    }

    public Date getStatusStartDate() {
        return this.statusStartDate;
    }

    public String getTspElectronicAddress() {
        return this.tspElectronicAddress;
    }

    public String getTspName() {
        return this.tspName;
    }

    public String getTspPostalAddress() {
        return this.tspPostalAddress;
    }

    public String getTspTradeName() {
        return this.tspTradeName;
    }

    public String getType() {
        return this.type;
    }

    public boolean isTlWellSigned() {
        return this.tlWellSigned;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.trim(serviceName);
    }

    public void setStatus(String status) {
        this.status = this.trim(status);
    }

    public void setStatusStartDate(Date statusStartDate) {
        this.statusStartDate = statusStartDate;
    }

    public void setStatusEndDate(Date statusEndDate) {
        this.statusEndDate = statusEndDate;
    }

    public void setTlWellSigned(boolean tlWellSigned) {
        this.tlWellSigned = tlWellSigned;
    }

    public void setTspElectronicAddress(String tspElectronicAddress) {
        this.tspElectronicAddress = this.trim(tspElectronicAddress);
    }

    public void setTspName(String tspName) {
        this.tspName = this.trim(tspName);
    }

    public void setTspPostalAddress(String tspPostalAddress) {
        this.tspPostalAddress = this.trim(tspPostalAddress);
    }

    public void setTspTradeName(String tspTradeName) {
        this.tspTradeName = this.trim(tspTradeName);
    }

    public void setType(String type) {
        this.type = this.trim(type);
    }

    public Date getExpiredCertsRevocationInfo() {
        return this.expiredCertsRevocationInfo;
    }

    public void setExpiredCertsRevocationInfo(Date expiredCertsRevocationInfo) {
        this.expiredCertsRevocationInfo = expiredCertsRevocationInfo;
    }

    public String toString(String indent) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent).append("Type                      \t= ").append(this.type).append('\n');
            buffer.append(indent).append("TSPName                   \t= ").append(this.tspName).append('\n');
            buffer.append(indent).append("ServiceName               \t= ").append(this.serviceName).append('\n');
            buffer.append(indent).append("Status                    \t= ").append(this.status).append('\n');
            if (this.statusStartDate != null) {
                buffer.append(indent).append("StatusStartDate           \t= ").append(this.statusStartDate).append('\n');
            }
            if (this.statusEndDate != null) {
                buffer.append(indent).append("StatusEndDate           \t= ").append(this.statusEndDate).append('\n');
            }
            for (Map.Entry<String, List<Condition>> conditionEntry : this.qualifiersAndConditions.entrySet()) {
                buffer.append(indent).append("QualifiersAndConditions    \t= ").append(conditionEntry.getKey()).append(":").append('\n');
                indent = indent + "\t\t\t\t\t\t\t\t";
                List<Condition> conditions = conditionEntry.getValue();
                for (Condition condition : conditions) {
                    buffer.append(condition.toString(indent));
                }
                indent = indent.substring(8);
            }
            buffer.append(indent).append("TSPTradeName              \t= ").append(this.tspTradeName).append('\n');
            buffer.append(indent).append("TSPPostalAddress          \t= ").append(this.tspPostalAddress).append('\n');
            buffer.append(indent).append("TSPElectronicAddress      \t= ").append(this.tspElectronicAddress).append("\n\n");
            if (this.expiredCertsRevocationInfo != null) {
                buffer.append(indent).append("ExpiredCertsRevocationInfo\t= ").append(this.expiredCertsRevocationInfo).append("\n\n");
            }
            buffer.append(indent).append("TLWellSigned              \t= ").append(this.tlWellSigned).append('\n');
            return buffer.toString();
        }
        catch (Exception e2) {
            return super.toString();
        }
    }

    private String trim(String str) {
        if (str != null) {
            return str.trim();
        }
        return str;
    }

    public String toString() {
        return this.toString("");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.statusStartDate == null ? 0 : this.statusStartDate.hashCode());
        result = 31 * result + (this.tspName == null ? 0 : this.tspName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInfo other = (ServiceInfo)obj;
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        if (this.statusStartDate == null ? other.statusStartDate != null : !this.statusStartDate.equals(other.statusStartDate)) {
            return false;
        }
        return !(this.tspName == null ? other.tspName != null : !this.tspName.equals(other.tspName));
    }
}

