/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.view;

import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class SystemTray {
    private static final Logger logger = Logger.getLogger(SystemTray.class.getName());
    private JCheckBoxMenuItem itemLanguageVietnamese;
    private JCheckBoxMenuItem itemLanguageEnglish;
    private JCheckBoxMenuItem itemShow;
    private JMenuItem itemShowLogin;
    private JMenuItem itemShowSetup;
    private JMenuItem itemViewInvoice;
    private JMenuItem itemExit;
    private JMenu menuLanguage;
    private JMenu menuNavigate;
    private PopupMenu systemTrayMenu;
    private JFrame jFrame;
    private JLabel jLabel;
    private JPopupMenu popupMenu;

    public void createSystemTray() {
        try {
            if (!java.awt.SystemTray.isSupported()) {
                throw new UnsupportedOperationException("System tray is unsupported ");
            }
            this.setSystemTrayMenu(new PopupMenu());
            this.systemTrayMenu.setFont(new Font("Arial", 0, 12));
            this.setPopupMenu(new JPopupMenu());
            this.popupMenu.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("JPopupMenu.firePopupMenuCanceled".equals(evt.getPropertyName())) {
                        SystemTray.this.jFrame.setVisible(false);
                    }
                }
            });
            this.setjFrame(new JFrame());
            this.jFrame.setSize(97, 94);
            this.jFrame.setUndecorated(true);
            this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(Manager.class.getResource("/Images/transparent.png")));
            this.setjLabel(new JLabel());
            this.jFrame.setAlwaysOnTop(true);
            this.jFrame.add(this.jLabel);
            this.setItemShow(new JCheckBoxMenuItem(StringUtil.getText("signing.tool.show"), true));
            this.itemShow.setCursor(Cursor.getPredefinedCursor(12));
            this.itemShow.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        SystemTray.this.itemShow.setState(true);
                        SystemTray.this.jFrame.setVisible(false);
                        return;
                    }
                    if (SystemTray.this.itemShow.getState()) {
                        logger.info("=====> Show");
                        Manager.getMainScreen().setVisible(true);
                        Manager.getMainScreen().appearOnTop();
                    } else {
                        logger.info("=====> Hide");
                        Manager.getMainScreen().showJpanelAbout(false);
                        Manager.getMainScreen().setVisible(false);
                    }
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.setMenuLanguage(new JMenu(StringUtil.getText("signing.tool.language")));
            this.menuLanguage.setCursor(Cursor.getPredefinedCursor(12));
            this.setItemLanguageVietnamese(new JCheckBoxMenuItem(StringUtil.getText("signing.tool.language.vietnam"), "vi_VN".equals(Manager.getConfigObject().getLanguage())));
            this.itemLanguageVietnamese.setCursor(Cursor.getPredefinedCursor(12));
            this.itemLanguageVietnamese.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        SystemTray.this.jFrame.setVisible(false);
                        SystemTray.this.itemLanguageVietnamese.setState(!SystemTray.this.itemLanguageVietnamese.getState());
                        return;
                    }
                    if (SystemTray.this.itemLanguageVietnamese.getState()) {
                        try {
                            SystemTray.this.itemLanguageEnglish.setState(false);
                            String configFilePath = System.getenv("APPDATA") + "\\" + "713d7e3f12b9eecfbb26bc9d825sfsgfsfsdlozkecmkdoojl098" + "\\" + "c3640649cd6bb07c13199b8381f611d4a61f14a9a10a2b5a624d" + ".txt";
                            Manager.getConfigObject().setLanguage("vi_VN");
                            Manager.saveConfig(Manager.getConfigObject(), configFilePath);
                            if (Manager.getMainScreen() != null) {
                                Manager.getMainScreen().refresh();
                            }
                            if (Manager.getViewInvoiceFrame() != null) {
                                Manager.getViewInvoiceFrame().refresh();
                            }
                            if (Manager.getSystemTray() != null) {
                                Manager.getSystemTray().refresh();
                            }
                            if (Manager.getSignFrame() != null) {
                                Manager.getSignFrame().refresh();
                            }
                            if (Manager.getChooseCertTableFrame() != null) {
                                Manager.getChooseCertTableFrame().refresh();
                            }
                            logger.info("=====> vietnam");
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                        }
                    } else {
                        SystemTray.this.itemLanguageVietnamese.setState(true);
                    }
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.setItemLanguageEnglish(new JCheckBoxMenuItem(StringUtil.getText("signing.tool.language.english"), "en_US".equals(Manager.getConfigObject().getLanguage())));
            this.itemLanguageEnglish.setCursor(Cursor.getPredefinedCursor(12));
            this.itemLanguageEnglish.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        SystemTray.this.jFrame.setVisible(false);
                        SystemTray.this.itemLanguageEnglish.setState(!SystemTray.this.itemLanguageEnglish.getState());
                        return;
                    }
                    if (SystemTray.this.itemLanguageEnglish.getState()) {
                        try {
                            SystemTray.this.itemLanguageVietnamese.setState(false);
                            String configFilePath = System.getenv("APPDATA") + "\\" + "713d7e3f12b9eecfbb26bc9d825sfsgfsfsdlozkecmkdoojl098" + "\\" + "c3640649cd6bb07c13199b8381f611d4a61f14a9a10a2b5a624d" + ".txt";
                            Manager.getConfigObject().setLanguage("en_US");
                            Manager.saveConfig(Manager.getConfigObject(), configFilePath);
                            if (Manager.getMainScreen() != null) {
                                Manager.getMainScreen().refresh();
                            }
                            if (Manager.getViewInvoiceFrame() != null) {
                                Manager.getViewInvoiceFrame().refresh();
                            }
                            if (Manager.getSystemTray() != null) {
                                Manager.getSystemTray().refresh();
                            }
                            if (Manager.getSignFrame() != null) {
                                Manager.getSignFrame().refresh();
                            }
                            if (Manager.getChooseCertTableFrame() != null) {
                                Manager.getChooseCertTableFrame().refresh();
                            }
                            logger.info("=====> English");
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                        }
                    } else {
                        SystemTray.this.itemLanguageEnglish.setState(true);
                    }
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.menuLanguage.add(this.itemLanguageVietnamese);
            this.menuLanguage.add(this.itemLanguageEnglish);
            this.setMenuNavigate(new JMenu(StringUtil.getText("signing.tool.navigate")));
            this.menuNavigate.setCursor(Cursor.getPredefinedCursor(12));
            this.setItemShowLogin(new JMenuItem(StringUtil.getText("main.screen.login")));
            this.itemShowLogin.setCursor(Cursor.getPredefinedCursor(12));
            this.itemShowLogin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        SystemTray.this.jFrame.setVisible(false);
                        return;
                    }
                    logger.info("=====> Log in");
                    SystemTray.this.itemShow.setState(true);
                    if (Manager.getViewInvoiceFrame() != null) {
                        Manager.getViewInvoiceFrame().closeViewInvoiceFrame();
                    }
                    Manager.getMainScreen().showJpanelPassword();
                    Manager.getMainScreen().setVisible(true);
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.setItemShowSetup(new JMenuItem(StringUtil.getText("main.screen.setup")));
            this.itemShowSetup.setCursor(Cursor.getPredefinedCursor(12));
            this.itemShowSetup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        SystemTray.this.jFrame.setVisible(false);
                        return;
                    }
                    logger.info("=====> setup");
                    SystemTray.this.itemShow.setState(true);
                    if (Manager.getViewInvoiceFrame() != null) {
                        Manager.getViewInvoiceFrame().closeViewInvoiceFrame();
                    }
                    Manager.getMainScreen().showJpanelSetup();
                    Manager.getMainScreen().setVisible(true);
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.setItemViewInvoice(new JMenuItem(StringUtil.getText("main.screen.view.invoice")));
            this.itemViewInvoice.setCursor(Cursor.getPredefinedCursor(12));
            this.itemViewInvoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    if (SystemTray.this.isSigning()) {
                        return;
                    }
                    logger.info("=====> view invoice");
                    SystemTray.this.itemShow.setState(true);
                    Manager.getMainScreen().showViewInvoiceFrame();
                    SystemTray.this.jFrame.setVisible(false);
                }
            });
            this.menuNavigate.add(this.itemShowLogin);
            this.menuNavigate.add(this.itemViewInvoice);
            this.menuNavigate.add(this.itemShowSetup);
            this.setItemExit(new JMenuItem(StringUtil.getText("main.screen.exit")));
            this.itemExit.setCursor(Cursor.getPredefinedCursor(12));
            this.itemExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    logger.info("=====> Exit");
                    try {
                        Manager.getJavaSocketConnection().stopServer();
                    }
                    catch (Exception ex) {
                        logger.error("=====> Exit: " + ex.getMessage(), ex);
                    }
                    System.exit(0);
                }
            });
            this.popupMenu.add(this.itemShow);
            this.popupMenu.add(this.menuLanguage);
            this.popupMenu.add(this.menuNavigate);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.itemExit);
            Image img = Toolkit.getDefaultToolkit().getImage(Manager.class.getResource("/Images/icon_tray.png"));
            TrayIcon trayIcon = new TrayIcon(img, StringUtil.getText("signing.tool.tray.icon.message"), this.systemTrayMenu);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getButton() == 3) {
                        SystemTray.this.jFrame.setLocation(e2.getX() - SystemTray.this.jFrame.getWidth(), e2.getY() - SystemTray.this.jFrame.getHeight());
                        SystemTray.this.jFrame.setVisible(true);
                        SystemTray.this.popupMenu.show(SystemTray.this.jLabel, SystemTray.this.jLabel.getX(), SystemTray.this.jLabel.getY());
                    }
                }
            });
            trayIcon.setImageAutoSize(true);
            java.awt.SystemTray.getSystemTray().add(trayIcon);
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    public void setWaitCursor() {
        this.itemShow.setCursor(Cursor.getPredefinedCursor(3));
        this.menuLanguage.setCursor(Cursor.getPredefinedCursor(3));
        this.itemLanguageVietnamese.setCursor(Cursor.getPredefinedCursor(3));
        this.itemLanguageEnglish.setCursor(Cursor.getPredefinedCursor(3));
        this.menuNavigate.setCursor(Cursor.getPredefinedCursor(3));
        this.itemShowLogin.setCursor(Cursor.getPredefinedCursor(3));
        this.itemShowSetup.setCursor(Cursor.getPredefinedCursor(3));
        this.itemViewInvoice.setCursor(Cursor.getPredefinedCursor(3));
        this.itemExit.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void resetCursor() {
        this.itemShow.setCursor(Cursor.getPredefinedCursor(12));
        this.menuLanguage.setCursor(Cursor.getPredefinedCursor(12));
        this.itemLanguageVietnamese.setCursor(Cursor.getPredefinedCursor(12));
        this.itemLanguageEnglish.setCursor(Cursor.getPredefinedCursor(12));
        this.menuNavigate.setCursor(Cursor.getPredefinedCursor(12));
        this.itemShowLogin.setCursor(Cursor.getPredefinedCursor(12));
        this.itemShowSetup.setCursor(Cursor.getPredefinedCursor(12));
        this.itemViewInvoice.setCursor(Cursor.getPredefinedCursor(12));
        this.itemExit.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void refresh() {
        this.itemLanguageVietnamese.setLabel(StringUtil.getText("signing.tool.language.vietnam"));
        this.itemLanguageVietnamese.setSelected("vi_VN".equals(Manager.getConfigObject().getLanguage()));
        this.itemLanguageEnglish.setLabel(StringUtil.getText("signing.tool.language.english"));
        this.itemLanguageEnglish.setSelected("en_US".equals(Manager.getConfigObject().getLanguage()));
        this.itemShow.setLabel(StringUtil.getText("signing.tool.show"));
        this.itemShowLogin.setLabel(StringUtil.getText("main.screen.login"));
        this.itemShowSetup.setLabel(StringUtil.getText("main.screen.setup"));
        this.itemViewInvoice.setLabel(StringUtil.getText("main.screen.view.invoice"));
        this.itemExit.setLabel(StringUtil.getText("main.screen.exit"));
        this.menuLanguage.setLabel(StringUtil.getText("signing.tool.language"));
        this.menuNavigate.setLabel(StringUtil.getText("signing.tool.navigate"));
    }

    private boolean isSigning() {
        return Manager.isIsSigning();
    }

    public JCheckBoxMenuItem getItemLanguageVietnamese() {
        return this.itemLanguageVietnamese;
    }

    public void setItemLanguageVietnamese(JCheckBoxMenuItem itemLanguageVietnamese) {
        this.itemLanguageVietnamese = itemLanguageVietnamese;
    }

    public JCheckBoxMenuItem getItemLanguageEnglish() {
        return this.itemLanguageEnglish;
    }

    public void setItemLanguageEnglish(JCheckBoxMenuItem itemLanguageEnglish) {
        this.itemLanguageEnglish = itemLanguageEnglish;
    }

    public JCheckBoxMenuItem getItemShow() {
        return this.itemShow;
    }

    public void setItemShow(JCheckBoxMenuItem itemShow) {
        this.itemShow = itemShow;
    }

    public JMenuItem getItemShowLogin() {
        return this.itemShowLogin;
    }

    public void setItemShowLogin(JMenuItem itemShowLogin) {
        this.itemShowLogin = itemShowLogin;
    }

    public JMenuItem getItemShowSetup() {
        return this.itemShowSetup;
    }

    public void setItemShowSetup(JMenuItem itemShowSetup) {
        this.itemShowSetup = itemShowSetup;
    }

    public JMenuItem getItemViewInvoice() {
        return this.itemViewInvoice;
    }

    public void setItemViewInvoice(JMenuItem itemViewInvoice) {
        this.itemViewInvoice = itemViewInvoice;
    }

    public JMenuItem getItemExit() {
        return this.itemExit;
    }

    public void setItemExit(JMenuItem itemExit) {
        this.itemExit = itemExit;
    }

    public JMenu getMenuLanguage() {
        return this.menuLanguage;
    }

    public void setMenuLanguage(JMenu menuLanguage) {
        this.menuLanguage = menuLanguage;
    }

    public JMenu getMenuNavigate() {
        return this.menuNavigate;
    }

    public void setMenuNavigate(JMenu menuNavigate) {
        this.menuNavigate = menuNavigate;
    }

    public PopupMenu getSystemTrayMenu() {
        return this.systemTrayMenu;
    }

    public void setSystemTrayMenu(PopupMenu systemTrayMenu) {
        this.systemTrayMenu = systemTrayMenu;
    }

    public JFrame getjFrame() {
        return this.jFrame;
    }

    public void setjFrame(JFrame jFrame) {
        this.jFrame = jFrame;
    }

    public JLabel getjLabel() {
        return this.jLabel;
    }

    public void setjLabel(JLabel jLabel) {
        this.jLabel = jLabel;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
    }
}

