/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.view;

import com.viettel.einvoice.verify.CheckOcspOrCrl;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import eu.europa.esig.dss.token.usb.MessageCode;
import eu.europa.esig.dss.token.usb.SecureToken;
import eu.europa.esig.dss.token.usb.Token;
import eu.europa.esig.dss.token.usb.UsbTokenBussiness;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.DateTimeUtils;
import eu.europa.esig.dss.token.utils.PropertiesUtils;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import viettel.custom.swing.RoundedCornerJButton;
import viettel.custom.swing.RoundedCornerJPanel;

public class SignFrame
extends JFrame {
    private boolean isTableOpen = true;
    private static final Logger logger = Logger.getLogger(SignFrame.class.getName());
    private Map mapTokens = null;
    private SecureToken secureToken = null;
    private String[] tokenNames = null;
    private static String taxCode = null;
    private static List<DSSPrivateKeyEntry> listSignPrivateKeys = new ArrayList<DSSPrivateKeyEntry>();
    private int x;
    private int y;
    private RoundedCornerJButton btnClo;
    private RoundedCornerJButton btnMiz;
    private RoundedCornerJButton jButtonChooseCert;
    private RoundedCornerJButton jButtonExitLogin;
    private RoundedCornerJButton jButtonLogin;
    private JButton jButtonSeePassword;
    private JLabel jLabel16;
    private JLabel jLabelPin;
    private JLayeredPane jLayeredPaneSignInvoice;
    private JPanel jPanelChooseCert;
    private RoundedCornerJPanel jPanelGetPassword;
    private JPanel jPanelPassword;
    private JPasswordField jPasswordField;
    private JScrollPane jScrollPane4;
    private JTable jTableChooseCert;
    private JLabel jtitleFormLogin;
    private JPanel pnTitleBar;

    public SignFrame() {
        this.initComponents();
        CustomedComponentUtil.setIconForFrame(this);
        this.initMoving(this);
    }

    private void initMoving(final JFrame frame) {
        this.pnTitleBar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                SignFrame.this.x = e2.getX();
                SignFrame.this.y = e2.getY();
            }
        });
        this.pnTitleBar.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                frame.setLocation(e2.getXOnScreen() - SignFrame.this.x, e2.getYOnScreen() - SignFrame.this.y);
            }
        });
    }

    private void initComponents() {
        this.jLayeredPaneSignInvoice = new JLayeredPane();
        this.jPanelPassword = new JPanel();
        this.jLabelPin = new JLabel();
        this.jPanelGetPassword = new RoundedCornerJPanel();
        this.jButtonSeePassword = new JButton();
        this.jPasswordField = new JPasswordField();
        this.jButtonLogin = new RoundedCornerJButton();
        this.jButtonExitLogin = new RoundedCornerJButton();
        this.jPanelChooseCert = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.jTableChooseCert = new JTable();
        this.jButtonChooseCert = new RoundedCornerJButton();
        this.jtitleFormLogin = new JLabel();
        this.pnTitleBar = new JPanel();
        this.jLabel16 = new JLabel();
        this.btnMiz = new RoundedCornerJButton();
        this.btnClo = new RoundedCornerJButton();
        this.setBackground(new Color(255, 255, 255));
        this.setUndecorated(true);
        this.setResizable(false);
        this.jPanelPassword.setBackground(new Color(255, 255, 255));
        this.jPanelPassword.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelPassword.setPreferredSize(new Dimension(651, 308));
        this.jPanelPassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SignFrame.this.jPanelPasswordMousePressed(evt);
            }
        });
        this.jLabelPin.setFont(new Font("Arial", 0, 14));
        this.jLabelPin.setText(StringUtil.getText("main.screen.pin"));
        this.jPanelGetPassword.setBackground(new Color(255, 255, 255));
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelGetPassword.setArcHeight(10);
        this.jPanelGetPassword.setArcWidth(10);
        this.jPanelGetPassword.setFocusColor(new Color(89, 97, 100));
        this.jPanelGetPassword.setPreferredSize(new Dimension(275, 35));
        this.jPanelGetPassword.setThickness(2);
        this.jPanelGetPassword.setUnfocusColor(new Color(153, 153, 153));
        this.jButtonSeePassword.setIcon(this.getImageIcon("eye.png"));
        this.jButtonSeePassword.setToolTipText(StringUtil.getText("see.pass"));
        this.jButtonSeePassword.setBorder(null);
        this.jButtonSeePassword.setCursor(new Cursor(12));
        this.jButtonSeePassword.setFocusPainted(false);
        this.jButtonSeePassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SignFrame.this.jButtonSeePasswordFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SignFrame.this.jButtonSeePasswordFocusLost(evt);
            }
        });
        this.jButtonSeePassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SignFrame.this.jButtonSeePasswordMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SignFrame.this.jButtonSeePasswordMouseReleased(evt);
            }
        });
        this.jButtonSeePassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignFrame.this.jButtonSeePasswordActionPerformed(evt);
            }
        });
        this.jButtonSeePassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SignFrame.this.jButtonSeePasswordKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                SignFrame.this.jButtonSeePasswordKeyReleased(evt);
            }
        });
        this.jPasswordField.setBorder(null);
        this.jPasswordField.setEchoChar('*');
        this.jPasswordField.setCursor(new Cursor(2));
        this.jPasswordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SignFrame.this.jPasswordFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SignFrame.this.jPasswordFieldFocusLost(evt);
            }
        });
        this.jPasswordField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                SignFrame.this.jPasswordFieldMousePressed(evt);
            }
        });
        this.jPasswordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SignFrame.this.jPasswordFieldKeyPressed(evt);
            }
        });
        GroupLayout jPanelGetPasswordLayout = new GroupLayout(this.jPanelGetPassword);
        this.jPanelGetPassword.setLayout(jPanelGetPasswordLayout);
        jPanelGetPasswordLayout.setHorizontalGroup(jPanelGetPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelGetPasswordLayout.createSequentialGroup().addContainerGap().addComponent(this.jPasswordField, -1, 235, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSeePassword, -2, 20, -2).addContainerGap()));
        jPanelGetPasswordLayout.setVerticalGroup(jPanelGetPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSeePassword, -1, -1, Short.MAX_VALUE).addComponent(this.jPasswordField, GroupLayout.Alignment.TRAILING, -1, 33, Short.MAX_VALUE));
        this.jButtonLogin.setBackground(new Color(238, 0, 51));
        this.jButtonLogin.setBorder(null);
        this.jButtonLogin.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonLogin.setForeground(new Color(255, 255, 255));
        this.jButtonLogin.setText(StringUtil.getText("authenticate"));
        this.jButtonLogin.setArcHeight(10);
        this.jButtonLogin.setArcWidth(10);
        this.jButtonLogin.setArmedColor(new Color(224, 0, 51));
        this.jButtonLogin.setFocusPainted(false);
        this.jButtonLogin.setFont(new Font("Arial", 1, 12));
        this.jButtonLogin.setHorizontalTextPosition(4);
        this.jButtonLogin.setIconTextGap(10);
        this.jButtonLogin.setRollOverColor(new Color(224, 0, 51));
        this.jButtonLogin.setStoredBackgroundColor(new Color(238, 0, 51));
        this.jButtonLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignFrame.this.jButtonLoginMouseClicked(evt);
            }
        });
        this.jButtonLogin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SignFrame.this.jButtonLoginKeyPressed(evt);
            }
        });
        this.jButtonExitLogin.setBackground(new Color(89, 97, 100));
        this.jButtonExitLogin.setBorder(null);
        this.jButtonExitLogin.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonExitLogin.setForeground(new Color(255, 255, 255));
        this.jButtonExitLogin.setText(StringUtil.getText("main.screen.exit"));
        this.jButtonExitLogin.setArcHeight(10);
        this.jButtonExitLogin.setArcWidth(10);
        this.jButtonExitLogin.setArmedColor(new Color(120, 120, 120));
        this.jButtonExitLogin.setFocusPainted(false);
        this.jButtonExitLogin.setFont(new Font("Arial", 1, 12));
        this.jButtonExitLogin.setHorizontalTextPosition(4);
        this.jButtonExitLogin.setIconTextGap(10);
        this.jButtonExitLogin.setRollOverColor(new Color(147, 147, 147));
        this.jButtonExitLogin.setStoredBackgroundColor(new Color(89, 97, 100));
        this.jButtonExitLogin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignFrame.this.jButtonExitLoginMouseClicked(evt);
            }
        });
        this.jButtonExitLogin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SignFrame.this.jButtonExitLoginKeyPressed(evt);
            }
        });
        GroupLayout jPanelPasswordLayout = new GroupLayout(this.jPanelPassword);
        this.jPanelPassword.setLayout(jPanelPasswordLayout);
        jPanelPasswordLayout.setHorizontalGroup(jPanelPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPasswordLayout.createSequentialGroup().addGap(156, 156, 156).addComponent(this.jLabelPin).addGap(18, 18, 18).addGroup(jPanelPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPasswordLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jButtonLogin, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonExitLogin, -2, 125, -2)).addComponent(this.jPanelGetPassword, -2, -1, -2)).addContainerGap(117, Short.MAX_VALUE)));
        jPanelPasswordLayout.setVerticalGroup(jPanelPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPasswordLayout.createSequentialGroup().addGroup(jPanelPasswordLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelPasswordLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jLabelPin)).addGroup(jPanelPasswordLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanelGetPassword, -2, -1, -2))).addGap(28, 28, 28).addGroup(jPanelPasswordLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonLogin, -2, 35, -2).addComponent(this.jButtonExitLogin, -2, 35, -2)).addContainerGap(204, Short.MAX_VALUE)));
        this.jPanelChooseCert.setBackground(new Color(255, 255, 255));
        this.jPanelChooseCert.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelChooseCert.setFont(new Font("Arial", 0, 11));
        this.jPanelChooseCert.setPreferredSize(new Dimension(651, 298));
        this.jScrollPane4.setBackground(new Color(255, 255, 255));
        this.jScrollPane4.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jScrollPane4.setForeground(new Color(255, 255, 255));
        this.jScrollPane4.setCursor(new Cursor(0));
        this.jTableChooseCert.setAutoCreateRowSorter(true);
        this.jTableChooseCert.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jTableChooseCert.setFont(new Font("Arial", 0, 12));
        this.jTableChooseCert.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}}, new String[]{"Stt", "C\u1ea5p cho", "C\u1ea5p b\u1edfi", "Ng\u00e0y c\u1ea5p", "Ng\u00e0y h\u1ebft h\u1ea1n", "Tr\u1ea1ng th\u00e1i"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableChooseCert.setColumnSelectionAllowed(true);
        this.jTableChooseCert.setCursor(new Cursor(12));
        this.jTableChooseCert.setGridColor(new Color(120, 120, 120));
        this.jTableChooseCert.setRowHeight(25);
        this.jTableChooseCert.setSelectionBackground(new Color(89, 97, 100));
        this.jTableChooseCert.getTableHeader().setReorderingAllowed(false);
        this.jTableChooseCert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignFrame.this.jTableChooseCertMouseClicked(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableChooseCert);
        this.jButtonChooseCert.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonChooseCert.setBackground(new Color(238, 0, 51));
        this.jButtonChooseCert.setBorder(null);
        this.jButtonChooseCert.setForeground(new Color(255, 255, 255));
        this.jButtonChooseCert.setText(StringUtil.getText("main.screen.choose"));
        this.jButtonChooseCert.setArcHeight(10);
        this.jButtonChooseCert.setArcWidth(10);
        this.jButtonChooseCert.setArmedColor(new Color(224, 0, 51));
        this.jButtonChooseCert.setFocusPainted(false);
        this.jButtonChooseCert.setFont(new Font("Arial", 1, 12));
        this.jButtonChooseCert.setHorizontalTextPosition(4);
        this.jButtonChooseCert.setIconTextGap(10);
        this.jButtonChooseCert.setRollOverColor(new Color(224, 0, 51));
        this.jButtonChooseCert.setStoredBackgroundColor(new Color(238, 0, 51));
        this.jButtonChooseCert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SignFrame.this.jButtonChooseCertMouseClicked(evt);
            }
        });
        this.jButtonChooseCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignFrame.this.jButtonChooseCertActionPerformed(evt);
            }
        });
        this.jButtonChooseCert.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SignFrame.this.jButtonChooseCertKeyPressed(evt);
            }
        });
        this.jtitleFormLogin.setBackground(new Color(255, 153, 0));
        this.jtitleFormLogin.setFont(new Font("Arial", 1, 24));
        this.jtitleFormLogin.setForeground(new Color(89, 97, 100));
        this.jtitleFormLogin.setText(StringUtil.getText("choose.cert"));
        GroupLayout jPanelChooseCertLayout = new GroupLayout(this.jPanelChooseCert);
        this.jPanelChooseCert.setLayout(jPanelChooseCertLayout);
        jPanelChooseCertLayout.setHorizontalGroup(jPanelChooseCertLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelChooseCertLayout.createSequentialGroup().addContainerGap(299, Short.MAX_VALUE).addComponent(this.jButtonChooseCert, -2, 125, -2).addGap(276, 276, 276)).addGroup(jPanelChooseCertLayout.createSequentialGroup().addContainerGap().addComponent(this.jtitleFormLogin).addContainerGap(-1, Short.MAX_VALUE)).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 700, Short.MAX_VALUE));
        jPanelChooseCertLayout.setVerticalGroup(jPanelChooseCertLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelChooseCertLayout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jtitleFormLogin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE).addComponent(this.jScrollPane4, -2, 192, -2).addGap(29, 29, 29).addComponent(this.jButtonChooseCert, -2, 34, -2).addGap(31, 31, 31)));
        this.jLayeredPaneSignInvoice.setLayer(this.jPanelPassword, JLayeredPane.DEFAULT_LAYER);
        this.jLayeredPaneSignInvoice.setLayer(this.jPanelChooseCert, JLayeredPane.DEFAULT_LAYER);
        GroupLayout jLayeredPaneSignInvoiceLayout = new GroupLayout(this.jLayeredPaneSignInvoice);
        this.jLayeredPaneSignInvoice.setLayout(jLayeredPaneSignInvoiceLayout);
        jLayeredPaneSignInvoiceLayout.setHorizontalGroup(jLayeredPaneSignInvoiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelChooseCert, GroupLayout.Alignment.TRAILING, -1, 702, Short.MAX_VALUE).addGroup(jLayeredPaneSignInvoiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPaneSignInvoiceLayout.createSequentialGroup().addComponent(this.jPanelPassword, -2, 702, -2).addGap(0, 0, Short.MAX_VALUE))));
        jLayeredPaneSignInvoiceLayout.setVerticalGroup(jLayeredPaneSignInvoiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelChooseCert, -1, 380, Short.MAX_VALUE).addGroup(jLayeredPaneSignInvoiceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jLayeredPaneSignInvoiceLayout.createSequentialGroup().addComponent(this.jPanelPassword, -2, 130, -2).addGap(0, 249, Short.MAX_VALUE))));
        this.pnTitleBar.setBackground(new Color(89, 97, 100));
        this.jLabel16.setFont(new Font("Arial", 1, 14));
        this.jLabel16.setForeground(new Color(255, 255, 255));
        this.jLabel16.setHorizontalAlignment(0);
        this.jLabel16.setIcon(new ImageIcon(this.getClass().getResource("/Images/favicon_s.png")));
        this.jLabel16.setText("SInvoice");
        this.jLabel16.setVerticalAlignment(3);
        this.btnMiz.setBackground(new Color(89, 97, 100));
        this.btnMiz.setIcon(new ImageIcon(this.getClass().getResource("/Images/min_w.png")));
        this.btnMiz.setArmedColor(new Color(120, 120, 120));
        this.btnMiz.setRollOverColor(new Color(120, 120, 120));
        this.btnMiz.setStoredBackgroundColor(new Color(89, 97, 100));
        this.btnMiz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignFrame.this.btnMizActionPerformed(evt);
            }
        });
        this.btnClo.setBackground(new Color(89, 97, 100));
        this.btnClo.setIcon(new ImageIcon(this.getClass().getResource("/Images/close_w.png")));
        this.btnClo.setArmedColor(new Color(120, 120, 120));
        this.btnClo.setRollOverColor(new Color(120, 120, 120));
        this.btnClo.setStoredBackgroundColor(new Color(89, 97, 100));
        this.btnClo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignFrame.this.btnCloActionPerformed(evt);
            }
        });
        GroupLayout pnTitleBarLayout = new GroupLayout(this.pnTitleBar);
        this.pnTitleBar.setLayout(pnTitleBarLayout);
        pnTitleBarLayout.setHorizontalGroup(pnTitleBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnTitleBarLayout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnMiz, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClo, -2, -1, -2).addGap(6, 6, 6)));
        pnTitleBarLayout.setVerticalGroup(pnTitleBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnTitleBarLayout.createSequentialGroup().addGap(3, 3, 3).addGroup(pnTitleBarLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.btnMiz, -2, -1, -2).addComponent(this.btnClo, -2, -1, -2)).addGap(1, 1, 1)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnTitleBar, -1, -1, Short.MAX_VALUE).addComponent(this.jLayeredPaneSignInvoice, -2, -1, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnTitleBar, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLayeredPaneSignInvoice, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticatePassword() {
        try {
            boolean isStartSession;
            this.setWaitCursor();
            if (!this.checkPassword()) {
                boolean bl = false;
                return bl;
            }
            this.setVisible(false);
            String setupTableCode = this.setupChooseCertificateTable();
            if (!StringUtil.isNullOrEmpty(setupTableCode).booleanValue()) {
                switch (setupTableCode) {
                    case "NO_CERTIFICATE_WITH_TAX": {
                        WebsocketHandler.sendMessageToServer("NO_CERTIFICATE_WITH_TAX");
                        this.resetCursor();
                        break;
                    }
                    case "NO_CERT_IN_USB": {
                        WebsocketHandler.sendMessageToServer("NO_CERT_IN_USB");
                        this.resetCursor();
                        CustomedComponentUtil.showMessageToUser("no.cert.in.usb.token", "error");
                        break;
                    }
                    case "NO_INTERNET_CONNECTION": {
                        WebsocketHandler.sendMessageToServer("NO_INTERNET_CONNECTION");
                        this.resetCursor();
                        CustomedComponentUtil.showMessageToUser("cert.validation.connection.fail", "error");
                        break;
                    }
                    case "HAVE_ERROR": {
                        WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                        this.resetCursor();
                        CustomedComponentUtil.showMessageToUser("message.error", "error");
                        break;
                    }
                }
            } else {
                CustomedComponentUtil.showMessageToUser("message.error", "error");
                WebsocketHandler.sendMessageToServer("HAVE_ERROR");
            }
            if (!"SUCCESS".equals(setupTableCode)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isStartSession = Manager.getConfigObject().isSavePassword() && !Manager.isAppSessionTimerRunning();
            if (isStartSession) {
                Manager.startAppSessionTimer();
            }
            this.showChooseCertTable();
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            try {
                WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                CustomedComponentUtil.showMessageToUser("message.error", "error");
            }
            catch (Exception ex1) {
                logger.error("Have error: ", ex1);
            }
            this.setVisible(false);
        }
        finally {
            this.resetCursor();
        }
        return false;
    }

    public boolean checkPassword() {
        if (this.jPasswordField.getText().trim().length() == 0) {
            Manager.setUsbTokenPassword("");
            this.clearJpasswordField();
            this.showMessageToUser("message.enter.password", "error");
            this.focusToComponent(this.jPasswordField);
            return false;
        }
        Manager.setUsbTokenPassword(String.valueOf(this.jPasswordField.getPassword()));
        this.clearJpasswordField();
        try {
            this.secureToken = new SecureToken();
            this.secureToken.initialize();
            this.mapTokens = this.secureToken.getMapTokens(this.secureToken);
            if (this.mapTokens == null) {
                this.resetCursor();
                this.showMessageToUser("usb.token.not.found", "error");
                this.clearJpasswordField();
                return false;
            }
            if (this.mapTokens.size() > 1) {
                this.resetCursor();
                this.showMessageToUser("use.one.usb", "error");
                this.clearJpasswordField();
                return false;
            }
            if (this.secureToken.isLogin()) {
                this.secureToken.close();
            }
            Set keySet = this.mapTokens.keySet();
            Token selectedToken = null;
            for (Object obj : keySet) {
                selectedToken = (Token)this.mapTokens.get(obj);
            }
            MessageCode msgCode = this.secureToken.loginToken(Manager.getUsbTokenPassword(), selectedToken);
            if (msgCode.getResultCode() == 2) {
                this.showMessageToUser("incorrect.pass", "error");
                this.focusToComponent(this.jPasswordField);
                this.resetCursor();
                return false;
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            this.resetCursor();
            this.showMessageToUser("message.error", "error");
            this.focusToComponent(this.jPasswordField);
            return false;
        }
        return true;
    }

    private void jButtonChooseCertMouseClicked(MouseEvent evt) {
        try {
            boolean isSucess;
            int indexSelected = this.jTableChooseCert.getSelectedRow();
            if (indexSelected < 0) {
                this.showMessageToUser("not.choose.cert.yet", "error");
                return;
            }
            if (StringUtil.getText("main.screen.status.invalid").equals(this.jTableChooseCert.getValueAt(indexSelected, 5))) {
                this.showMessageToUser("message.invalid.cert", "error");
                return;
            }
            DSSPrivateKeyEntry key = Manager.getListSignPrivateKeys().get(indexSelected);
            if (taxCode != null && !taxCode.isEmpty() && listSignPrivateKeys != null && !listSignPrivateKeys.isEmpty()) {
                key = listSignPrivateKeys.get(indexSelected);
            }
            if (isSucess = UsbTokenBussiness.sendChoosenCertificate(key, taxCode)) {
                this.setVisible(false);
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            try {
                WebsocketHandler.sendMessageToServer("HAVE_ERROR");
            }
            catch (Exception ex) {
                logger.error("Have error: ", ex);
            }
            this.setVisible(false);
            CustomedComponentUtil.showMessageToUser("message.error", "error");
        }
    }

    private void jButtonChooseCertKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                boolean isSucess;
                int indexSelected = this.jTableChooseCert.getSelectedRow();
                if (indexSelected < 0) {
                    this.showMessageToUser("not.choose.cert.yet", "error");
                    return;
                }
                if (StringUtil.getText("main.screen.status.invalid").equals(this.jTableChooseCert.getValueAt(indexSelected, 4))) {
                    this.showMessageToUser("message.invalid.cert", "error");
                    return;
                }
                DSSPrivateKeyEntry key = Manager.getListSignPrivateKeys().get(indexSelected);
                if (taxCode != null && !taxCode.isEmpty() && listSignPrivateKeys != null && !listSignPrivateKeys.isEmpty()) {
                    key = listSignPrivateKeys.get(indexSelected);
                }
                if (isSucess = UsbTokenBussiness.sendChoosenCertificate(key, taxCode)) {
                    this.setVisible(false);
                }
            }
            catch (Exception e2) {
                logger.error("Have error: ", e2);
                try {
                    WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                }
                this.setVisible(false);
                CustomedComponentUtil.showMessageToUser("message.error", "error");
            }
        }
    }

    private void jTableChooseCertMouseClicked(MouseEvent evt) {
    }

    private void jButtonSeePasswordFocusGained(FocusEvent evt) {
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 204), 1));
        this.jPanelGetPassword.setFocus(true);
        this.jButtonSeePassword.setBackground(new Color(0, 204, 204));
    }

    private void jButtonSeePasswordFocusLost(FocusEvent evt) {
        this.jPanelGetPassword.setFocus(false);
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1));
        this.jButtonSeePassword.setBackground(new Color(255, 255, 255));
    }

    private void jButtonSeePasswordMousePressed(MouseEvent evt) {
        this.jPasswordField.setEchoChar('\u0000');
        this.jPanelGetPassword.setFocus(true);
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 204), 1));
        this.jButtonSeePassword.setBackground(new Color(12, 179, 197));
        this.jButtonSeePassword.setIcon(this.getImageIcon("close_eye.png"));
    }

    private void jButtonSeePasswordMouseReleased(MouseEvent evt) {
        this.jPasswordField.setEchoChar('*');
        this.jButtonSeePassword.setBackground(Color.WHITE);
        this.jButtonSeePassword.setIcon(this.getImageIcon("eye.png"));
    }

    private void jButtonSeePasswordActionPerformed(ActionEvent evt) {
    }

    private void jButtonSeePasswordKeyPressed(KeyEvent evt) {
        this.jPasswordField.setEchoChar('\u0000');
        this.jButtonSeePassword.setIcon(this.getImageIcon("close_eye.png"));
    }

    private void jButtonSeePasswordKeyReleased(KeyEvent evt) {
        this.jPasswordField.setEchoChar('*');
        this.jButtonSeePassword.setIcon(this.getImageIcon("eye.png"));
    }

    private void jPasswordFieldFocusGained(FocusEvent evt) {
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 204), 1));
        this.jPanelGetPassword.setFocus(true);
    }

    private void jPasswordFieldFocusLost(FocusEvent evt) {
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(Color.WHITE, 1));
        this.jPanelGetPassword.setFocus(false);
    }

    private void jPasswordFieldMousePressed(MouseEvent evt) {
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(0, 204, 204), 1));
        this.jPanelGetPassword.setFocus(true);
    }

    private void jPasswordFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (Manager.isAppSessionTimerRunning() && Manager.getListSignPrivateKeys() != null && !Manager.getListSignPrivateKeys().isEmpty()) {
                this.clearJpasswordField();
                this.showMessageToUser("pass.already.confirmed", "error");
                return;
            }
            this.authenticatePassword();
        }
    }

    private void jButtonLoginMouseClicked(MouseEvent evt) {
        if (Manager.isAppSessionTimerRunning() && Manager.getListSignPrivateKeys() != null && !Manager.getListSignPrivateKeys().isEmpty()) {
            this.clearJpasswordField();
            this.showMessageToUser("pass.already.confirmed", "error");
            return;
        }
        this.authenticatePassword();
    }

    private void jButtonLoginKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            if (Manager.isAppSessionTimerRunning() && Manager.getListSignPrivateKeys() != null && !Manager.getListSignPrivateKeys().isEmpty()) {
                this.clearJpasswordField();
                this.showMessageToUser("pass.already.confirmed", "error");
                return;
            }
            this.authenticatePassword();
        }
    }

    private void jButtonExitLoginMouseClicked(MouseEvent evt) {
        try {
            if (this.isSigning() && WebsocketHandler.getSessionReal() != null) {
                int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), "getCert".equals(Manager.getTask()) ? StringUtil.getText("ask.cancel.signing") : StringUtil.getText("ask.cancel.upload.cert"));
                if (option == 1) {
                    return;
                }
                this.setWaitCursor();
                if (!Manager.getConfigObject().isSavePassword()) {
                    Manager.closeToken();
                }
                WebsocketHandler.sendMessageToServer("FORCE_CLOSE");
                Manager.stopSigning();
                this.setVisible(false);
                WebsocketHandler.setSessionReal(null);
                this.resetCursor();
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    private void jButtonExitLoginKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                if (this.isSigning() && WebsocketHandler.getSessionReal() != null) {
                    int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), "getCert".equals(Manager.getTask()) ? StringUtil.getText("ask.cancel.signing") : StringUtil.getText("ask.cancel.upload.cert"));
                    if (option == 1) {
                        return;
                    }
                    this.setWaitCursor();
                    if (!Manager.getConfigObject().isSavePassword()) {
                        Manager.closeToken();
                    }
                    WebsocketHandler.sendMessageToServer("FORCE_CLOSE");
                    Manager.stopSigning();
                    this.setVisible(false);
                    WebsocketHandler.setSessionReal(null);
                    this.resetCursor();
                }
            }
            catch (Exception ex) {
                logger.error("Have error: ", ex);
            }
        }
    }

    private void jPanelPasswordMousePressed(MouseEvent evt) {
        this.jPanelGetPassword.setFocus(false);
        this.jPanelGetPassword.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1));
        this.jButtonLogin.setFocus(false);
        this.jButtonLogin.setBackground(new Color(21, 120, 201));
        this.jButtonExitLogin.setFocus(false);
        this.jButtonExitLogin.setBackground(new Color(130, 130, 130));
    }

    private void jButtonChooseCertActionPerformed(ActionEvent evt) {
    }

    private void btnMizActionPerformed(ActionEvent evt) {
        this.setState(1);
    }

    private void btnCloActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public void showChooseCertTable() {
        this.setVisible(true);
        this.jPanelPassword.setVisible(false);
        this.jPanelChooseCert.setVisible(true);
        this.focusToComponent(this.jTableChooseCert);
        this.setSize(this.getWidth(), 407);
    }

    public void showEnterPasswordPanel() {
        this.setVisible(true);
        this.jPanelPassword.setVisible(true);
        this.jPanelChooseCert.setVisible(false);
        this.focusToComponent(this.jPasswordField);
        this.setSize(this.getWidth(), 157);
    }

    public void focusToJPasswordField() {
        this.focusToComponent(this.jPasswordField);
    }

    public void clearJpasswordField() {
        this.jPasswordField.setText("");
    }

    public void clearJtableChooseCert(String taxCode) {
        this.jTableChooseCert.setModel(new DefaultTableModel());
        SignFrame.taxCode = taxCode;
    }

    public boolean isSigning() {
        return Manager.isIsSigning();
    }

    public String setupChooseCertificateTable() {
        try {
            if (!Manager.isAppSessionTimerRunning()) {
                String listFileLib = PropertiesUtils.getResource("libraries");
                String[] pkcs11LibraryNames = listFileLib.split(";");
                Manager.setListSignPrivateKeys(new ArrayList<DSSPrivateKeyEntry>());
                Manager.setToken(null);
                for (int i2 = 0; i2 < pkcs11LibraryNames.length; ++i2) {
                    String pkcs11LibraryFileName = System.getenv("windir") + "\\system32\\" + pkcs11LibraryNames[i2];
                    File pkcs11LibraryFile = new File(pkcs11LibraryFileName);
                    if (!pkcs11LibraryFile.exists()) continue;
                    Manager.setToken(new Pkcs11SignatureToken(pkcs11LibraryFileName, Manager.getUsbTokenPassword().toCharArray()));
                    try {
                        Manager.getListSignPrivateKeys().clear();
                        List<DSSPrivateKeyEntry> keys = Manager.getToken().getKeys();
                        Manager.getListSignPrivateKeys().addAll(keys);
                        if (Manager.getListSignPrivateKeys().isEmpty()) continue;
                        break;
                    }
                    catch (Exception ex) {
                        logger.error("File: can''t login to get keys " + pkcs11LibraryFileName);
                        logger.info(ex.getMessage());
                        logger.error("Exception", ex);
                    }
                }
                if (Manager.getListSignPrivateKeys() == null || Manager.getListSignPrivateKeys().isEmpty()) {
                    this.focusToComponent(this.jTableChooseCert);
                    Manager.closeToken();
                    return "NO_CERT_IN_USB";
                }
            }
            listSignPrivateKeys = new ArrayList<DSSPrivateKeyEntry>();
            int i3 = 0;
            int numberSelect = -1;
            DefaultTableModel model = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            model.addColumn(StringUtil.getText("stt"));
            model.addColumn(StringUtil.getText("main.screen.granted.for"));
            model.addColumn(StringUtil.getText("main.screen.granted.by"));
            model.addColumn(StringUtil.getText("main.screen.issued.date"));
            model.addColumn(StringUtil.getText("main.screen.end.date"));
            model.addColumn(StringUtil.getText("main.screen.status"));
            int numValidCert = 0;
            logger.info("=====> Number of certificate existed in usb-token: " + Manager.getListSignPrivateKeys().size());
            for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                if (Manager.getConfigObject() != null && !StringUtil.isNullOrEmpty(Manager.getDefaultCertSerial()).booleanValue()) {
                    String serialUpper = Manager.getDefaultCertSerial().toUpperCase().trim();
                    String entrySerial = entry.getCertificate().getSerialNumber().toString(16).toUpperCase();
                    if (serialUpper != null && !"".equals(serialUpper) && serialUpper.equals(entrySerial)) {
                        numberSelect = i3;
                    }
                }
                if (taxCode != null) {
                    if (!"".equals(taxCode)) {
                        String dn = entry.getCertificate().getSubjectDN().toString();
                        if (dn != null && dn.length() > 0 && dn.contains("OID.0.9.2342.19200300.100.1.1")) {
                            dn = dn.replace("OID.0.9.2342.19200300.100.1.1", "UID");
                        }
                        String[] parts = dn.split(",");
                        boolean isExist = false;
                        for (String part : parts) {
                            String[] subPart;
                            String cerTaxCode = "";
                            if (part.contains("UID=MST:") && (subPart = part.split(":")).length > 1) {
                                cerTaxCode = subPart[1].trim();
                            }
                            if (!cerTaxCode.equals(taxCode)) continue;
                            isExist = true;
                        }
                        if (!isExist) continue;
                    }
                }
                listSignPrivateKeys.add(entry);
                logger.info("=====> entry.getCertificate().getSerialNumber():" + entry.getCertificate().getSerialNumber().toString(16).toUpperCase());
                ++i3;
                Date today = new Date();
                Date noBeforeDate = entry.getCertificate().getNotBefore();
                Date noAfterDate = entry.getCertificate().getNotAfter();
                logger.info("=====> Enterprise : " + entry.getCertificate().getSubjectShortName());
                boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
                boolean isValidCert = false;
                if (isValidDate) {
                    if (!Manager.isAppSessionTimerRunning() || entry.getCertificate().getValid() == null) {
                        try {
                            isValidCert = CheckOcspOrCrl.checkCertificateOCSP(entry.getCertificate().getCertificate());
                            logger.info("=====> isValidCert " + isValidCert);
                        }
                        catch (ConnectException | SocketTimeoutException ex) {
                            logger.error("Exception", ex);
                            logger.info("Can't connect to server validate certificate");
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "NO_INTERNET_CONNECTION";
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "HAVE_ERROR";
                        }
                    } else {
                        isValidCert = entry.getCertificate().getValid();
                    }
                }
                if (isValidDate && isValidCert) {
                    model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.valid")});
                    entry.getCertificate().setValid(true);
                    ++numValidCert;
                    continue;
                }
                model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.invalid")});
                entry.getCertificate().setValid(false);
            }
            if (taxCode != null) {
                if (!"".equals(taxCode) && i3 == 0) {
                    return "NO_CERTIFICATE_WITH_TAX";
                }
            }
            logger.info("=====> Number of valid certificate  in usb-token: " + numValidCert);
            this.jTableChooseCert.setModel(model);
            this.jTableChooseCert.setRowHeight(25);
            this.jTableChooseCert.setVisible(true);
            this.jTableChooseCert.setColumnSelectionAllowed(false);
            this.jTableChooseCert.setRowSelectionAllowed(true);
            this.jTableChooseCert.setSelectionMode(0);
            CustomedComponentUtil.customTable(this, this.jTableChooseCert);
            if (numberSelect != -1) {
                this.jTableChooseCert.setRowSelectionInterval(numberSelect, numberSelect);
            }
            return "SUCCESS";
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            this.focusToComponent(this.jTableChooseCert);
            Manager.closeToken();
            return "HAVE_ERROR";
        }
    }

    private void focusToComponent(Component component) {
        component.requestFocus();
    }

    private ImageIcon getImageIcon(String name) {
        if (StringUtil.isNullOrEmpty(name).booleanValue()) {
            return new ImageIcon();
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Images/" + name)));
    }

    public void setWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.jButtonChooseCert.setCursor(Cursor.getPredefinedCursor(3));
        this.jButtonExitLogin.setCursor(Cursor.getPredefinedCursor(3));
        this.jButtonLogin.setCursor(Cursor.getPredefinedCursor(3));
        this.jButtonSeePassword.setCursor(Cursor.getPredefinedCursor(3));
        this.jLabelPin.setCursor(Cursor.getPredefinedCursor(3));
        this.jPanelChooseCert.setCursor(Cursor.getPredefinedCursor(3));
        this.jPanelGetPassword.setCursor(Cursor.getPredefinedCursor(3));
        this.jPanelPassword.setCursor(Cursor.getPredefinedCursor(3));
        this.jPasswordField.setCursor(Cursor.getPredefinedCursor(3));
        this.jScrollPane4.setCursor(Cursor.getPredefinedCursor(3));
        this.jTableChooseCert.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void resetCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.jButtonChooseCert.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonExitLogin.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonLogin.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonSeePassword.setCursor(Cursor.getPredefinedCursor(12));
        this.jLabelPin.setCursor(Cursor.getPredefinedCursor(0));
        this.jPanelChooseCert.setCursor(Cursor.getPredefinedCursor(0));
        this.jPanelGetPassword.setCursor(Cursor.getPredefinedCursor(0));
        this.jPanelPassword.setCursor(Cursor.getPredefinedCursor(0));
        this.jPasswordField.setCursor(Cursor.getPredefinedCursor(2));
        this.jScrollPane4.setCursor(Cursor.getPredefinedCursor(0));
        this.jTableChooseCert.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void refresh() {
        this.jLabelPin.setText(StringUtil.getText("main.screen.pin"));
        this.jButtonSeePassword.setToolTipText(StringUtil.getText("see.pass"));
        this.jButtonLogin.setText(StringUtil.getText("authenticate"));
        this.jButtonExitLogin.setText(StringUtil.getText("main.screen.exit"));
        this.jButtonChooseCert.setText(StringUtil.getText("main.screen.choose"));
        this.jtitleFormLogin.setText(StringUtil.getText("choose.cert"));
        CustomedComponentUtil.updateTable(this.jTableChooseCert);
    }

    public void showMessageToUser(String message, String type) {
        CustomedComponentUtil.showMessageToUser(this, message, type);
    }

    public void appearOnTop() {
        this.setState(0);
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    public boolean isIsTableOpen() {
        return this.isTableOpen;
    }

    public void setIsTableOpen(boolean isTableOpen) {
        this.isTableOpen = isTableOpen;
    }

    public Map getMapTokens() {
        return this.mapTokens;
    }

    public void setMapTokens(Map mapTokens) {
        this.mapTokens = mapTokens;
    }

    public SecureToken getSecureToken() {
        return this.secureToken;
    }

    public void setSecureToken(SecureToken secureToken) {
        this.secureToken = secureToken;
    }

    public String[] getTokenNames() {
        return this.tokenNames;
    }

    public void setTokenNames(String[] tokenNames) {
        this.tokenNames = tokenNames;
    }

    public RoundedCornerJButton getjButtonChooseCert() {
        return this.jButtonChooseCert;
    }

    public void setjButtonChooseCert(RoundedCornerJButton jButtonChooseCert) {
        this.jButtonChooseCert = jButtonChooseCert;
    }

    public RoundedCornerJButton getjButtonExitLogin() {
        return this.jButtonExitLogin;
    }

    public void setjButtonExitLogin(RoundedCornerJButton jButtonExitLogin) {
        this.jButtonExitLogin = jButtonExitLogin;
    }

    public RoundedCornerJButton getjButtonLogin() {
        return this.jButtonLogin;
    }

    public void setjButtonLogin(RoundedCornerJButton jButtonLogin) {
        this.jButtonLogin = jButtonLogin;
    }

    public JButton getjButtonSeePassword() {
        return this.jButtonSeePassword;
    }

    public void setjButtonSeePassword(JButton jButtonSeePassword) {
        this.jButtonSeePassword = jButtonSeePassword;
    }

    public JLabel getjLabelPin() {
        return this.jLabelPin;
    }

    public void setjLabelPin(JLabel jLabelPin) {
        this.jLabelPin = jLabelPin;
    }

    public JPanel getjPanelChooseCert() {
        return this.jPanelChooseCert;
    }

    public void setjPanelChooseCert(JPanel jPanelChooseCert) {
        this.jPanelChooseCert = jPanelChooseCert;
    }

    public RoundedCornerJPanel getjPanelGetPassword() {
        return this.jPanelGetPassword;
    }

    public void setjPanelGetPassword(RoundedCornerJPanel jPanelGetPassword) {
        this.jPanelGetPassword = jPanelGetPassword;
    }

    public JPanel getjPanelPassword() {
        return this.jPanelPassword;
    }

    public void setjPanelPassword(JPanel jPanelPassword) {
        this.jPanelPassword = jPanelPassword;
    }

    public JPasswordField getjPasswordField() {
        return this.jPasswordField;
    }

    public void setjPasswordField(JPasswordField jPasswordField) {
        this.jPasswordField = jPasswordField;
    }

    public JScrollPane getjScrollPane4() {
        return this.jScrollPane4;
    }

    public void setjScrollPane4(JScrollPane jScrollPane4) {
        this.jScrollPane4 = jScrollPane4;
    }

    public JTable getjTableChooseCert() {
        return this.jTableChooseCert;
    }

    public void setjTableChooseCert(JTable jTableChooseCert) {
        this.jTableChooseCert = jTableChooseCert;
    }

    public JLayeredPane getjLayeredPaneSignInvoice() {
        return this.jLayeredPaneSignInvoice;
    }

    public void setjLayeredPaneSignInvoice(JLayeredPane jLayeredPaneSignInvoice) {
        this.jLayeredPaneSignInvoice = jLayeredPaneSignInvoice;
    }

    public JLabel getJtitleFormLogin() {
        return this.jtitleFormLogin;
    }

    public void setJtitleFormLogin(JLabel jtitleFormLogin) {
        this.jtitleFormLogin = jtitleFormLogin;
    }
}

