/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.view;

import com.viettel.einvoice.verify.CheckOcspOrCrl;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import eu.europa.esig.dss.token.usb.UsbTokenBussiness;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.DateTimeUtils;
import eu.europa.esig.dss.token.utils.PropertiesUtils;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import viettel.custom.swing.RoundedCornerJButton;

public class ChooseCertificateTableFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(ChooseCertificateTableFrame.class.getName());
    private static String taxCode = null;
    private static List<DSSPrivateKeyEntry> listSignPrivateKeys = new ArrayList<DSSPrivateKeyEntry>();
    private int x;
    private int y;
    private RoundedCornerJButton btnClo1;
    private RoundedCornerJButton btnMiz1;
    private RoundedCornerJButton jButtonChooseCert;
    private JLabel jLabel17;
    private JPanel jPanelChooseCert;
    private JPanel jPanelTitle;
    private JScrollPane jScrollPane4;
    private JTable jTableChooseCert;
    private JLabel jtitleFormLogin;
    private JPanel pnTitleBar1;

    public ChooseCertificateTableFrame() {
        this.initComponents();
        CustomedComponentUtil.setIconForFrame(this);
        this.initMoving(this);
    }

    private void initMoving(final JFrame frame) {
        this.pnTitleBar1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                ChooseCertificateTableFrame.this.x = e2.getX();
                ChooseCertificateTableFrame.this.y = e2.getY();
            }
        });
        this.pnTitleBar1.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e2) {
                frame.setLocation(e2.getXOnScreen() - ChooseCertificateTableFrame.this.x, e2.getYOnScreen() - ChooseCertificateTableFrame.this.y);
            }
        });
    }

    private void initComponents() {
        this.jPanelChooseCert = new JPanel();
        this.jButtonChooseCert = new RoundedCornerJButton();
        this.jScrollPane4 = new JScrollPane();
        this.jTableChooseCert = new JTable();
        this.jPanelTitle = new JPanel();
        this.jtitleFormLogin = new JLabel();
        this.pnTitleBar1 = new JPanel();
        this.jLabel17 = new JLabel();
        this.btnMiz1 = new RoundedCornerJButton();
        this.btnClo1 = new RoundedCornerJButton();
        this.setBackground(new Color(255, 255, 255));
        this.setUndecorated(true);
        this.setResizable(false);
        this.jPanelChooseCert.setBackground(new Color(255, 255, 255));
        this.jPanelChooseCert.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jPanelChooseCert.setPreferredSize(new Dimension(651, 300));
        this.jButtonChooseCert.setCursor(Cursor.getPredefinedCursor(12));
        this.jButtonChooseCert.setBackground(new Color(238, 0, 51));
        this.jButtonChooseCert.setBorder(null);
        this.jButtonChooseCert.setForeground(new Color(255, 255, 255));
        this.jButtonChooseCert.setText(StringUtil.getText("main.screen.choose"));
        this.jButtonChooseCert.setArcHeight(10);
        this.jButtonChooseCert.setArcWidth(10);
        this.jButtonChooseCert.setArmedColor(new Color(224, 0, 51));
        this.jButtonChooseCert.setFocusPainted(false);
        this.jButtonChooseCert.setFont(new Font("Arial", 1, 12));
        this.jButtonChooseCert.setHorizontalTextPosition(4);
        this.jButtonChooseCert.setIconTextGap(10);
        this.jButtonChooseCert.setRollOverColor(new Color(224, 0, 51));
        this.jButtonChooseCert.setStoredBackgroundColor(new Color(238, 0, 51));
        this.jButtonChooseCert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChooseCertificateTableFrame.this.jButtonChooseCertMouseClicked(evt);
            }
        });
        this.jButtonChooseCert.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChooseCertificateTableFrame.this.jButtonChooseCertKeyPressed(evt);
            }
        });
        this.jScrollPane4.setBackground(new Color(255, 255, 255));
        this.jScrollPane4.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jScrollPane4.setForeground(new Color(255, 255, 255));
        this.jScrollPane4.setCursor(new Cursor(0));
        this.jTableChooseCert.setAutoCreateRowSorter(true);
        this.jTableChooseCert.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jTableChooseCert.setFont(new Font("Arial", 0, 12));
        this.jTableChooseCert.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}, {null, null, null, null, null, null}}, new String[]{"Stt", "C\u1ea5p cho", "C\u1ea5p b\u1edfi", "Ng\u00e0y c\u1ea5p", "Ng\u00e0y h\u1ebft h\u1ea1n", "Tr\u1ea1ng th\u00e1i"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableChooseCert.setColumnSelectionAllowed(true);
        this.jTableChooseCert.setCursor(new Cursor(12));
        this.jTableChooseCert.setGridColor(new Color(120, 120, 120));
        this.jTableChooseCert.setRowHeight(25);
        this.jTableChooseCert.setSelectionBackground(new Color(89, 97, 100));
        this.jTableChooseCert.getTableHeader().setReorderingAllowed(false);
        this.jTableChooseCert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChooseCertificateTableFrame.this.jTableChooseCertMouseClicked(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.jTableChooseCert);
        GroupLayout jPanelChooseCertLayout = new GroupLayout(this.jPanelChooseCert);
        this.jPanelChooseCert.setLayout(jPanelChooseCertLayout);
        jPanelChooseCertLayout.setHorizontalGroup(jPanelChooseCertLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelChooseCertLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonChooseCert, -2, 125, -2).addGap(273, 273, 273)).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 700, Short.MAX_VALUE));
        jPanelChooseCertLayout.setVerticalGroup(jPanelChooseCertLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelChooseCertLayout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 192, -2).addGap(26, 26, 26).addComponent(this.jButtonChooseCert, -2, 35, -2).addGap(22, 22, 22)));
        this.jPanelTitle.setBackground(new Color(255, 255, 255));
        this.jPanelTitle.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.jtitleFormLogin.setBackground(new Color(255, 153, 0));
        this.jtitleFormLogin.setFont(new Font("Arial", 1, 24));
        this.jtitleFormLogin.setForeground(new Color(89, 97, 100));
        this.jtitleFormLogin.setText(StringUtil.getText("choose.cert"));
        GroupLayout jPanelTitleLayout = new GroupLayout(this.jPanelTitle);
        this.jPanelTitle.setLayout(jPanelTitleLayout);
        jPanelTitleLayout.setHorizontalGroup(jPanelTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTitleLayout.createSequentialGroup().addContainerGap().addComponent(this.jtitleFormLogin).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelTitleLayout.setVerticalGroup(jPanelTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTitleLayout.createSequentialGroup().addContainerGap().addComponent(this.jtitleFormLogin).addContainerGap(33, Short.MAX_VALUE)));
        this.pnTitleBar1.setBackground(new Color(89, 97, 100));
        this.jLabel17.setFont(new Font("Arial", 1, 14));
        this.jLabel17.setForeground(new Color(255, 255, 255));
        this.jLabel17.setHorizontalAlignment(0);
        this.jLabel17.setIcon(new ImageIcon(this.getClass().getResource("/Images/favicon_s.png")));
        this.jLabel17.setText("SInvoice");
        this.jLabel17.setVerticalAlignment(3);
        this.btnMiz1.setBackground(new Color(89, 97, 100));
        this.btnMiz1.setIcon(new ImageIcon(this.getClass().getResource("/Images/min_w.png")));
        this.btnMiz1.setArmedColor(new Color(120, 120, 120));
        this.btnMiz1.setRollOverColor(new Color(120, 120, 120));
        this.btnMiz1.setStoredBackgroundColor(new Color(89, 97, 100));
        this.btnMiz1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseCertificateTableFrame.this.btnMiz1ActionPerformed(evt);
            }
        });
        this.btnClo1.setBackground(new Color(89, 97, 100));
        this.btnClo1.setIcon(new ImageIcon(this.getClass().getResource("/Images/close_w.png")));
        this.btnClo1.setArmedColor(new Color(120, 120, 120));
        this.btnClo1.setRollOverColor(new Color(120, 120, 120));
        this.btnClo1.setStoredBackgroundColor(new Color(89, 97, 100));
        this.btnClo1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseCertificateTableFrame.this.btnClo1ActionPerformed(evt);
            }
        });
        GroupLayout pnTitleBar1Layout = new GroupLayout(this.pnTitleBar1);
        this.pnTitleBar1.setLayout(pnTitleBar1Layout);
        pnTitleBar1Layout.setHorizontalGroup(pnTitleBar1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnTitleBar1Layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnMiz1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClo1, -2, -1, -2).addGap(6, 6, 6)));
        pnTitleBar1Layout.setVerticalGroup(pnTitleBar1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnTitleBar1Layout.createSequentialGroup().addGap(3, 3, 3).addGroup(pnTitleBar1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel17).addComponent(this.btnMiz1, -2, -1, -2).addComponent(this.btnClo1, -2, -1, -2)).addGap(1, 1, 1)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelChooseCert, -1, 702, Short.MAX_VALUE).addComponent(this.jPanelTitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnTitleBar1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnTitleBar1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jPanelTitle, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE).addComponent(this.jPanelChooseCert, -2, 277, -2).addGap(1, 1, 1)));
        this.pack();
    }

    private void jButtonChooseCertMouseClicked(MouseEvent evt) {
        try {
            boolean isSucess;
            int indexSelected = this.jTableChooseCert.getSelectedRow();
            if (indexSelected < 0) {
                this.showMessageToUser("not.choose.cert.yet", "error");
                return;
            }
            if (StringUtil.getText("main.screen.status.invalid").equals(this.jTableChooseCert.getValueAt(indexSelected, 5))) {
                this.showMessageToUser("message.invalid.cert", "error");
                return;
            }
            DSSPrivateKeyEntry key = Manager.getListSignPrivateKeys().get(indexSelected);
            if (taxCode != null && !taxCode.isEmpty() && listSignPrivateKeys != null && !listSignPrivateKeys.isEmpty()) {
                key = listSignPrivateKeys.get(indexSelected);
            }
            if (isSucess = UsbTokenBussiness.sendChoosenCertificate(key, taxCode)) {
                this.setVisible(false);
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            try {
                WebsocketHandler.sendMessageToServer("HAVE_ERROR");
            }
            catch (Exception ex) {
                logger.error("Have error: ", ex);
            }
            this.showMessageToUser("message.error", "error");
            this.setVisible(false);
        }
    }

    private void jButtonChooseCertKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            try {
                boolean isSucess;
                int indexSelected = this.jTableChooseCert.getSelectedRow();
                if (indexSelected < 0) {
                    this.showMessageToUser("not.choose.cert.yet", "error");
                    return;
                }
                if (StringUtil.getText("main.screen.status.invalid").equals(this.jTableChooseCert.getValueAt(indexSelected, 4))) {
                    this.showMessageToUser("message.invalid.cert", "error");
                    return;
                }
                DSSPrivateKeyEntry key = Manager.getListSignPrivateKeys().get(indexSelected);
                if (taxCode != null && !taxCode.isEmpty() && listSignPrivateKeys != null && !listSignPrivateKeys.isEmpty()) {
                    key = listSignPrivateKeys.get(indexSelected);
                }
                if (isSucess = UsbTokenBussiness.sendChoosenCertificate(key, taxCode)) {
                    this.setVisible(false);
                }
            }
            catch (Exception e2) {
                logger.error("Have error: ", e2);
                try {
                    WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                }
                this.showMessageToUser("message.error", "error");
                this.setVisible(false);
            }
        }
    }

    private void jTableChooseCertMouseClicked(MouseEvent evt) {
    }

    private void btnMiz1ActionPerformed(ActionEvent evt) {
        this.setState(1);
    }

    private void btnClo1ActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public String setupChooseCertificateTable() {
        taxCode = null;
        try {
            if (!Manager.isAppSessionTimerRunning()) {
                String listFileLib = PropertiesUtils.getResource("libraries");
                String[] pkcs11LibraryNames = listFileLib.split(";");
                Manager.setListSignPrivateKeys(new ArrayList<DSSPrivateKeyEntry>());
                Manager.setToken(null);
                for (int i2 = 0; i2 < pkcs11LibraryNames.length; ++i2) {
                    String pkcs11LibraryFileName = System.getenv("windir") + "\\system32\\" + pkcs11LibraryNames[i2];
                    File pkcs11LibraryFile = new File(pkcs11LibraryFileName);
                    if (!pkcs11LibraryFile.exists()) continue;
                    Manager.setToken(new Pkcs11SignatureToken(pkcs11LibraryFileName, Manager.getUsbTokenPassword().toCharArray()));
                    try {
                        Manager.getListSignPrivateKeys().clear();
                        List<DSSPrivateKeyEntry> keys = Manager.getToken().getKeys();
                        Manager.getListSignPrivateKeys().addAll(keys);
                        if (Manager.getListSignPrivateKeys().isEmpty()) continue;
                        break;
                    }
                    catch (Exception ex) {
                        logger.info("File: can''t login to get keys " + pkcs11LibraryFileName);
                        logger.error("Exception", ex);
                    }
                }
                if (Manager.getListSignPrivateKeys() == null || Manager.getListSignPrivateKeys().isEmpty()) {
                    this.focusToComponent(this.jTableChooseCert);
                    Manager.closeToken();
                    return "NO_CERT_IN_USB";
                }
            }
            int i3 = 0;
            int numberSelect = -1;
            DefaultTableModel model = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            model.addColumn(StringUtil.getText("stt"));
            model.addColumn(StringUtil.getText("main.screen.granted.for"));
            model.addColumn(StringUtil.getText("main.screen.granted.by"));
            model.addColumn(StringUtil.getText("main.screen.issued.date"));
            model.addColumn(StringUtil.getText("main.screen.end.date"));
            model.addColumn(StringUtil.getText("main.screen.status"));
            int numValidCert = 0;
            logger.info("=====> Number of certificate existed in usb-token: " + Manager.getListSignPrivateKeys().size());
            for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                if (Manager.getConfigObject() != null && !StringUtil.isNullOrEmpty(Manager.getDefaultCertSerial()).booleanValue()) {
                    String serialUpper = Manager.getDefaultCertSerial().toUpperCase().trim();
                    String entrySerial = entry.getCertificate().getSerialNumber().toString(16).toUpperCase();
                    if (serialUpper != null && !"".equals(serialUpper) && serialUpper.equals(entrySerial)) {
                        numberSelect = i3;
                    }
                }
                logger.info("=====> entry.getCertificate().getSerialNumber():" + entry.getCertificate().getSerialNumber().toString(16).toUpperCase());
                ++i3;
                Date today = new Date();
                Date noBeforeDate = entry.getCertificate().getNotBefore();
                Date noAfterDate = entry.getCertificate().getNotAfter();
                logger.info("=====> Enterprise : " + entry.getCertificate().getSubjectShortName());
                boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
                boolean isValidCert = false;
                if (isValidDate) {
                    if (!Manager.isAppSessionTimerRunning() || entry.getCertificate().getValid() == null) {
                        try {
                            isValidCert = CheckOcspOrCrl.checkCertificateOCSP(entry.getCertificate().getCertificate());
                            logger.info("=====> isValidCert " + isValidCert);
                        }
                        catch (ConnectException | SocketTimeoutException ex) {
                            logger.info("Can't connect to server validate certificate");
                            logger.error("Exception", ex);
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "NO_INTERNET_CONNECTION_SETUP_TABLE";
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "HAVE_ERROR";
                        }
                    } else {
                        isValidCert = entry.getCertificate().getValid();
                    }
                }
                if (isValidDate && isValidCert) {
                    model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.valid")});
                    entry.getCertificate().setValid(true);
                    ++numValidCert;
                    continue;
                }
                model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.invalid")});
                entry.getCertificate().setValid(false);
            }
            logger.info("=====> Number of valid certificate  in usb-token: " + numValidCert);
            this.jTableChooseCert.setModel(model);
            this.jTableChooseCert.setRowHeight(25);
            this.jTableChooseCert.setVisible(true);
            this.jTableChooseCert.setColumnSelectionAllowed(false);
            this.jTableChooseCert.setRowSelectionAllowed(true);
            this.jTableChooseCert.setSelectionMode(0);
            CustomedComponentUtil.customTable(this, this.jTableChooseCert);
            if (numberSelect != -1) {
                this.jTableChooseCert.setRowSelectionInterval(numberSelect, numberSelect);
            }
            return "SUCCESS";
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            this.focusToComponent(this.jTableChooseCert);
            Manager.closeToken();
            return "HAVE_ERROR";
        }
    }

    public String setupChooseCertificateTable(String taxCode) {
        ChooseCertificateTableFrame.taxCode = taxCode;
        try {
            if (!Manager.isAppSessionTimerRunning()) {
                String listFileLib = PropertiesUtils.getResource("libraries");
                String[] pkcs11LibraryNames = listFileLib.split(";");
                Manager.setListSignPrivateKeys(new ArrayList<DSSPrivateKeyEntry>());
                Manager.setToken(null);
                for (int i2 = 0; i2 < pkcs11LibraryNames.length; ++i2) {
                    String pkcs11LibraryFileName = System.getenv("windir") + "\\system32\\" + pkcs11LibraryNames[i2];
                    File pkcs11LibraryFile = new File(pkcs11LibraryFileName);
                    if (!pkcs11LibraryFile.exists()) continue;
                    Manager.setToken(new Pkcs11SignatureToken(pkcs11LibraryFileName, Manager.getUsbTokenPassword().toCharArray()));
                    try {
                        Manager.getListSignPrivateKeys().clear();
                        List<DSSPrivateKeyEntry> keys = Manager.getToken().getKeys();
                        Manager.getListSignPrivateKeys().addAll(keys);
                        if (Manager.getListSignPrivateKeys().isEmpty()) continue;
                        break;
                    }
                    catch (Exception ex) {
                        logger.info("File: can''t login to get keys " + pkcs11LibraryFileName);
                        logger.error("Exception", ex);
                    }
                }
                if (Manager.getListSignPrivateKeys() == null || Manager.getListSignPrivateKeys().isEmpty()) {
                    this.focusToComponent(this.jTableChooseCert);
                    Manager.closeToken();
                    return "NO_CERT_IN_USB";
                }
            }
            listSignPrivateKeys = new ArrayList<DSSPrivateKeyEntry>();
            int i3 = 0;
            int numberSelect = -1;
            DefaultTableModel model = new DefaultTableModel(){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            model.addColumn(StringUtil.getText("stt"));
            model.addColumn(StringUtil.getText("main.screen.granted.for"));
            model.addColumn(StringUtil.getText("main.screen.granted.by"));
            model.addColumn(StringUtil.getText("main.screen.issued.date"));
            model.addColumn(StringUtil.getText("main.screen.end.date"));
            model.addColumn(StringUtil.getText("main.screen.status"));
            int numValidCert = 0;
            logger.info("=====> Number of certificate existed in usb-token: " + Manager.getListSignPrivateKeys().size());
            for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                String dn;
                if (Manager.getConfigObject() != null && !StringUtil.isNullOrEmpty(Manager.getDefaultCertSerial()).booleanValue()) {
                    String serialUpper = Manager.getDefaultCertSerial().toUpperCase().trim();
                    String entrySerial = entry.getCertificate().getSerialNumber().toString(16).toUpperCase();
                    if (serialUpper != null && !"".equals(serialUpper) && serialUpper.equals(entrySerial)) {
                        numberSelect = i3;
                    }
                }
                if ((dn = entry.getCertificate().getSubjectDN().toString()) != null && dn.length() > 0 && dn.contains("OID.0.9.2342.19200300.100.1.1")) {
                    dn = dn.replace("OID.0.9.2342.19200300.100.1.1", "UID");
                }
                String[] parts = dn.split(",");
                boolean isExist = false;
                for (String part : parts) {
                    String[] subPart;
                    String cerTaxCode = "";
                    if (part.contains("UID=MST:") && (subPart = part.split(":")).length > 1) {
                        cerTaxCode = subPart[1].trim();
                    }
                    if (!cerTaxCode.equals(taxCode)) continue;
                    isExist = true;
                }
                if (!isExist) continue;
                listSignPrivateKeys.add(entry);
                logger.info("=====> entry.getCertificate().getSerialNumber():" + entry.getCertificate().getSerialNumber().toString(16).toUpperCase());
                ++i3;
                Date today = new Date();
                Date noBeforeDate = entry.getCertificate().getNotBefore();
                Date noAfterDate = entry.getCertificate().getNotAfter();
                logger.info("=====> Enterprise : " + entry.getCertificate().getSubjectShortName());
                boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
                boolean isValidCert = false;
                if (isValidDate) {
                    if (!Manager.isAppSessionTimerRunning() || entry.getCertificate().getValid() == null) {
                        try {
                            isValidCert = CheckOcspOrCrl.checkCertificateOCSP(entry.getCertificate().getCertificate());
                            logger.info("=====> isValidCert " + isValidCert);
                        }
                        catch (ConnectException | SocketTimeoutException ex) {
                            logger.info("Can't connect to server validate certificate");
                            logger.error("Exception", ex);
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "NO_INTERNET_CONNECTION_SETUP_TABLE";
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                            this.focusToComponent(this.jTableChooseCert);
                            Manager.closeToken();
                            return "HAVE_ERROR";
                        }
                    } else {
                        isValidCert = entry.getCertificate().getValid();
                    }
                }
                if (isValidDate && isValidCert) {
                    model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.valid")});
                    entry.getCertificate().setValid(true);
                    ++numValidCert;
                    continue;
                }
                model.addRow(new Object[]{String.valueOf(i3), entry.getCertificate().getSubjectShortName(), entry.getCertificate().getIssuerCN(), DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy"), DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy"), StringUtil.getText("main.screen.status.invalid")});
                entry.getCertificate().setValid(false);
            }
            if (i3 == 0) {
                return "NO_CERTIFICATE_WITH_TAX";
            }
            logger.info("=====> Number of valid certificate  in usb-token: " + numValidCert);
            this.jTableChooseCert.setModel(model);
            this.jTableChooseCert.setRowHeight(25);
            this.jTableChooseCert.setVisible(true);
            this.jTableChooseCert.setColumnSelectionAllowed(false);
            this.jTableChooseCert.setRowSelectionAllowed(true);
            this.jTableChooseCert.setSelectionMode(0);
            CustomedComponentUtil.customTable(this, this.jTableChooseCert);
            if (numberSelect != -1) {
                this.jTableChooseCert.setRowSelectionInterval(numberSelect, numberSelect);
            }
            return "SUCCESS";
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            this.focusToComponent(this.jTableChooseCert);
            Manager.closeToken();
            return "HAVE_ERROR";
        }
    }

    private ImageIcon getImageIcon(String name) {
        if (StringUtil.isNullOrEmpty(name).booleanValue()) {
            return new ImageIcon();
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/Images/" + name)));
    }

    public void showMessageToUser(String message, String type) {
        CustomedComponentUtil.showMessageToUser(this, message, type);
    }

    public void appearOnTop() {
        this.setState(0);
        this.setAlwaysOnTop(true);
        this.setAlwaysOnTop(false);
    }

    public boolean isSigning() {
        return Manager.isIsSigning();
    }

    private void focusToComponent(Component component) {
        component.requestFocus();
    }

    public void refresh() {
        this.jButtonChooseCert.setText(StringUtil.getText("main.screen.choose"));
        this.jtitleFormLogin.setText(StringUtil.getText("choose.cert"));
        CustomedComponentUtil.updateTable(this.jTableChooseCert);
    }
}

