/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipUtils {
    private static final Logger logger = Logger.getLogger(ZipUtils.class.getName());

    public static void createZipFile(File file, String inputFileName) throws IOException {
        byte[] buf = new byte[1024];
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(inputFileName + ".zip"));
             FileInputStream in = new FileInputStream(file);){
            int len;
            out.putNextEntry(new ZipEntry(inputFileName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
        }
        catch (IOException e2) {
            logger.error("Have error: ", e2);
            throw e2;
        }
    }

    public static void createZipFile(File file, String desFolder, String inputFileName) throws IOException {
        byte[] buf = new byte[1024];
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(desFolder + File.separator + inputFileName + ".zip"));){
            int len;
            FileInputStream in = new FileInputStream(file);
            out.putNextEntry(new ZipEntry(inputFileName));
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            out.closeEntry();
            in.close();
        }
        catch (IOException e2) {
            logger.error("Have error: ", e2);
            throw e2;
        }
    }

    public static boolean unzipFileIntoDirectory(String zipFilePath, String upzipDirPath) {
        try {
            File file = new File(zipFilePath);
            ZipFile zipFile = new ZipFile(file);
            return ZipUtils.unzipFileIntoDirectory(zipFile, new File(upzipDirPath));
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unzipFileIntoDirectory(ZipFile zipFile, File jiniHomeParentDir) {
        Enumeration<? extends ZipEntry> files = zipFile.entries();
        File f2 = null;
        FileOutputStream fos = null;
        while (files.hasMoreElements()) {
            try {
                ZipEntry entry = files.nextElement();
                InputStream eis = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    byte[] buffer = new byte[1024];
                    int bytesRead = 0;
                    f2 = new File(jiniHomeParentDir.getAbsolutePath() + File.separator + entry.getName());
                    if (entry.isDirectory()) {
                        f2.mkdirs();
                        continue;
                    }
                    f2.getParentFile().mkdirs();
                    f2.createNewFile();
                    fos = new FileOutputStream(f2);
                    while ((bytesRead = eis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                    f2 = null;
                    fos.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (eis == null) continue;
                    if (throwable != null) {
                        try {
                            eis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    eis.close();
                    continue;
                }
                entry = null;
            }
            catch (IOException e2) {
                logger.error("Have error: ", e2);
                boolean bl = false;
                return bl;
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (IOException e3) {
                    logger.error("Have error: ", e3);
                }
            }
        }
        return true;
    }

    public static void deleteZipEntry(File zipFile, String[] files, String directoryPath) throws IOException {
        try {
            File directory = new File(directoryPath);
            File tempFile = File.createTempFile(zipFile.getName(), null, directory);
            tempFile.delete();
            tempFile.deleteOnExit();
            boolean renameOk = zipFile.renameTo(tempFile);
            if (!renameOk) {
                throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
            }
            try (ZipFile tempZipFile = new ZipFile(tempFile.getAbsolutePath());){
                ZipOutputStream zout;
                int numOfDelete = 0;
                byte[] buf = new byte[1024];
                try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));){
                    zout = new ZipOutputStream(new FileOutputStream(zipFile));
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        String name = entry.getName();
                        logger.info(name);
                        boolean toBeDeleted = false;
                        for (String f2 : files) {
                            if (!ZipUtils.compareFileName(f2, name).booleanValue()) continue;
                            toBeDeleted = true;
                            ++numOfDelete;
                            break;
                        }
                        if (!toBeDeleted) {
                            int len;
                            zout.putNextEntry(new ZipEntry(name));
                            while ((len = zin.read(buf)) > 0) {
                                zout.write(buf, 0, len);
                            }
                        }
                        entry = zin.getNextEntry();
                    }
                }
                zout.close();
            }
            tempFile.delete();
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
    }

    public static Boolean compareFileName(String fileName1, String fileName2) throws Exception {
        int idx1 = fileName1.lastIndexOf(".");
        int idx2 = fileName2.lastIndexOf(".");
        if (idx1 != -1 && idx2 != -1) {
            String ext1 = fileName1.substring(idx1);
            String ext2 = fileName2.substring(idx2);
            if (ext1.toLowerCase().equals(ext2.toLowerCase())) {
                return fileName1.substring(0, idx1).equals(fileName2.substring(0, idx2));
            }
        }
        return false;
    }

    public static boolean zipDirectory(String dir, String zipfile) {
        try {
            File d2 = new File(dir);
            if (!d2.isDirectory()) {
                logger.info("Error path: " + dir + " is not directory");
                return false;
            }
            String[] entries = d2.list();
            byte[] buffer = new byte[4096];
            try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipfile + ".zip"));){
                for (String entrie : entries) {
                    File f2;
                    if (entrie.toLowerCase().endsWith(".zip") || entrie.toLowerCase().endsWith(".pdf") || (f2 = new File(d2, entrie)).isDirectory()) continue;
                    try (FileInputStream in = new FileInputStream(f2);){
                        int bytesRead;
                        ZipEntry entry = new ZipEntry(f2.getName());
                        out.putNextEntry(entry);
                        while ((bytesRead = in.read(buffer)) != -1) {
                            out.write(buffer, 0, bytesRead);
                        }
                    }
                }
            }
            return true;
        }
        catch (FileNotFoundException ex) {
            logger.error("Have error: ", ex);
        }
        catch (IOException ex) {
            logger.error("Have error: ", ex);
        }
        return false;
    }

    public static void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            int length;
            String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
            logger.info("Writing '" + zipFilePath + "' to zip file");
            ZipEntry zipEntry = new ZipEntry(zipFilePath);
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
        }
    }

    public static void writeZipFile(File directoryToZip, List<File> fileList) {
        try (FileOutputStream fos = new FileOutputStream(directoryToZip.getName() + ".zip");
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File file : fileList) {
                if (file.isDirectory()) continue;
                ZipUtils.addToZip(directoryToZip, file, zos);
            }
        }
        catch (FileNotFoundException e2) {
            logger.error("Have error: ", e2);
        }
        catch (IOException e3) {
            logger.error("Have error: ", e3);
        }
    }

    public static void zipMultilFiles(File directoryToZip, List<File> fileList) {
        try {
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(directoryToZip);
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                for (File file : fileList) {
                    FileInputStream fis = new FileInputStream(file);
                    Throwable throwable = null;
                    try {
                        int length;
                        zos.putNextEntry(new ZipEntry(file.getName()));
                        while ((length = fis.read(buffer)) > 0) {
                            zos.write(buffer, 0, length);
                        }
                        zos.closeEntry();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fis == null) continue;
                        if (throwable != null) {
                            try {
                                fis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fis.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            logger.error("Exception", ioe);
        }
    }

    public static void zipFile(File inputFile, String zipFilePath) {
        try {
            FileInputStream fileInputStream;
            try (FileOutputStream fileOutputStream = new FileOutputStream(zipFilePath);
                 ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
                int bytesRead;
                ZipEntry zipEntry = new ZipEntry(inputFile.getName());
                zipOutputStream.putNextEntry(zipEntry);
                fileInputStream = new FileInputStream(inputFile);
                byte[] buf = new byte[1024];
                while ((bytesRead = fileInputStream.read(buf)) > 0) {
                    zipOutputStream.write(buf, 0, bytesRead);
                }
                zipOutputStream.closeEntry();
            }
            fileInputStream.close();
            logger.info("Regular file :" + inputFile.getCanonicalPath() + " is zipped to archive :" + zipFilePath);
        }
        catch (IOException e2) {
            logger.error("Have error: ", e2);
        }
    }

    public static void addFilesToZip(File zipFile, File[] files, String directoryPath) throws IOException {
        ZipOutputStream out;
        File directory = new File(directoryPath);
        File tempFile = File.createTempFile(zipFile.getName(), null, directory);
        tempFile.delete();
        boolean renameOk = zipFile.renameTo(tempFile);
        if (!renameOk) {
            throw new RuntimeException("could not rename the file " + zipFile.getAbsolutePath() + " to " + tempFile.getAbsolutePath());
        }
        byte[] buf = new byte[1024];
        try (ZipInputStream zin = new ZipInputStream(new FileInputStream(tempFile));){
            out = new ZipOutputStream(new FileOutputStream(zipFile));
            ZipEntry entry = zin.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                boolean notInFiles = true;
                for (File f2 : files) {
                    if (!f2.getName().equals(name)) continue;
                    notInFiles = false;
                    break;
                }
                if (notInFiles) {
                    int len;
                    out.putNextEntry(new ZipEntry(name));
                    while ((len = zin.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                }
                entry = zin.getNextEntry();
            }
        }
        for (File file : files) {
            FileInputStream in = new FileInputStream(file);
            Object object = null;
            try {
                int len;
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
            }
        }
        out.close();
        tempFile.delete();
    }

    public static void main(String[] args) {
        try {
            String zipFilePath = "D:\\Users\\dungnv93\\Downloads\\Einvoice\\0100109106-MN-16E0000039.zip";
            String targetDir = "D:\\Users\\dungnv93\\Downloads\\Einvoice\\Target";
            ZipUtils.unzipFileIntoDirectory(zipFilePath, targetDir);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
    }
}

