/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import eu.europa.esig.dss.token.connection.ProxyConfig;
import eu.europa.esig.dss.token.utils.ZipUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class UpdateService {
    private static final Logger log = Logger.getLogger(UpdateService.class);

    private SimpleClientHttpRequestFactory disableSSlHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        Proxy proxy = ProxyConfig.getProxy();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        if (proxy != null && !"DIRECT".equals(proxy.toString())) {
            factory.setProxy(proxy);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadUpdate() {
        FileOutputStream fos = null;
        ReadableByteChannel rbc = null;
        boolean result = false;
        try {
            File[] listFile;
            String filePath = "update.zip";
            rbc = Channels.newChannel(new URL("https://sinvoice.viettel.vn/download/soft/sinvoice_update.zip").openStream());
            File f2 = new File(filePath);
            if (f2.exists()) {
                f2.delete();
            }
            fos = new FileOutputStream(filePath);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            fos.close();
            f2 = new File(filePath);
            if (!f2.exists()) {
                boolean bl = false;
                return bl;
            }
            ZipUtils.unzipFileIntoDirectory(filePath, "temp");
            File unZipDir = new File("temp");
            for (File fileEle : listFile = unZipDir.listFiles()) {
                String fileName;
                if (fileEle.isDirectory() || !(fileName = fileEle.getAbsolutePath()).endsWith(".jar") || !this.doesClassExistInJar(fileName, "viettel.custom.swing.BackgroundImageJpanel")) continue;
                log.info("===================Down load update file success====================");
                result = true;
            }
        }
        catch (FileNotFoundException ex) {
            log.error("===================Error down file====================: " + ex.getMessage(), ex);
        }
        catch (MalformedURLException ex) {
            log.error("===================Error down file====================: " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            log.error("===================Error down file====================: " + ex.getMessage(), ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    log.error("===================Error down file====================: " + ex.getMessage(), ex);
                }
            }
            if (rbc != null) {
                try {
                    rbc.close();
                }
                catch (IOException ex) {
                    log.error("===================Error down file====================: " + ex.getMessage(), ex);
                }
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean doesClassExistInJar(String jarFilePath, String className) {
        File file = new File(jarFilePath);
        if (!file.exists() || !file.getName().endsWith(".jar")) {
            log.info("File kh\u00f4ng h\u1ee3p l\u1ec7 ho\u1eb7c kh\u00f4ng ph\u1ea3i file JAR.");
            return false;
        }
        try (JarFile jarFile = new JarFile(file);){
            String classPath = className.replace('.', '/') + ".class";
            JarEntry entry = jarFile.getJarEntry(classPath);
            boolean bl = entry != null;
            return bl;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public boolean checkVersion() {
        try {
            String urlVersion = "https://sinvoice.viettel.vn/download/soft/sinvoice_version.zip";
            String targetFile = "download.zip";
            String version = this.downloadZipFile(urlVersion, targetFile);
            if (version != null && !version.isEmpty()) {
                System.out.println("Version: " + version.trim());
                version = version.trim().replace(".", "");
                int versionInt = Integer.parseInt(version);
                int appVersionInt = Integer.parseInt("1.0.1".replace(".", ""));
                return versionInt != appVersionInt;
            }
            System.err.println("Failed to process the ZIP file.");
            return false;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private String downloadZipFile(String zipUrl, String targetFile) throws Exception {
        String version;
        block15: {
            version = null;
            try {
                RestTemplate restTemplate = new RestTemplate();
                restTemplate.setRequestFactory(this.disableSSlHttpClient());
                HttpHeaders headers = new HttpHeaders();
                headers.set("Accept", "application/octet-stream");
                ResponseEntity<byte[]> response = restTemplate.getForEntity(zipUrl, byte[].class, new Object[0]);
                if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                    byte[] zipFileBytes = (byte[])response.getBody();
                    try (ByteArrayInputStream zipInputStream = new ByteArrayInputStream(zipFileBytes);){
                        version = UpdateService.processZipFile(zipInputStream);
                        break block15;
                    }
                }
                System.err.println("Failed to download the file. HTTP Status: " + (Object)((Object)response.getStatusCode()));
            }
            catch (IOException e2) {
                System.err.println("Error processing the ZIP file: " + e2.getMessage());
                e2.printStackTrace();
            }
        }
        return version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String processZipFile(InputStream zipInputStream) {
        try (ZipInputStream zis = new ZipInputStream(zipInputStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                System.out.println("Extracting file: " + entry.getName());
                if (!entry.isDirectory() && entry.getName().endsWith(".txt")) {
                    StringBuilder fileContent = new StringBuilder();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(zis));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            fileContent.append(line).append("\n");
                        }
                    }
                    System.out.println("Content of " + entry.getName() + ":");
                    System.out.println(fileContent);
                    String string = fileContent.toString();
                    return string;
                }
                zis.closeEntry();
            }
            return null;
        }
        catch (Exception e2) {
            System.err.println("Error while processing ZIP file: " + e2.getMessage());
            e2.printStackTrace();
        }
        return null;
    }
}

