/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import sun.security.pkcs11.SunPKCS11;

public class TokenUtils {
    private Provider _pkcs11Provider;
    private final String _pkcs11Path;
    private KeyStore _keyStore;
    private final PasswordInputCallback callback;
    private int slotIndex;
    private int smartCardNameIndex = 0;

    public TokenUtils(String pkcs11Path, PasswordInputCallback callback) {
        this._pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotIndex = 0;
    }

    public TokenUtils(String pkcs11Path) {
        this(pkcs11Path, null);
    }

    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
            }
        }
        catch (Exception e2) {
            throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e2.getMessage(), e2);
        }
        return list;
    }

    private KeyStore getKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        if (this._keyStore == null) {
            this._keyStore = KeyStore.getInstance("PKCS11", this.getProvider());
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection("".toCharArray());
            this._keyStore.load(null, pp.getPassword());
        }
        return this._keyStore;
    }

    private Provider getProvider() {
        try {
            if (this._pkcs11Provider == null) {
                Provider[] providers = Security.getProviders();
                if (providers != null) {
                    for (Provider provider : providers) {
                        String providerInfo = provider.getInfo();
                        if (!providerInfo.contains(this.getPkcs11Path())) continue;
                        this._pkcs11Provider = provider;
                        return provider;
                    }
                }
                this.installProvider();
            }
            return this._pkcs11Provider;
        }
        catch (ProviderException ex) {
            throw new DSSException("Not a PKCS#11 library", ex);
        }
    }

    private void installProvider() {
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        String pkcs11ConfigSettings = "name = SmartCard" + this.smartCardNameIndex + "\nlibrary = \"" + aPKCS11LibraryFileName + "\"\nslotListIndex = " + this.slotIndex;
        byte[] pkcs11ConfigBytes = pkcs11ConfigSettings.getBytes();
        ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigBytes);
        SunPKCS11 pkcs11 = new SunPKCS11((InputStream)confStream);
        this._pkcs11Provider = pkcs11;
        Security.addProvider(this._pkcs11Provider);
        ++this.smartCardNameIndex;
    }

    private String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    protected String getPkcs11Path() {
        return this._pkcs11Path;
    }
}

