/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;

public class SwingPasswordCallbackHandler
implements CallbackHandler {
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i2 = 0; i2 < callbacks.length; ++i2) {
            if (!(callbacks[i2] instanceof PasswordCallback)) {
                throw new UnsupportedCallbackException(callbacks[i2], "Callback not supported " + callbacks[i2].getClass().getName());
            }
            this.handlePasswordCallback((PasswordCallback)callbacks[i2]);
        }
    }

    private void handlePasswordCallback(PasswordCallback passCb) throws UnsupportedCallbackException {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(new JLabel(passCb.getPrompt()));
        final JPasswordField txtPwd = new JPasswordField(20);
        panel.add(txtPwd);
        JOptionPane pane = new JOptionPane(panel, 3, 2);
        JDialog dialog = pane.createDialog(null, "Login / PIN");
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e2) {
                txtPwd.requestFocusInWindow();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        int retVal = pane.getValue() != null ? (Integer)pane.getValue() : 2;
        switch (retVal) {
            case 0: {
                passCb.setPassword(((JTextComponent)txtPwd).getText().toCharArray());
                break;
            }
            default: {
                throw new CancellationException("Password Callback canceled by user");
            }
        }
    }
}

