/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import eu.europa.esig.dss.token.connection.Manager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class StringUtil {
    private static final Logger logger = Logger.getLogger(StringUtil.class.getName());

    public static String getText(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle("Language/language_" + Manager.getConfigObject().getLanguage(), Locale.US);
        String result = key;
        try {
            result = bundle.getString(key);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return result;
    }

    public static String getEnglishText(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle("Language/language_en_US", Locale.US);
        String result = key;
        try {
            result = bundle.getString(key);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return result;
    }

    public static String getVietnameseText(String key) {
        ResourceBundle bundle = ResourceBundle.getBundle("Language/language_vi_VN", Locale.US);
        String result = key;
        try {
            result = bundle.getString(key);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return result;
    }

    public static void writeValue(String value, String outputFilePath) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));
        writer.write(value);
        writer.close();
    }

    public static boolean isNumber(String number) {
        if (StringUtil.isNullOrEmpty(number).booleanValue()) {
            return false;
        }
        String pattern = "^[0-9]+$";
        return number.matches(pattern);
    }

    public static String readAllFile(String path) throws Exception {
        String line;
        if (StringUtil.isNullOrEmpty(path).booleanValue()) {
            throw new Exception("Input for readAllFile invalid");
        }
        BufferedReader reader = Files.newBufferedReader(new File(path).toPath(), StandardCharsets.UTF_8);
        String result = "";
        while ((line = reader.readLine()) != null) {
            result = result + line + "\n";
        }
        return result;
    }

    public static void writeContentFromFile(String content, String path) throws Exception {
        if (StringUtil.isNullOrEmpty(path).booleanValue() || StringUtil.isNullOrEmpty(content).booleanValue()) {
            throw new Exception("Input for readAllFile invalid");
        }
        Files.write(new File(path).toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static Boolean isNullOrEmpty(Object object) {
        if (object == null || object.toString() == null || object.toString().trim().isEmpty()) {
            return true;
        }
        return false;
    }

    public static String renameKeyboardTypeToVietnamese(String file) {
        file = file.replace("(af)", "\u00e0");
        file = file.replace("(as)", "\u00e1");
        file = file.replace("(ar)", "\u1ea3");
        file = file.replace("(ax)", "\u00e3");
        file = file.replace("(aj)", "\u1ea1");
        file = file.replace("(aw)", "\u0103");
        file = file.replace("(awf)", "\u1eb1");
        file = file.replace("(aws)", "\u1eaf");
        file = file.replace("(awr)", "\u1eb3");
        file = file.replace("(awx)", "\u1eb5");
        file = file.replace("(awj)", "\u1eb7");
        file = file.replace("(aa)", "\u00e2");
        file = file.replace("(aaf)", "\u1ea7");
        file = file.replace("(aas)", "\u1ea5");
        file = file.replace("(aar)", "\u1ea9");
        file = file.replace("(aax)", "\u1eab");
        file = file.replace("(aaj)", "\u1ead");
        file = file.replace("(Af)", "\u00c0");
        file = file.replace("(As)", "\u00c1");
        file = file.replace("(Ar)", "\u1ea2");
        file = file.replace("(Ax)", "\u00c3");
        file = file.replace("(Aj)", "\u1ea0");
        file = file.replace("(Aw)", "\u0102");
        file = file.replace("(Awf)", "\u1eb0");
        file = file.replace("(Aws)", "\u1eae");
        file = file.replace("(Awr)", "\u1eb2");
        file = file.replace("(Awx)", "\u1eb4");
        file = file.replace("(Awj)", "\u1eb6");
        file = file.replace("(Aa)", "\u00c2");
        file = file.replace("(Aaf)", "\u1ea6");
        file = file.replace("(Aas)", "\u1ea4");
        file = file.replace("(Aar)", "\u1ea8");
        file = file.replace("(Aax)", "\u1eaa");
        file = file.replace("(Aaj)", "\u1eac");
        file = file.replace("(dd)", "\u0111");
        file = file.replace("(Dd)", "\u0110");
        file = file.replace("(ef)", "\u00e8");
        file = file.replace("(es)", "\u00e9");
        file = file.replace("(er)", "\u1ebb");
        file = file.replace("(ex)", "\u1ebd");
        file = file.replace("(ej)", "\u1eb9");
        file = file.replace("(ee)", "\u00ea");
        file = file.replace("(eef)", "\u1ec1");
        file = file.replace("(ees)", "\u1ebf");
        file = file.replace("(eer)", "\u1ec3");
        file = file.replace("(eex)", "\u1ec5");
        file = file.replace("(eej)", "\u1ec7");
        file = file.replace("(Ef)", "\u00c8");
        file = file.replace("(Es)", "\u00c9");
        file = file.replace("(Er)", "\u1eba");
        file = file.replace("(Ex)", "\u1ebc");
        file = file.replace("(Ej)", "\u1eb8");
        file = file.replace("(Ee)", "\u00ca");
        file = file.replace("(Eef)", "\u1ec0");
        file = file.replace("(Ees)", "\u1ebe");
        file = file.replace("(Eer)", "\u1ec2");
        file = file.replace("(Eex)", "\u1ec4");
        file = file.replace("(Eej)", "\u1ec6");
        file = file.replace("(if)", "\u00ec");
        file = file.replace("(is)", "\u00ed");
        file = file.replace("(ir)", "\u1ec9");
        file = file.replace("(ix)", "\u0129");
        file = file.replace("(ij)", "\u1ecb");
        file = file.replace("(If)", "\u00cc");
        file = file.replace("(Is)", "\u00cd");
        file = file.replace("(Ir)", "\u1ec8");
        file = file.replace("(Ix)", "\u0128");
        file = file.replace("(Ij)", "\u1eca");
        file = file.replace("(of)", "\u00f2");
        file = file.replace("(os)", "\u00f3");
        file = file.replace("(or)", "\u1ecf");
        file = file.replace("(ox)", "\u00f5");
        file = file.replace("(oj)", "\u1ecd");
        file = file.replace("(oo)", "\u00f4");
        file = file.replace("(oof)", "\u1ed3");
        file = file.replace("(oos)", "\u1ed1");
        file = file.replace("(oor)", "\u1ed5");
        file = file.replace("(oox)", "\u1ed7");
        file = file.replace("(ooj)", "\u1ed9");
        file = file.replace("(ow)", "\u01a1");
        file = file.replace("(owf)", "\u1edd");
        file = file.replace("(ows)", "\u1edb");
        file = file.replace("(owr)", "\u1edf");
        file = file.replace("(owx)", "\u1ee1");
        file = file.replace("(owj)", "\u1ee3");
        file = file.replace("(Of)", "\u00d2");
        file = file.replace("(Os)", "\u00d3");
        file = file.replace("(Or)", "\u1ece");
        file = file.replace("(Ox)", "\u00d5");
        file = file.replace("(Oj)", "\u1ecc");
        file = file.replace("(Oo)", "\u00d4");
        file = file.replace("(Oof)", "\u1ed2");
        file = file.replace("(Oos)", "\u1ed0");
        file = file.replace("(Oor)", "\u1ed4");
        file = file.replace("(Oox)", "\u1ed6");
        file = file.replace("(Ooj)", "\u1ed8");
        file = file.replace("(Ow)", "\u01a0");
        file = file.replace("(Owf)", "\u1edc");
        file = file.replace("(Ows)", "\u1eda");
        file = file.replace("(Owr)", "\u1ede");
        file = file.replace("(Owx)", "\u1ee0");
        file = file.replace("(Owj)", "\u1ee2");
        file = file.replace("(uf)", "\u00f9");
        file = file.replace("(us)", "\u00fa");
        file = file.replace("(ur)", "\u1ee7");
        file = file.replace("(ux)", "\u0169");
        file = file.replace("(uj)", "\u1ee5");
        file = file.replace("(uw)", "\u01b0");
        file = file.replace("(uwf)", "\u1eeb");
        file = file.replace("(uws)", "\u1ee9");
        file = file.replace("(uwr)", "\u1eed");
        file = file.replace("(uwx)", "\u1eef");
        file = file.replace("(uwj)", "\u1ef1");
        file = file.replace("(Uuf)", "\u00d9");
        file = file.replace("(Uus)", "\u00da");
        file = file.replace("(Uur)", "\u1ee6");
        file = file.replace("(Uux)", "\u0168");
        file = file.replace("(Uuj)", "\u1ee4");
        file = file.replace("(Uw)", "\u01af");
        file = file.replace("(Uwf)", "\u1eea");
        file = file.replace("(Uws)", "\u1ee8");
        file = file.replace("(Uwr)", "\u1eec");
        file = file.replace("(Uwx)", "\u1eee");
        file = file.replace("(Uwj)", "\u1ef0");
        file = file.replace("(yf)", "\u1ef3");
        file = file.replace("(ys)", "\u00fd");
        file = file.replace("(yr)", "\u1ef7");
        file = file.replace("(yx)", "\u1ef9");
        file = file.replace("(yj)", "\u1ef5");
        file = file.replace("(Y)", "Y");
        file = file.replace("(Yf)", "\u1ef2");
        file = file.replace("(Ys)", "\u00dd");
        file = file.replace("(Yr)", "\u1ef6");
        file = file.replace("(Yx)", "\u1ef8");
        file = file.replace("(Yj)", "\u1ef4");
        return file;
    }

    public static String renameVietnameseToKeyboardType(String file) {
        file = file.replace("\u00e0", "(af)");
        file = file.replace("\u00e1", "(as)");
        file = file.replace("\u1ea3", "(ar)");
        file = file.replace("\u00e3", "(ax)");
        file = file.replace("\u1ea1", "(aj)");
        file = file.replace("\u0103", "(aw)");
        file = file.replace("\u1eb1", "(awf)");
        file = file.replace("\u1eaf", "(aws)");
        file = file.replace("\u1eb3", "(awr)");
        file = file.replace("\u1eb5", "(awx)");
        file = file.replace("\u1eb7", "(awj)");
        file = file.replace("\u00e2", "(aa)");
        file = file.replace("\u1ea7", "(aaf)");
        file = file.replace("\u1ea5", "(aas)");
        file = file.replace("\u1ea9", "(aar)");
        file = file.replace("\u1eab", "(aax)");
        file = file.replace("\u1ead", "(aaj)");
        file = file.replace("\u00c0", "(Af)");
        file = file.replace("\u00c1", "(As)");
        file = file.replace("\u1ea2", "(Ar)");
        file = file.replace("\u00c3", "(Ax)");
        file = file.replace("\u1ea0", "(Aj)");
        file = file.replace("\u0102", "(Aw)");
        file = file.replace("\u1eb0", "(Awf)");
        file = file.replace("\u1eae", "(Aws)");
        file = file.replace("\u1eb2", "(Awr)");
        file = file.replace("\u1eb4", "(Awx)");
        file = file.replace("\u1eb6", "(Awj)");
        file = file.replace("\u00c2", "(Aa)");
        file = file.replace("\u1ea6", "(Aaf)");
        file = file.replace("\u1ea4", "(Aas)");
        file = file.replace("\u1ea8", "(Aar)");
        file = file.replace("\u1eaa", "(Aax)");
        file = file.replace("\u1eac", "(Aaj)");
        file = file.replace("\u0111", "(dd)");
        file = file.replace("\u0110", "(Dd)");
        file = file.replace("\u00e8", "(ef)");
        file = file.replace("\u00e9", "(es)");
        file = file.replace("\u1ebb", "(er)");
        file = file.replace("\u1ebd", "(ex)");
        file = file.replace("\u1eb9", "(ej)");
        file = file.replace("\u00ea", "(ee)");
        file = file.replace("\u1ec1", "(eef)");
        file = file.replace("\u1ebf", "(ees)");
        file = file.replace("\u1ec3", "(eer)");
        file = file.replace("\u1ec5", "(eex)");
        file = file.replace("\u1ec7", "(eej)");
        file = file.replace("\u00c8", "(Ef)");
        file = file.replace("\u00c9", "(Es)");
        file = file.replace("\u1eba", "(Er)");
        file = file.replace("\u1ebc", "(Ex)");
        file = file.replace("\u1eb8", "(Ej)");
        file = file.replace("\u00ca", "(Ee)");
        file = file.replace("\u1ec0", "(Eef)");
        file = file.replace("\u1ebe", "(Ees)");
        file = file.replace("\u1ec2", "(Eer)");
        file = file.replace("\u1ec4", "(Eex)");
        file = file.replace("\u1ec6", "(Eej)");
        file = file.replace("\u00ec", "(if)");
        file = file.replace("\u00ed", "(is)");
        file = file.replace("\u1ec9", "(ir)");
        file = file.replace("\u0129", "(ix)");
        file = file.replace("\u1ecb", "(ij)");
        file = file.replace("\u00cc", "(If)");
        file = file.replace("\u00cd", "(Is)");
        file = file.replace("\u1ec8", "(Ir)");
        file = file.replace("\u0128", "(Ix)");
        file = file.replace("\u1eca", "(Ij)");
        file = file.replace("\u00f2", "(of)");
        file = file.replace("\u00f3", "(os)");
        file = file.replace("\u1ecf", "(or)");
        file = file.replace("\u00f5", "(ox)");
        file = file.replace("\u1ecd", "(oj)");
        file = file.replace("\u00f4", "(oo)");
        file = file.replace("\u1ed3", "(oof)");
        file = file.replace("\u1ed1", "(oos)");
        file = file.replace("\u1ed5", "(oor)");
        file = file.replace("\u1ed7", "(oox)");
        file = file.replace("\u1ed9", "(ooj)");
        file = file.replace("\u01a1", "(ow)");
        file = file.replace("\u1edd", "(owf)");
        file = file.replace("\u1edb", "(ows)");
        file = file.replace("\u1edf", "(owr)");
        file = file.replace("\u1ee1", "(owx)");
        file = file.replace("\u1ee3", "(owj)");
        file = file.replace("\u00d2", "(Of)");
        file = file.replace("\u00d3", "(Os)");
        file = file.replace("\u1ece", "(Or)");
        file = file.replace("\u00d5", "(Ox)");
        file = file.replace("\u1ecc", "(Oj)");
        file = file.replace("\u00d4", "(Oo)");
        file = file.replace("\u1ed2", "(Oof)");
        file = file.replace("\u1ed0", "(Oos)");
        file = file.replace("\u1ed4", "(Oor)");
        file = file.replace("\u1ed6", "(Oox)");
        file = file.replace("\u1ed8", "(Ooj)");
        file = file.replace("\u01a0", "(Ow)");
        file = file.replace("\u1edc", "(Owf)");
        file = file.replace("\u1eda", "(Ows)");
        file = file.replace("\u1ede", "(Owr)");
        file = file.replace("\u1ee0", "(Owx)");
        file = file.replace("\u1ee2", "(Owj)");
        file = file.replace("\u00f9", "(uf)");
        file = file.replace("\u00fa", "(us)");
        file = file.replace("\u1ee7", "(ur)");
        file = file.replace("\u0169", "(ux)");
        file = file.replace("\u1ee5", "(uj)");
        file = file.replace("\u01b0", "(uw)");
        file = file.replace("\u1eeb", "(uwf)");
        file = file.replace("\u1ee9", "(uws)");
        file = file.replace("\u1eed", "(uwr)");
        file = file.replace("\u1eef", "(uwx)");
        file = file.replace("\u1ef1", "(uwj)");
        file = file.replace("\u00d9", "(Uuf)");
        file = file.replace("\u00da", "(Uus)");
        file = file.replace("\u1ee6", "(Uur)");
        file = file.replace("\u0168", "(Uux)");
        file = file.replace("\u1ee4", "(Uuj)");
        file = file.replace("\u01af", "(Uw)");
        file = file.replace("\u1eea", "(Uwf)");
        file = file.replace("\u1ee8", "(Uws)");
        file = file.replace("\u1eec", "(Uwr)");
        file = file.replace("\u1eee", "(Uwx)");
        file = file.replace("\u1ef0", "(Uwj)");
        file = file.replace("\u1ef3", "(yf)");
        file = file.replace("\u00fd", "(ys)");
        file = file.replace("\u1ef7", "(yr)");
        file = file.replace("\u1ef9", "(yx)");
        file = file.replace("\u1ef5", "(yj)");
        file = file.replace("Y", "(Y)");
        file = file.replace("\u1ef2", "(Yf)");
        file = file.replace("\u00dd", "(Ys)");
        file = file.replace("\u1ef6", "(Yr)");
        file = file.replace("\u1ef8", "(Yx)");
        file = file.replace("\u1ef4", "(Yj)");
        return file;
    }

    public static void main(String[] args) throws Exception {
        try {
            System.out.println("Hello world");
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }
}

