/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import sun.security.pkcs11.SunPKCS11;

public class PKCS11Util {
    private int smartCardNameIndex = 0;

    public static String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    public static KeyStore loadKeystore(String dll, CallbackHandler passwordCallbackHandler) {
        Properties config = new Properties();
        config.put("library", dll);
        config.put("name", " SmartCard0");
        return PKCS11Util.loadKeystore(config, passwordCallbackHandler);
    }

    public static KeyStore loadKeystore(Properties config, CallbackHandler passwordCallbackHandler) {
        try {
            Provider pkcs11Prov = PKCS11Util.createPkcs11Provider(config);
            KeyStore.CallbackHandlerProtection pwCallbackProt = new KeyStore.CallbackHandlerProtection(passwordCallbackHandler);
            KeyStore.Builder builder = KeyStore.Builder.newInstance("PKCS11", pkcs11Prov, pwCallbackProt);
            return builder.getKeyStore();
        }
        catch (KeyStoreException e2) {
            throw new RuntimeException("Failed to load PKCS#11 Keystore", e2);
        }
    }

    private static Provider createPkcs11Provider(Properties config) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            config.store(baos, null);
            SunPKCS11 result = new SunPKCS11((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            if (result.getService("KeyStore", "PKCS11") == null) {
                throw new RuntimeException("No PKCS#11 Service available. Probably Security Token (Smartcard) not inserted");
            }
            if (Security.getProvider(result.getName()) != null) {
                Security.removeProvider(result.getName());
            }
            Security.addProvider(result);
            return result;
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to install SUN PKCS#11 Provider", e2);
        }
    }
}

