/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtils {
    public static Date convertStringToTime(String date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        if (date == null || "".equals(date)) {
            return null;
        }
        try {
            return dateFormat.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Date convertStringToDate(String date) throws Exception {
        String pattern = "dd/MM/yyyy";
        return DateTimeUtils.convertStringToTime(date, pattern);
    }

    public static String convertDateToString(Date date) throws Exception {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        return dateFormat.format(date);
    }

    public static String getSysdate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        return DateTimeUtils.convertDateToString(calendar.getTime());
    }

    public static String getSysDateTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        return dateFormat.format(calendar.getTime());
    }

    public static Date convertStringToDateTime(String date) throws Exception {
        String pattern = "dd/MM/yyyy HH:mm:ss";
        return DateTimeUtils.convertStringToTime(date, pattern);
    }

    public static String convertDateTimeToString(Date date) throws Exception {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        return dateFormat.format(date);
    }

    public static String truncDateTimeToString(Date date) throws Exception {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/yyyy");
        return "01/" + dateFormat.format(date);
    }

    public static String convertDateTimeToString(Date date, String patten) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(patten);
        return dateFormat.format(date);
    }

    public static java.sql.Date convertToSqlDate(Date utilDate) {
        return new java.sql.Date(utilDate.getTime());
    }

    public static double subTractionDate(Date date1, Date date2) throws Exception {
        long lDayInMillis = 86400000L;
        Long differenceMillis = date1.getTime() - date2.getTime();
        double differenceDay = (double)differenceMillis.longValue() / (double)lDayInMillis;
        return differenceDay;
    }

    public static long daysBetween2Dates(Date date1, Date date2) throws Exception {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.set(date1.getYear(), date1.getMonth(), date1.getDate());
        c2.set(date2.getYear(), date2.getMonth(), date2.getDate());
        long daysBetween2Dates = (c2.getTime().getTime() - c1.getTime().getTime()) / 86400000L;
        return daysBetween2Dates;
    }

    public static Date addDate(Date date, int numDate) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, numDate);
            date = cal.getTime();
        }
        return date;
    }

    public static Date addMILLISECOND(Date date, int numMILLISECOND) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(14, numMILLISECOND);
            date = cal.getTime();
        }
        return date;
    }
}

