/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.utils;

import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.utils.DateTimeUtils;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class CustomedComponentUtil {
    private static final Logger logger = Logger.getLogger(CustomedComponentUtil.class.getName());

    public static void setIconForFrame(JFrame frame) {
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(CustomedComponentUtil.class.getResource("/Images/favicon.png")));
        frame.setTitle("SInvoice");
    }

    public static void customJtree(JTree jTree) {
        jTree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                String name = node.getUserObject().toString();
                ImageIcon usbTokenIcon = CustomedComponentUtil.getImageIcon("usb-token.png");
                ImageIcon loginIcon = CustomedComponentUtil.getImageIcon("login.png");
                ImageIcon einvoiceIcon = CustomedComponentUtil.getImageIcon("einvoice.png");
                ImageIcon toolIcon = CustomedComponentUtil.getImageIcon("tool.png");
                ImageIcon infoIcon = CustomedComponentUtil.getImageIcon("info.png");
                ImageIcon settingIcon = CustomedComponentUtil.getImageIcon("setting.png");
                ImageIcon updateIcon = CustomedComponentUtil.getImageIcon("update.png");
                ImageIcon viewIcon = CustomedComponentUtil.getImageIcon("view.png");
                if (null != name) {
                    if (name.equals(StringUtil.getText("main.screen.usb-token"))) {
                        this.setOpenIcon(usbTokenIcon);
                        this.setClosedIcon(usbTokenIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.login"))) {
                        this.setLeafIcon(loginIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.Einvoice"))) {
                        this.setOpenIcon(einvoiceIcon);
                        this.setClosedIcon(einvoiceIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.view.invoice"))) {
                        this.setLeafIcon(viewIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.tool"))) {
                        this.setOpenIcon(toolIcon);
                        this.setClosedIcon(toolIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.setting"))) {
                        this.setLeafIcon(settingIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.update"))) {
                        this.setLeafIcon(updateIcon);
                    } else if (name.equals(StringUtil.getText("main.screen.about"))) {
                        this.setLeafIcon(infoIcon);
                    }
                }
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
        });
        jTree.setFont(new Font("Arial", 0, 14));
    }

    private static ImageIcon getImageIcon(String name) {
        if (StringUtil.isNullOrEmpty(name).booleanValue()) {
            return new ImageIcon();
        }
        return new ImageIcon(Toolkit.getDefaultToolkit().getImage(CustomedComponentUtil.class.getResource("/Images/" + name)));
    }

    public static void showMessageToUser(final String messageKey, String type) {
        if (!StringUtil.isNullOrEmpty(messageKey).booleanValue() && !StringUtil.isNullOrEmpty(type).booleanValue()) {
            Thread thread = null;
            if ("info".equalsIgnoreCase(type)) {
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CustomedComponentUtil.showMessageToUser(null, messageKey, "info");
                    }
                });
            } else if ("error".equalsIgnoreCase(type)) {
                thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        CustomedComponentUtil.showMessageToUser(null, messageKey, "error");
                    }
                });
            }
            if (thread != null) {
                thread.start();
            }
        }
    }

    public static void showMessageToUser(JFrame frame, String message, String type) {
        if (!StringUtil.isNullOrEmpty(message).booleanValue() && !StringUtil.isNullOrEmpty(type).booleanValue()) {
            JOptionPane pane;
            message = StringUtil.getText(message);
            JDialog dialog = null;
            if ("info".equalsIgnoreCase(type)) {
                pane = new JOptionPane(message, 1);
                dialog = pane.createDialog(frame, StringUtil.getText("info"));
            } else if ("error".equalsIgnoreCase(type)) {
                pane = new JOptionPane(message, 0);
                dialog = pane.createDialog(frame, StringUtil.getText("error"));
            }
            if (dialog == null) {
                return;
            }
            if (frame != null && frame.getState() == 0) {
                dialog.setLocation(frame.getX() + frame.getWidth() / 2 - dialog.getWidth() / 2, frame.getY() + frame.getHeight() / 2 - dialog.getHeight() / 2);
            } else {
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                dialog.setLocation(dim.width / 2 - dialog.getSize().width / 2, dim.height / 2 - dialog.getSize().height / 2);
            }
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
        }
    }

    public static int showOptionToUser(String title, String message) {
        Object[] options = new String[]{StringUtil.getText("ok"), StringUtil.getText("cancel")};
        JOptionPane pane = new JOptionPane(message, 3, 2, null, options, options[1]);
        JDialog dialog = pane.createDialog(null, title);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation(dim.width / 2 - dialog.getSize().width / 2, dim.height / 2 - dialog.getSize().height / 2);
        dialog.setAlwaysOnTop(true);
        dialog.setVisible(true);
        Object selectedValue = pane.getValue();
        int returnValue = -1;
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!((String)options[counter]).equals(selectedValue)) continue;
            returnValue = counter;
        }
        return returnValue == 0 ? 0 : 1;
    }

    public static void customTable(final JFrame frame, final JTable table) {
        table.getColumnModel().getColumn(0).setWidth(25);
        table.getColumnModel().getColumn(1).setMinWidth(200);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        table.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(3).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(4).setCellRenderer(centerRenderer);
        DefaultTableCellRenderer toolTipRender = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                float rate = 7.9259257f;
                JLabel c2 = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (rate * (float)c2.getText().length() > (float)table.getColumnModel().getColumn(column).getWidth()) {
                    c2.setToolTipText(c2.getText());
                } else {
                    c2.setToolTipText(null);
                }
                return c2;
            }
        };
        table.getColumnModel().getColumn(1).setCellRenderer(toolTipRender);
        table.getColumnModel().getColumn(2).setCellRenderer(toolTipRender);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem itemSetDefault = new JMenuItem(StringUtil.getText("set.default"));
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting() && table.getSelectedRow() != -1) {
                    try {
                        int selectedRowIndex = table.getSelectedRow();
                        String status = table.getValueAt(selectedRowIndex, 5).toString();
                        if (StringUtil.getText("main.screen.status.invalid").equals(status)) {
                            return;
                        }
                        String grantedFor = table.getValueAt(selectedRowIndex, 1).toString();
                        String grantedBy = table.getValueAt(selectedRowIndex, 2).toString();
                        String issuedDate = table.getValueAt(selectedRowIndex, 3).toString();
                        String endDate = table.getValueAt(selectedRowIndex, 4).toString();
                        for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                            String grandtedForEntry = entry.getCertificate().getSubjectShortName();
                            String grandtedByEntry = entry.getCertificate().getIssuerCN();
                            Date noBeforeDate = entry.getCertificate().getNotBefore();
                            Date noAfterDate = entry.getCertificate().getNotAfter();
                            String issuedDateEntry = DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy");
                            String endDateEntry = DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy");
                            if (!grantedFor.equals(grandtedForEntry) || !grantedBy.equals(grandtedByEntry) || !issuedDate.equals(issuedDateEntry) || !endDate.equals(endDateEntry)) continue;
                            Manager.setDefaultCertSerial(entry.getCertificate().getSerialNumber().toString(16).toUpperCase());
                            Manager.setDefaultCertContent(entry.getCertificateChain()[0].getBase64Encoded());
                            X509Certificate x509Certificate = entry.getCertificate().getCertificate();
                            X509Principal principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
                            Manager.setDefaultCertName((String)principal.getValues(X509Principal.CN).firstElement());
                            String usbSerial = Manager.getUsbSerial();
                            Manager.getConfigObject().setDefautCertToDefautCertList(usbSerial, Manager.getDefaultCertSerial(), StringUtil.renameVietnameseToKeyboardType(Manager.getDefaultCertName()), Manager.getDefaultCertContent());
                            String configFilePath = System.getenv("APPDATA") + "\\" + "713d7e3f12b9eecfbb26bc9d825sfsgfsfsdlozkecmkdoojl098" + "\\" + "c3640649cd6bb07c13199b8381f611d4a61f14a9a10a2b5a624d" + ".txt";
                            Manager.saveConfig(Manager.getConfigObject(), configFilePath);
                            break;
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                        CustomedComponentUtil.showMessageToUser(frame, "message.error", "error");
                    }
                }
            }
        });
        itemSetDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    int selectedRowIndex = table.getSelectedRow();
                    String status = table.getValueAt(selectedRowIndex, 5).toString();
                    if (StringUtil.getText("main.screen.status.invalid").equals(status)) {
                        CustomedComponentUtil.showMessageToUser(frame, "message.invalid.cert", "error");
                        return;
                    }
                    String grantedFor = table.getValueAt(selectedRowIndex, 1).toString();
                    String grantedBy = table.getValueAt(selectedRowIndex, 2).toString();
                    String issuedDate = table.getValueAt(selectedRowIndex, 3).toString();
                    String endDate = table.getValueAt(selectedRowIndex, 4).toString();
                    for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                        String grandtedForEntry = entry.getCertificate().getSubjectShortName();
                        String grandtedByEntry = entry.getCertificate().getIssuerCN();
                        Date noBeforeDate = entry.getCertificate().getNotBefore();
                        Date noAfterDate = entry.getCertificate().getNotAfter();
                        String issuedDateEntry = DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy");
                        String endDateEntry = DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy");
                        if (!grantedFor.equals(grandtedForEntry) || !grantedBy.equals(grandtedByEntry) || !issuedDate.equals(issuedDateEntry) || !endDate.equals(endDateEntry)) continue;
                        Manager.setDefaultCertSerial(entry.getCertificate().getSerialNumber().toString(16).toUpperCase());
                        Manager.setDefaultCertContent(entry.getCertificateChain()[0].getBase64Encoded());
                        X509Certificate x509Certificate = entry.getCertificate().getCertificate();
                        X509Principal principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
                        Manager.setDefaultCertName((String)principal.getValues(X509Principal.CN).firstElement());
                        String usbSerial = Manager.getUsbSerial();
                        Manager.getConfigObject().setDefautCertToDefautCertList(usbSerial, Manager.getDefaultCertSerial(), StringUtil.renameVietnameseToKeyboardType(Manager.getDefaultCertName()), Manager.getDefaultCertContent());
                        String configFilePath = System.getenv("APPDATA") + "\\" + "713d7e3f12b9eecfbb26bc9d825sfsgfsfsdlozkecmkdoojl098" + "\\" + "c3640649cd6bb07c13199b8381f611d4a61f14a9a10a2b5a624d" + ".txt";
                        Manager.saveConfig(Manager.getConfigObject(), configFilePath);
                        CustomedComponentUtil.showMessageToUser(frame, "save.default.cert.success", "info");
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                    CustomedComponentUtil.showMessageToUser(frame, "message.error", "error");
                }
            }
        });
        popup.add(itemSetDefault);
        JMenuItem itemViewCert = new JMenuItem(StringUtil.getText("view.cert"));
        itemViewCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    int selectedRowIndex = table.getSelectedRow();
                    String grantedFor = table.getValueAt(selectedRowIndex, 1).toString();
                    String grantedBy = table.getValueAt(selectedRowIndex, 2).toString();
                    String issuedDate = table.getValueAt(selectedRowIndex, 3).toString();
                    String endDate = table.getValueAt(selectedRowIndex, 4).toString();
                    for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                        String grandtedForEntry = entry.getCertificate().getSubjectShortName();
                        String grandtedByEntry = entry.getCertificate().getIssuerCN();
                        Date noBeforeDate = entry.getCertificate().getNotBefore();
                        Date noAfterDate = entry.getCertificate().getNotAfter();
                        String issuedDateEntry = DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy");
                        String endDateEntry = DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy");
                        if (!grantedFor.equals(grandtedForEntry) || !grantedBy.equals(grandtedByEntry) || !issuedDate.equals(issuedDateEntry) || !endDate.equals(endDateEntry)) continue;
                        String certContent = entry.getCertificateChain()[0].getBase64Encoded();
                        String tempDir = System.getenv("TEMP") + "\\" + "kdfjdjfznfl2384sdknzxlziofrhskhcmnxhsurymglgo9746hfed";
                        File unzipFile = new File(tempDir);
                        if (!unzipFile.exists()) {
                            unzipFile.mkdir();
                        }
                        File temFile = File.createTempFile("temp", ".cer", unzipFile);
                        logger.info("=====> " + temFile.getAbsolutePath());
                        Files.write(temFile.toPath(), certContent.getBytes(), new OpenOption[0]);
                        Desktop.getDesktop().open(temFile);
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                }
            }
        });
        popup.add(itemViewCert);
        JMenuItem itemCreateCert = new JMenuItem(StringUtil.getText("table.get.certificate"));
        itemCreateCert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                try {
                    int selectedRowIndex = table.getSelectedRow();
                    String grantedFor = table.getValueAt(selectedRowIndex, 1).toString();
                    String grantedBy = table.getValueAt(selectedRowIndex, 2).toString();
                    String issuedDate = table.getValueAt(selectedRowIndex, 3).toString();
                    String endDate = table.getValueAt(selectedRowIndex, 4).toString();
                    for (DSSPrivateKeyEntry entry : Manager.getListSignPrivateKeys()) {
                        String[] arrCaCert;
                        String grandtedForEntry = entry.getCertificate().getSubjectShortName();
                        String grandtedByEntry = entry.getCertificate().getIssuerCN();
                        Date noBeforeDate = entry.getCertificate().getNotBefore();
                        Date noAfterDate = entry.getCertificate().getNotAfter();
                        String issuedDateEntry = DateTimeUtils.convertDateTimeToString(noBeforeDate, "dd/MM/yyyy");
                        String endDateEntry = DateTimeUtils.convertDateTimeToString(noAfterDate, "dd/MM/yyyy");
                        if (!grantedFor.equals(grandtedForEntry) || !grantedBy.equals(grandtedByEntry) || !issuedDate.equals(issuedDateEntry) || !endDate.equals(endDateEntry)) continue;
                        String certContent = entry.getCertificateChain()[0].getBase64Encoded();
                        String subjectDNName = entry.getCertificate().getSubjectDN().getName();
                        String fileName = "certificate.cer";
                        if (subjectDNName != null && subjectDNName.contains(",") && (arrCaCert = subjectDNName.split(",")) != null && arrCaCert.length > 0) {
                            for (String strTemp : arrCaCert) {
                                if (strTemp == null || !strTemp.contains("UID") || !strTemp.contains("=") || !strTemp.contains(":")) continue;
                                fileName = strTemp.split(":")[1] + ".cer";
                            }
                        }
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setSelectedFile(new File(fileName));
                        int returnValue = jFileChooser.showSaveDialog(null);
                        if (returnValue == 0) {
                            String path = jFileChooser.getSelectedFile().getAbsolutePath();
                            if (path.endsWith(".cer") || path.endsWith(".crt")) {
                                File tempFile = new File(path);
                                if (tempFile.exists()) {
                                    String tmpFileName = tempFile.getName();
                                    String message = StringUtil.getText("file.exist.confirm.override").replace("{0}", tmpFileName);
                                    int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), message);
                                    if (option == 0) {
                                        logger.info("Create certificate: " + tempFile.getAbsolutePath());
                                        Files.write(tempFile.toPath(), certContent.getBytes(), new OpenOption[0]);
                                    }
                                } else {
                                    logger.info("Create certificate: " + tempFile.getAbsolutePath());
                                    Files.write(tempFile.toPath(), certContent.getBytes(), new OpenOption[0]);
                                }
                            } else {
                                CustomedComponentUtil.showMessageToUser("invalid.cert.file.name", "error");
                            }
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                }
            }
        });
        popup.add(itemCreateCert);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (e2.getButton() == 3) {
                    int r = table.rowAtPoint(e2.getPoint());
                    if (r >= 0 && r < table.getRowCount()) {
                        table.setRowSelectionInterval(r, r);
                    } else {
                        table.clearSelection();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
            }
        });
        table.setComponentPopupMenu(popup);
        JTableHeader header = table.getTableHeader();
        header.setBackground(new Color(218, 232, 239));
        header.setForeground(Color.BLACK);
        header.setSize(header.getSize().width, 50);
        header.setBorder(BorderFactory.createLineBorder(table.getGridColor(), 1));
        table.setTableHeader(header);
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Date d2;
                Date d1 = DateTimeUtils.convertStringToTime(o1.toString(), "dd/MM/yyyy");
                if (d1.before(d2 = DateTimeUtils.convertStringToTime(o2.toString(), "dd/MM/yyyy"))) {
                    return -1;
                }
                if (d1.after(d2)) {
                    return 1;
                }
                return 0;
            }
        };
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        table.setRowSorter(sorter);
        sorter.setComparator(3, comparator);
        sorter.setComparator(4, comparator);
    }

    public static void updateTable(JTable table) {
        JTableHeader tableHeader = table.getTableHeader();
        TableColumnModel tableColumnModel = tableHeader.getColumnModel();
        if (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.getColumn(0).setHeaderValue(StringUtil.getText("stt"));
            tableColumnModel.getColumn(1).setHeaderValue(StringUtil.getText("main.screen.granted.for"));
            tableColumnModel.getColumn(2).setHeaderValue(StringUtil.getText("main.screen.granted.by"));
            tableColumnModel.getColumn(3).setHeaderValue(StringUtil.getText("main.screen.issued.date"));
            tableColumnModel.getColumn(4).setHeaderValue(StringUtil.getText("main.screen.end.date"));
            tableColumnModel.getColumn(5).setHeaderValue(StringUtil.getText("main.screen.status"));
        }
        for (int i2 = 0; i2 < table.getRowCount(); ++i2) {
            if (StringUtil.getVietnameseText("main.screen.status.invalid").equals(table.getValueAt(i2, 5)) || StringUtil.getEnglishText("main.screen.status.invalid").equals(table.getValueAt(i2, 5))) {
                table.setValueAt(StringUtil.getText("main.screen.status.invalid"), i2, 5);
                continue;
            }
            table.setValueAt(StringUtil.getText("main.screen.status.valid"), i2, 5);
        }
        tableHeader.repaint();
        if (table.getComponentPopupMenu() != null) {
            JMenuItem itemSetDefault = (JMenuItem)table.getComponentPopupMenu().getComponents()[0];
            itemSetDefault.setText(StringUtil.getText("set.default"));
            JMenuItem itemViewCert = (JMenuItem)table.getComponentPopupMenu().getComponents()[1];
            itemViewCert.setText(StringUtil.getText("view.cert"));
            JMenuItem itemCreateCert = (JMenuItem)table.getComponentPopupMenu().getComponents()[2];
            itemCreateCert.setText(StringUtil.getText("table.get.certificate"));
        }
    }
}

