/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.usb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.viettel.einvoice.verify.CheckOcspOrCrl;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.connection.ApiClient;
import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import eu.europa.esig.dss.token.object.OutPutObject;
import eu.europa.esig.dss.token.object.SignObject;
import eu.europa.esig.dss.token.object.invoice.AppParamsDTO;
import eu.europa.esig.dss.token.object.invoice.InvoiceDTO;
import eu.europa.esig.dss.token.object.invoice.InvoicesDTO;
import eu.europa.esig.dss.token.object.invoice.UserDTO;
import eu.europa.esig.dss.token.usb.SecureToken;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.StringUtil;
import eu.europa.esig.dss.token.view.LoginInvoice;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.cert.Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.springframework.web.client.HttpClientErrorException;

public class UsbTokenBussiness {
    private static SecureToken secureToken = null;
    private static Map mapTokens = null;
    private static final Logger logger = Logger.getLogger(UsbTokenBussiness.class.getName());
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final ApiClient apiClient = new ApiClient();
    private static HashMap<String, UserDTO> sInvoiceTokens = new HashMap();

    public static String signEinvoice(Session session, String[] arrayDataSign, String serial) throws JsonProcessingException, IOException {
        logger.info("Start signEinvoice");
        try {
            if (arrayDataSign == null || arrayDataSign.length == 0) {
                return "VALUE_EMPTY";
            }
            for (String ele : arrayDataSign) {
                if (ele != null && !"".equals(ele.trim())) continue;
                return "EMPTY_INVOICE";
            }
            for (DSSPrivateKeyEntry key : Manager.getListSignPrivateKeys()) {
                boolean isValid;
                if (!key.getCertificate().getSerialNumber().toString(16).toUpperCase().equals(serial)) continue;
                Date today = new Date();
                Date noBeforeDate = key.getCertificate().getCertificate().getNotBefore();
                Date noAfterDate = key.getCertificate().getCertificate().getNotAfter();
                logger.info("=====> Enterprise : " + key.getCertificate().getSubjectShortName());
                boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
                boolean isValidCert = false;
                logger.info("=====> isValidDate " + isValidDate);
                if (isValidDate) {
                    try {
                        isValidCert = CheckOcspOrCrl.checkCertificateOCSP(key.getCertificate().getCertificate());
                        logger.info("=====> isValidCert " + isValidCert);
                    }
                    catch (ConnectException | SocketTimeoutException e2) {
                        logger.info("Can't connect to server validate certificate");
                        logger.error("Exception", e2);
                        Manager.closeToken();
                        Manager.stopAppSessionTimer();
                        Manager.stopSigning();
                        return "NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN";
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                        Manager.closeToken();
                        Manager.stopAppSessionTimer();
                        Manager.stopSigning();
                        return "HAVE_ERROR_WHEN_SIGING";
                    }
                }
                boolean bl = isValid = isValidDate && isValidCert;
                if (!isValid) {
                    logger.info("Invalid cert to sign");
                    Manager.closeToken();
                    Manager.stopAppSessionTimer();
                    Manager.stopSigning();
                    return "INVALID_CERT_TO_SIGN";
                }
                String signedValueChain = "";
                for (String dataSign : arrayDataSign) {
                    byte[] decodedDataSign = org.apache.commons.codec.binary.Base64.decodeBase64(dataSign);
                    ToBeSigned toBeSigned = new ToBeSigned(decodedDataSign);
                    SignatureValue signatureValue = Manager.getToken().sign(toBeSigned, DigestAlgorithm.SHA1, key);
                    String signedValue = org.apache.commons.codec.binary.Base64.encodeBase64String(signatureValue.getValue());
                    signedValueChain = signedValueChain + " " + signedValue;
                }
                signedValueChain = signedValueChain.substring(1);
                OutPutObject outputResponse = new OutPutObject();
                outputResponse.setSerial(key.getCertificate().getSerialNumber().toString(16).toUpperCase());
                outputResponse.setCertRaw(key.getCertificate().getIssuerCN() + "," + key.getCertificateChain()[0].getBase64Encoded());
                outputResponse.setSignValue(signedValueChain);
                ObjectMapper mapper = new ObjectMapper();
                String output = mapper.writeValueAsString(outputResponse);
                session.getRemote().sendString(output);
                session.close();
                Manager.stopSigning();
                logger.info("Sign invoice success");
                return "SIGN_SUCCESS";
            }
        }
        catch (Exception e3) {
            logger.error("Have error: ", e3);
            try {
                Manager.closeToken();
                Manager.stopSigning();
                Manager.stopAppSessionTimer();
            }
            catch (Exception ex) {
                logger.error("Have error: ", ex);
            }
        }
        return "HAVE_ERROR_WHEN_SIGING";
    }

    public static boolean sendChoosenCertificate(DSSPrivateKeyEntry key, String taxCode) throws Exception {
        String serial = key.getCertificate().getSerialNumber().toString(16).toUpperCase();
        OutPutObject outputResponse = new OutPutObject();
        outputResponse.setSerial(serial);
        if (taxCode != null && !taxCode.isEmpty()) {
            String[] parts;
            byte[] certBytes = key.getCertificate().getEncoded();
            String base64Cert = Base64.getEncoder().encodeToString(certBytes);
            String pemCert = "-----BEGIN CERTIFICATE-----\n" + base64Cert + "\n-----END CERTIFICATE-----";
            String filename = "";
            String dn = key.getCertificate().getSubjectDN().toString();
            if (dn != null && dn.length() > 0 && dn.contains("OID.0.9.2342.19200300.100.1.1")) {
                dn = dn.replace("OID.0.9.2342.19200300.100.1.1", "UID");
            }
            for (String part : parts = dn.split(",")) {
                String[] subPart;
                if (!part.contains("UID=MST:") || (subPart = part.split(":")).length <= 1) continue;
                filename = subPart[1].trim();
            }
            outputResponse.setFilename(filename + ".cer");
            outputResponse.setContent(pemCert);
        } else {
            outputResponse.setCertRaw(key.getCertificate().getIssuerCN() + "," + key.getCertificateChain()[0].getBase64Encoded());
        }
        ObjectMapper mapper = new ObjectMapper();
        String output = mapper.writeValueAsString(outputResponse);
        WebsocketHandler.getSessionReal().getRemote().sendString(output);
        return true;
    }

    public static synchronized int getNumUsbTokenPlugIn() throws Exception {
        secureToken = new SecureToken();
        secureToken.initialize();
        mapTokens = secureToken.getMapTokens(secureToken);
        return mapTokens == null ? 0 : mapTokens.size();
    }

    public static String sendChosenCertToServerWhenDefautCertExist() {
        try {
            boolean isValid;
            if (StringUtil.isNullOrEmpty(Manager.getDefaultCertSerial()).booleanValue() || Manager.getListSignPrivateKeys() == null || Manager.getListSignPrivateKeys().isEmpty()) {
                throw new IllegalArgumentException("Invalid input for sendChosenCertToServerWhenDefautCertExist");
            }
            DSSPrivateKeyEntry key = null;
            for (DSSPrivateKeyEntry ele : Manager.getListSignPrivateKeys()) {
                String serial = ele.getCertificate().getSerialNumber().toString(16).toUpperCase();
                if (!Manager.getDefaultCertSerial().equals(serial)) continue;
                key = ele;
                break;
            }
            if (key == null) {
                return "DEFAULT_CERT_NOT_IN_USB_TOKEN";
            }
            Date today = new Date();
            Date noBeforeDate = key.getCertificate().getCertificate().getNotBefore();
            Date noAfterDate = key.getCertificate().getCertificate().getNotAfter();
            logger.info("=====> Enterprise : " + key.getCertificate().getSubjectShortName());
            boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
            boolean isValidCert = false;
            logger.info("=====> isValidDate " + isValidDate);
            if (isValidDate) {
                try {
                    isValidCert = CheckOcspOrCrl.checkCertificateOCSP(key.getCertificate().getCertificate());
                    logger.info("=====> isValidCert " + isValidCert);
                }
                catch (ConnectException | SocketTimeoutException e2) {
                    logger.info("Can't connect to server validate certificate");
                    logger.error("Exception", e2);
                    return "NO_INTERNET_CONNECTION_TO_VALIDATE_DEFAUT_CERT";
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                    return "DEFAULT_CERT_HAVE_ERROR";
                }
            }
            boolean bl = isValid = isValidDate && isValidCert;
            if (!isValid) {
                return "INVALID_DEFAULT_CERT";
            }
            OutPutObject outputResponse = new OutPutObject();
            String serial = key.getCertificate().getSerialNumber().toString(16).toUpperCase();
            outputResponse.setSerial(serial);
            outputResponse.setCertRaw(key.getCertificate().getIssuerCN() + "," + key.getCertificateChain()[0].getBase64Encoded());
            ObjectMapper mapper = new ObjectMapper();
            String output = mapper.writeValueAsString(outputResponse);
            WebsocketHandler.getSessionReal().getRemote().sendString(output);
            return "SIGN_SUCCESS";
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
            return "DEFAULT_CERT_HAVE_ERROR";
        }
    }

    public static String exportToPEM(Certificate certificate) {
        try {
            Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes());
            byte[] rawCrtText = certificate.getEncoded();
            String encodedCertText = new String(encoder.encode(rawCrtText));
            String prettified_cert = BEGIN_CERT + LINE_SEPARATOR + encodedCertText + LINE_SEPARATOR + END_CERT;
            return prettified_cert;
        }
        catch (Exception e2) {
            logger.error(e2);
            return null;
        }
    }

    public static String signEinvoices(Session session, SignObject data, String serial) throws JsonProcessingException, IOException {
        logger.info("Start signEinvoice");
        if (!(data.getVinvoiceToken() != null && !"".equals(data.getVinvoiceToken()) || sInvoiceTokens.containsKey(data.getSerialToCheck()) && UsbTokenBussiness.loginSInvoice(data.getGateWay(), sInvoiceTokens.get(data.getSerialToCheck())))) {
            UserDTO userDTO = new UserDTO();
            LoginInvoice loginInvoice = new LoginInvoice(userDTO);
            loginInvoice.setModal(true);
            loginInvoice.setLocationRelativeTo(null);
            int count = 0;
            do {
                loginInvoice.setUsernameFocus();
                loginInvoice.setVisible(true);
                if (userDTO.getUsername() == null) continue;
                if (UsbTokenBussiness.loginSInvoice(data.getGateWay(), userDTO)) {
                    sInvoiceTokens.put(data.getSerialToCheck(), userDTO);
                    break;
                }
                ++count;
                CustomedComponentUtil.showMessageToUser("message.invalid.invoice.user", "error");
            } while (userDTO.getUsername() != null && count < 2);
            if (userDTO.getUsername() == null || count >= 2) {
                sInvoiceTokens.remove(data.getSerialToCheck());
                Manager.stopSigning();
                return "INVALID_INVOICE_USER";
            }
        }
        try {
            if (data.getInvoices() == null || data.getInvoices().size() == 0) {
                return "VALUE_EMPTY";
            }
            String urlRoleBack = data.getGateWay() + "/invoice/update/usb-token/after-sign-fail";
            AtomicInteger sum = new AtomicInteger();
            data.getInvoices().forEach(lst -> sum.addAndGet(lst.size()));
            Integer numSuccess = 0;
            for (DSSPrivateKeyEntry key : Manager.getListSignPrivateKeys()) {
                boolean isValid;
                if (!key.getCertificate().getSerialNumber().toString(16).toUpperCase().equals(serial)) continue;
                Date today = new Date();
                Date noBeforeDate = key.getCertificate().getCertificate().getNotBefore();
                Date noAfterDate = key.getCertificate().getCertificate().getNotAfter();
                logger.info("=====> Enterprise : " + key.getCertificate().getSubjectShortName());
                boolean isValidDate = today.after(noBeforeDate) && today.before(noAfterDate);
                boolean isValidCert = false;
                logger.info("=====> isValidDate " + isValidDate);
                if (isValidDate) {
                    try {
                        isValidCert = CheckOcspOrCrl.checkCertificateOCSP(key.getCertificate().getCertificate());
                        logger.info("=====> isValidCert " + isValidCert);
                    }
                    catch (ConnectException | SocketTimeoutException e2) {
                        logger.info("Can't connect to server validate certificate");
                        logger.error("Exception", e2);
                        Manager.closeToken();
                        Manager.stopAppSessionTimer();
                        Manager.stopSigning();
                        return "NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN";
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                        Manager.closeToken();
                        Manager.stopAppSessionTimer();
                        Manager.stopSigning();
                        return "HAVE_ERROR_WHEN_SIGING";
                    }
                }
                boolean bl = isValid = isValidDate && isValidCert;
                if (!isValid) {
                    logger.info("Invalid cert to sign");
                    Manager.closeToken();
                    Manager.stopAppSessionTimer();
                    Manager.stopSigning();
                    return "INVALID_CERT_TO_SIGN";
                }
                String certBase64 = UsbTokenBussiness.exportToPEM(key.getCertificate().getCertificate()).replace(BEGIN_CERT, "").replace(END_CERT, "").replace("\r", "").replace("\n", "");
                if (data.getInvoices().size() == 1 && data.getInvoices().get(0).size() == 1) {
                    Integer step = 1;
                    InvoiceDTO invoiceDTO = data.getInvoices().get(0).get(0);
                    try {
                        String url = data.getGateWay() + "/invoice/draft/release/usb-token/before-sign";
                        invoiceDTO.setIssueDate(data.getIssueDate() != null ? data.getIssueDate() : Instant.now());
                        invoiceDTO.setSerial(data.getSerialToCheck());
                        invoiceDTO.setCertString(certBase64);
                        InvoiceDTO invoiceHash = (InvoiceDTO)apiClient.postDataInvoice(url, data.getVinvoiceToken(), invoiceDTO, InvoiceDTO.class);
                        step = 2;
                        String dataSign = invoiceHash.getHashValue();
                        String[] arrayDataSign = dataSign.split(" ");
                        String signedValueChain = "";
                        for (String signData : arrayDataSign) {
                            byte[] decodedDataSign = org.apache.commons.codec.binary.Base64.decodeBase64(signData);
                            ToBeSigned toBeSigned = new ToBeSigned(decodedDataSign);
                            SignatureValue signatureValue = Manager.getToken().sign(toBeSigned, DigestAlgorithm.SHA1, key);
                            String signedValue = org.apache.commons.codec.binary.Base64.encodeBase64String(signatureValue.getValue());
                            signedValueChain = signedValueChain + " " + (String)signedValue;
                        }
                        signedValueChain = signedValueChain.substring(1);
                        Integer n2 = numSuccess;
                        Integer n3 = numSuccess = Integer.valueOf(numSuccess + 1);
                        String string = data.getGateWay() + "/invoice/draft/release/usb-token/after-sign";
                        invoiceHash.setSignatureValue(signedValueChain);
                        InvoiceDTO invoiceInsert = (InvoiceDTO)apiClient.postDataInvoice(string, data.getVinvoiceToken(), invoiceHash, InvoiceDTO.class);
                        OutPutObject outputResponse = new OutPutObject();
                        outputResponse.setSerial(key.getCertificate().getSerialNumber().toString(16).toUpperCase());
                        outputResponse.setCertRaw(key.getCertificate().getIssuerCN() + "," + key.getCertificateChain()[0].getBase64Encoded());
                        outputResponse.setSignValue(signedValueChain);
                        outputResponse.setMessageCode("COMPLETED_SIGN_ONE_INVOICE");
                        outputResponse.setContent("\u0110\u00e3 k\u00fd th\u00e0nh c\u00f4ng " + numSuccess + "/" + sum.get() + " h\u00f3a \u0111\u01a1n");
                        outputResponse.setInvoiceDTO(invoiceInsert);
                        ObjectMapper mapper = new ObjectMapper();
                        String output = mapper.writeValueAsString(outputResponse);
                        session.getRemote().sendString(output);
                        continue;
                    }
                    catch (Exception e3) {
                        String output;
                        Object mapper;
                        Object outputResponse;
                        logger.error("signHash ERROR: " + e3.getMessage(), e3);
                        if (step == 1) {
                            outputResponse = new OutPutObject();
                            ((OutPutObject)outputResponse).setMessageCode("SIGN_ERROR");
                            ((OutPutObject)outputResponse).setContent(UsbTokenBussiness.getErrorMessage(e3));
                            ((OutPutObject)outputResponse).setInvoiceDTO(invoiceDTO);
                            mapper = new ObjectMapper();
                            output = ((ObjectMapper)mapper).writeValueAsString(outputResponse);
                            session.getRemote().sendString(output);
                            Manager.closeToken();
                            Manager.stopAppSessionTimer();
                            Manager.stopSigning();
                            return "HAVE_ERROR_WHEN_SIGING";
                        }
                        try {
                            outputResponse = apiClient.postDataInvoice(urlRoleBack, data.getVinvoiceToken(), Collections.singletonList(invoiceDTO.getId()), Object.class);
                        }
                        catch (Exception ex) {
                            logger.error("signHash ERROR 2: " + ex.getMessage(), ex);
                        }
                        outputResponse = new OutPutObject();
                        ((OutPutObject)outputResponse).setMessageCode("FORCE_CLOSE");
                        ((OutPutObject)outputResponse).setContent(UsbTokenBussiness.getErrorMessage(e3));
                        mapper = new ObjectMapper();
                        output = ((ObjectMapper)mapper).writeValueAsString(outputResponse);
                        session.getRemote().sendString(output);
                        Manager.closeToken();
                        Manager.stopAppSessionTimer();
                        Manager.stopSigning();
                        return "HAVE_ERROR_WHEN_SIGING";
                    }
                }
                Integer batch = 20;
                Long sleep = 500L;
                Integer retry = 5;
                try {
                    List appParamsDTOList = (List)apiClient.getDataInvoice(data.getGateWay() + "/app-params/get-app-params-by-partype?parType=CONFIG_REDIS_RELEASE_MULTI_USB", data.getVinvoiceToken(), null, new TypeReference<List<AppParamsDTO>>(){});
                    if (appParamsDTOList != null && appParamsDTOList.size() > 0) {
                        for (AppParamsDTO appParamsDTO : appParamsDTOList) {
                            if (appParamsDTO.getParCode().equals("CONFIG_REDIS_RELEASE_MULTI_USB_BATCH")) {
                                batch = Integer.parseInt(appParamsDTO.getParName());
                            }
                            if (appParamsDTO.getParCode().equals("CONFIG_REDIS_RELEASE_MULTI_USB_SLEEP")) {
                                sleep = Long.parseLong(appParamsDTO.getParName());
                            }
                            if (!appParamsDTO.getParCode().equals("CONFIG_REDIS_RELEASE_MULTI_USB_REPEAT")) continue;
                            retry = Integer.parseInt(appParamsDTO.getParName());
                        }
                    }
                }
                catch (Exception e4) {
                    logger.error(e4.getMessage(), e4);
                }
                for (List<InvoiceDTO> dataInvoices : data.getInvoices()) {
                    int total = dataInvoices.size();
                    for (int batchNo = 0; batchNo < (total + batch - 1) / batch; ++batchNo) {
                        ArrayList<Long> invoiceIds;
                        Integer n4 = 1;
                        ArrayList<InvoiceDTO> lstInvoiceBatch = new ArrayList<InvoiceDTO>();
                        for (int i2 = batchNo * batch; i2 < Math.min((batchNo + 1) * batch, total); ++i2) {
                            lstInvoiceBatch.add(dataInvoices.get(i2));
                        }
                        Integer numInvoicesOfBatch = lstInvoiceBatch.size();
                        ArrayList<InvoiceDTO> lstInvoiceSucc = new ArrayList<InvoiceDTO>();
                        try {
                            String url = data.getGateWay() + "/invoice/draft/release-invoices/usb-token/before-sign";
                            InvoicesDTO invoicesDTO = new InvoicesDTO();
                            invoicesDTO.setIssueDate(data.getIssueDate() != null ? data.getIssueDate() : Instant.now());
                            invoicesDTO.setSerial(data.getSerialToCheck());
                            invoicesDTO.setCertString(certBase64);
                            invoiceIds = new ArrayList<Long>();
                            for (InvoiceDTO invoiceDTO : lstInvoiceBatch) {
                                invoiceIds.add(invoiceDTO.getId());
                            }
                            invoicesDTO.setInvoiceIds(invoiceIds);
                            InvoicesDTO invoicesHash = (InvoicesDTO)apiClient.postDataInvoice(url, data.getVinvoiceToken(), invoicesDTO, InvoicesDTO.class);
                            Integer n5 = 2;
                            for (InvoiceDTO iv3 : invoicesHash.getLstInvoiceDTO()) {
                                Object arrayDataSign;
                                try {
                                    String dataSign = iv3.getHashValue();
                                    arrayDataSign = dataSign.split(" ");
                                    String signedValueChain = "";
                                    for (String signData : arrayDataSign) {
                                        byte[] decodedDataSign = org.apache.commons.codec.binary.Base64.decodeBase64(signData);
                                        ToBeSigned toBeSigned = new ToBeSigned(decodedDataSign);
                                        SignatureValue signatureValue = Manager.getToken().sign(toBeSigned, DigestAlgorithm.SHA1, key);
                                        String signedValue = org.apache.commons.codec.binary.Base64.encodeBase64String(signatureValue.getValue());
                                        signedValueChain = signedValueChain + " " + signedValue;
                                    }
                                    signedValueChain = signedValueChain.substring(1);
                                    iv3.setSignatureValue(signedValueChain);
                                    lstInvoiceSucc.add(iv3);
                                    Integer n6 = numSuccess;
                                    Integer n7 = numSuccess = Integer.valueOf(numSuccess + 1);
                                    OutPutObject outPutObject = new OutPutObject();
                                    outPutObject.setSerial(key.getCertificate().getSerialNumber().toString(16).toUpperCase());
                                    outPutObject.setCertRaw(key.getCertificate().getIssuerCN() + "," + key.getCertificateChain()[0].getBase64Encoded());
                                    outPutObject.setSignValue(signedValueChain);
                                    outPutObject.setMessageCode("COMPLETED_SIGN_ONE_INVOICE");
                                    outPutObject.setContent("\u0110\u00e3 k\u00fd th\u00e0nh c\u00f4ng " + numSuccess + "/" + sum.get() + " h\u00f3a \u0111\u01a1n");
                                    outPutObject.setInvoiceDTO(iv3);
                                    ObjectMapper mapper = new ObjectMapper();
                                    String output = mapper.writeValueAsString(outPutObject);
                                    session.getRemote().sendString(output);
                                }
                                catch (Exception ex) {
                                    try {
                                        arrayDataSign = apiClient.postDataInvoice(urlRoleBack, data.getVinvoiceToken(), Collections.singletonList(iv3.getId()), Object.class);
                                    }
                                    catch (Exception e5) {
                                        logger.error("signHash ERROR 2: " + e5.getMessage(), e5);
                                    }
                                    OutPutObject outputResponse = new OutPutObject();
                                    outputResponse.setMessageCode("SIGN_ERROR");
                                    outputResponse.setContent(UsbTokenBussiness.getErrorMessage(ex));
                                    outputResponse.setInvoiceDTO(iv3);
                                    ObjectMapper mapper = new ObjectMapper();
                                    String string = mapper.writeValueAsString(outputResponse);
                                    session.getRemote().sendString(string);
                                }
                            }
                            invoicesHash.setLstInvoiceDTO(lstInvoiceSucc);
                            String string = data.getGateWay() + "/invoice/draft/release-invoices/usb-token/after-sign";
                            apiClient.postDataInvoice(string, data.getVinvoiceToken(), invoicesHash, Object.class);
                            Integer completedInvoice = 0;
                            Integer retryUse = (int)retry;
                            do {
                                try {
                                    Thread.sleep(sleep);
                                    completedInvoice = (Integer)apiClient.getDataInvoice(data.getGateWay() + "/invoice/get-completed-invoices-after-sign", data.getVinvoiceToken(), null, Integer.class);
                                }
                                catch (Exception e6) {
                                    logger.error(e6.getMessage(), e6);
                                }
                                Integer n8 = retryUse;
                                Integer n9 = retryUse = Integer.valueOf(retryUse - 1);
                            } while (retryUse > 0 && (completedInvoice == null || completedInvoice < numInvoicesOfBatch));
                            continue;
                        }
                        catch (Exception e7) {
                            if (n4 == 2 && lstInvoiceSucc.size() > 0) {
                                ArrayList<Long> lstId = new ArrayList<Long>();
                                for (InvoiceDTO iv : lstInvoiceSucc) {
                                    lstId.add(iv.getId());
                                }
                                invoiceIds = apiClient.postDataInvoice(urlRoleBack, data.getVinvoiceToken(), lstId, Object.class);
                            }
                            logger.error("signHash ERROR " + n4 + ": " + e7.getMessage(), e7);
                            OutPutObject outputResponse = new OutPutObject();
                            outputResponse.setMessageCode("SIGN_ERROR");
                            outputResponse.setContent(UsbTokenBussiness.getErrorMessage(e7));
                            ObjectMapper mapper = new ObjectMapper();
                            String output = mapper.writeValueAsString(outputResponse);
                            session.getRemote().sendString(output);
                        }
                    }
                }
            }
            OutPutObject outputResponse = new OutPutObject();
            outputResponse.setContent("\u0110\u00e3 k\u00fd th\u00e0nh c\u00f4ng " + numSuccess + "/" + sum.get() + " h\u00f3a \u0111\u01a1n");
            ObjectMapper mapper = new ObjectMapper();
            String output = mapper.writeValueAsString(outputResponse);
            session.getRemote().sendString(output);
            session.close();
            Manager.stopSigning();
            logger.info("Sign invoice success");
            return "SIGN_SUCCESS";
        }
        catch (Exception e8) {
            logger.error("Have error: ", e8);
            try {
                OutPutObject outputResponse = new OutPutObject();
                outputResponse.setMessageCode("FORCE_CLOSE");
                outputResponse.setContent(UsbTokenBussiness.getErrorMessage(e8));
                ObjectMapper mapper = new ObjectMapper();
                String output = mapper.writeValueAsString(outputResponse);
                session.getRemote().sendString(output);
                Manager.closeToken();
                Manager.stopSigning();
                Manager.stopAppSessionTimer();
            }
            catch (Exception ex) {
                logger.error("Have error: ", ex);
            }
            return "HAVE_ERROR_WHEN_SIGING";
        }
    }

    public static String getErrorMessage(Exception ex) throws Exception {
        try {
            String json = new String(((HttpClientErrorException)ex).getResponseBodyAsByteArray(), "UTF-8");
            Map map = UsbTokenBussiness.castStrToObject(json, Map.class);
            String msg = (String)(map.get("data") != null ? map.get("data") : (map.get("message") != null ? map.get("message") : map.get("error")));
            return msg;
        }
        catch (Exception e2) {
            return "C\u00f3 l\u1ed7i trong qu\u00e1 tr\u00ecnh k\u00fd h\u00f3a \u0111\u01a1n, b\u1ea1n vui l\u00f2ng th\u1ef1c hi\u1ec7n l\u1ea1i!";
        }
    }

    public static <T> T castStrToObject(String listProduct, Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule(new JavaTimeModule());
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return objectMapper.readValue(listProduct, clazz);
    }

    public static boolean loginSInvoice(String gateWay, UserDTO userDTO) {
        try {
            URL url = new URL(gateWay);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            int finalPort = port != -1 ? port : url.getDefaultPort();
            String result = protocol + "://" + host + ":" + finalPort;
            apiClient.postDataInvoice(result + "/auth/login", null, userDTO, Object.class);
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }
}

