/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.usb;

import eu.europa.esig.dss.token.usb.MessageCode;
import eu.europa.esig.dss.token.usb.Token;
import eu.europa.esig.dss.token.utils.PropertiesUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;

public class SecureToken
implements Closeable {
    private static final Logger logger = Logger.getLogger(SecureToken.class);
    private static final String PKCS11_KEYSTORE_TYPE = "PKCS11";
    private static final String PKCS11_PROVIDER_NAME = "SecureMetricST3";
    private static final String NEW_PROVIDER = "SunPKCS11-SecureMetricST3";
    private ArrayList tokens;
    private KeyStore store;
    private boolean login = false;

    public SecureToken initialize() throws Exception {
        SecureToken secureToken3 = new SecureToken();
        String listFileLib = PropertiesUtils.getResource("libraries");
        this.setTokens(new ArrayList());
        String[] pkcs11LibraryNames = listFileLib.split(";");
        for (int i2 = 0; i2 < pkcs11LibraryNames.length; ++i2) {
            String pkcs11LibraryFileName = System.getenv("windir") + "\\system32\\" + pkcs11LibraryNames[i2];
            File pkcs11LibraryFile = new File(pkcs11LibraryFileName);
            if (!pkcs11LibraryFile.exists()) continue;
            try {
                CK_C_INITIALIZE_ARGS initArgs = new CK_C_INITIALIZE_ARGS();
                PKCS11 pkcs11 = PKCS11.getInstance(pkcs11LibraryFileName, "C_GetFunctionList", initArgs, false);
                long[] slotList = pkcs11.C_GetSlotList(true);
                if (slotList.length == 0) continue;
                for (int j2 = 0; j2 < slotList.length; ++j2) {
                    try {
                        CK_TOKEN_INFO infoToken = pkcs11.C_GetTokenInfo(slotList[j2]);
                        this.tokens.add(new Token(pkcs11LibraryFileName, slotList[j2], new String(infoToken.label), new String(infoToken.serialNumber)));
                        continue;
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return secureToken3;
    }

    public MessageCode loginToken(String pin, Token token) {
        MessageCode code = new MessageCode();
        Security.removeProvider(PKCS11_PROVIDER_NAME);
        Security.removeProvider(NEW_PROVIDER);
        File file = new File(token.getLibName());
        if (!file.exists()) {
            code.setResultCode(0);
            return code;
        }
        String config = "name=SecureMetricST3\nlibrary=" + token.getLibName() + "\nslot=" + Long.toString(token.getSlot());
        try {
            SunPKCS11 p = new SunPKCS11((InputStream)new ByteArrayInputStream(config.getBytes()));
            Security.addProvider(p);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        try {
            this.store = KeyStore.getInstance(PKCS11_KEYSTORE_TYPE);
        }
        catch (Exception e3) {
            this.store = null;
            code.setResultCode(1);
            logger.error("Have error: ", e3);
            return code;
        }
        try {
            this.store.load(null, pin.toCharArray());
            code.setResultCode(3);
            this.login = true;
        }
        catch (Exception e4) {
            this.store = null;
            code.setResultCode(2);
            logger.error("Have error: ", e4);
        }
        return code;
    }

    @Override
    public void close() throws IOException {
        AuthProvider authProvider = (AuthProvider)this.store.getProvider();
        if (authProvider != null) {
            try {
                authProvider.logout();
                this.store = null;
                this.login = false;
            }
            catch (LoginException e2) {
                logger.error("Have error: ", e2);
            }
        }
    }

    public ArrayList<KeyStore.PrivateKeyEntry> getPrivateKeyEntries() throws Exception {
        ArrayList<KeyStore.PrivateKeyEntry> privateKeyEntries = new ArrayList<KeyStore.PrivateKeyEntry>();
        Enumeration<String> aliasesEnum = this.store.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            if (!this.store.isKeyEntry(alias)) continue;
            privateKeyEntries.add(new KeyStore.PrivateKeyEntry((PrivateKey)this.store.getKey(alias, null), this.store.getCertificateChain(alias)));
        }
        return privateKeyEntries;
    }

    public ArrayList<Token> getTokens() {
        return this.tokens;
    }

    public void setTokens(ArrayList tokens) {
        this.tokens = tokens;
    }

    public void setStore(KeyStore store) {
        this.store = store;
    }

    public void setLogin(boolean login) {
        this.login = login;
    }

    public KeyStore getStore() {
        return this.store;
    }

    public boolean isLogin() {
        return this.login;
    }

    public Map getMapTokens(SecureToken secureToken) throws Exception {
        ArrayList<Token> tokenList = secureToken.getTokens();
        HashMap<String, Token> mapTokens = new HashMap<String, Token>();
        if (tokenList == null || tokenList.size() <= 0) {
            return null;
        }
        for (int i2 = 0; i2 < tokenList.size(); ++i2) {
            Token token = tokenList.get(i2);
            mapTokens.put(token.getTokenSerial(), token);
        }
        return mapTokens;
    }

    public String[] getListTokenName(Map mapTokens) {
        Collection tokens = mapTokens.values();
        String[] tokenNames = new String[tokens.size()];
        int i2 = 0;
        for (Token token : tokens) {
            tokenNames[i2++] = token.getTokenName();
        }
        return tokenNames;
    }

    public String[] getListCertName(Map mapPrivateKeyEntries) throws CertificateEncodingException {
        Iterator iterator = mapPrivateKeyEntries.keySet().iterator();
        String[] certNames = new String[mapPrivateKeyEntries.size()];
        int i2 = 0;
        while (iterator.hasNext()) {
            String certName = (String)iterator.next();
            certNames[i2++] = certName;
        }
        return certNames;
    }

    public Map getMapPrivateKeyEntries(ArrayList<KeyStore.PrivateKeyEntry> privateKeyEntries) throws Exception {
        HashMap<String, KeyStore.PrivateKeyEntry> mapPrivateKeyEntries = new HashMap<String, KeyStore.PrivateKeyEntry>();
        for (int i2 = 0; i2 < privateKeyEntries.size(); ++i2) {
            KeyStore.PrivateKeyEntry privateKeyEntry = privateKeyEntries.get(i2);
            X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
            mapPrivateKeyEntries.put((String)principal.getValues(X509Principal.CN).firstElement(), privateKeyEntries.get(i2));
        }
        return mapPrivateKeyEntries;
    }
}

