/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.thread;

import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import eu.europa.esig.dss.token.object.UsbTokenObject;
import eu.europa.esig.dss.token.usb.SecureToken;
import eu.europa.esig.dss.token.usb.Token;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class UsbTokenPlugedInSessionManager
extends TimerTask {
    private SecureToken secureToken = null;
    private Map mapTokens = null;
    private static final Logger logger = Logger.getLogger(UsbTokenPlugedInSessionManager.class.getName());

    @Override
    public void run() {
        try {
            this.secureToken = new SecureToken();
            this.secureToken.initialize();
            this.mapTokens = this.secureToken.getMapTokens(this.secureToken);
            if (this.mapTokens != null) {
                if (this.mapTokens.size() > 1) {
                    if (Manager.isIsSigning()) {
                        Manager.stopSigning();
                        WebsocketHandler.sendMessageToServer("MORE_THAN_ONE_USB_TOKEN_TO_SIGN");
                        WebsocketHandler.setSessionReal(null);
                        Manager.getChooseCertTableFrame().setVisible(false);
                        Manager.getSignFrame().setVisible(false);
                    } else {
                        Manager.getMainScreen().showMessageToUser("use.one.usb-token.unplug.to.go.on", "error");
                    }
                    Manager.stopAppSessionTimer();
                    Manager.closeToken();
                    Manager.getMainScreen().showJpanelAbout(Manager.getMainScreen().isVisible());
                    Manager.setNumUsbToken(this.mapTokens.size());
                } else {
                    if (Manager.getNumUsbToken() != 1) {
                        Manager.getMainScreen().clearDefaultCertSetup();
                        String key = (String)this.mapTokens.keySet().toArray()[0];
                        Token token = (Token)this.mapTokens.get(key);
                        Manager.setUsbSerial(token.getTokenSerial());
                        ArrayList<UsbTokenObject> defaultCertList = Manager.getConfigObject().getDefaultCertList();
                        if (defaultCertList != null && !defaultCertList.isEmpty()) {
                            for (UsbTokenObject usbTokenObject : defaultCertList) {
                                if (StringUtil.isNullOrEmpty(token.getTokenSerial()).booleanValue() || usbTokenObject == null || !token.getTokenSerial().equals(usbTokenObject.getUsbSerial())) continue;
                                Manager.setDefaultCertSerial(usbTokenObject.getCertSerial());
                                Manager.setDefaultCertName(StringUtil.renameKeyboardTypeToVietnamese(usbTokenObject.getCertName()));
                                Manager.setDefaultCertContent(usbTokenObject.getCertContent());
                                break;
                            }
                        }
                        Manager.getMainScreen().resetDefaultCertCombobox();
                    }
                    Manager.setNumUsbToken(1);
                }
            } else {
                if (Manager.getNumUsbToken() >= 1) {
                    Manager.stopAppSessionTimer();
                    Manager.closeToken();
                    Manager.getMainScreen().clearDefaultCertSetup();
                    Manager.clearUsbSerial();
                    Manager.getMainScreen().resetDefaultCertCombobox();
                    if (Manager.isIsSigning()) {
                        Manager.stopSigning();
                        WebsocketHandler.sendMessageToServer("USB-UNPLUG");
                        WebsocketHandler.setSessionReal(null);
                        Manager.getChooseCertTableFrame().setVisible(false);
                        Manager.getSignFrame().setVisible(false);
                        CustomedComponentUtil.showMessageToUser("disconnect.usb.token", "error");
                    } else if (Manager.getMainScreen().getjPanelShowCert().isVisible() || Manager.getMainScreen().getjPanelChooseCert().isVisible()) {
                        Manager.getMainScreen().showJpanelAbout(Manager.getMainScreen().isVisible());
                        Manager.getMainScreen().showMessageToUser("disconnect.usb.token", "error");
                    } else {
                        Manager.getMainScreen().showMessageToUser("disconnect.usb.token", "info");
                    }
                }
                Manager.setNumUsbToken(0);
            }
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }
}

