/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.thread;

import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.io.File;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class SessionManagerThread
extends TimerTask {
    private AtomicInteger numCountTimeout = new AtomicInteger(0);
    private static final int maxCount = 30;
    private static final Logger logger = Logger.getLogger(SessionManagerThread.class.getName());

    @Override
    public void run() {
        logger.info(" ===> Run Session time out process");
        if (this.numCountTimeout.intValue() >= Manager.getConfigObject().getTimeout() && !Manager.isIsSigning()) {
            logger.info(" =====> Run Session time out delete session");
            this.numCountTimeout = new AtomicInteger(0);
            Manager.stopSigning();
            String path = System.getenv("temp") + "\\" + "kdfjdjfznfl2384sdknzxlziofrhskhcmnxhsurymglgo9746hfed";
            SessionManagerThread.emptyTempDir(path);
            logger.info("=====> Delete session object");
            Manager.closeToken();
            Manager.stopAppSessionTimer();
            if (Manager.getMainScreen().isVisible()) {
                if (Manager.getMainScreen().getjPanelShowCert().isVisible() || Manager.getMainScreen().getjPanelChooseCert().isVisible()) {
                    Manager.getMainScreen().showJpanelPassword();
                }
                if (Manager.getMainScreen().getjPanelSetup().isVisible()) {
                    Manager.getMainScreen().resetDefaultCertCombobox();
                }
                Manager.getMainScreen().showMessageToUser("login.session.time.out", "info");
            } else if (Manager.getViewInvoiceFrame().isVisible()) {
                Manager.getViewInvoiceFrame().showMessageToUser("login.session.time.out", "info");
            } else {
                CustomedComponentUtil.showMessageToUser("login.session.time.out", "info");
            }
        } else {
            this.numCountTimeout.incrementAndGet();
            logger.info("=====>Run Session time out increment counter :" + this.numCountTimeout);
            logger.info("=====>Is app signing :" + Manager.isIsSigning());
        }
    }

    private static void emptyTempDir(String path) {
        if (StringUtil.isNullOrEmpty(path).booleanValue()) {
            return;
        }
        try {
            File tempDir = new File(path);
            if (tempDir.exists()) {
                File[] listFile = tempDir.listFiles();
                int len = listFile.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    File file = listFile[i2];
                    if (file.isFile() || file.listFiles() == null || file.listFiles().length == 0) {
                        logger.info(file.getAbsoluteFile().toString());
                        file.delete();
                    } else {
                        SessionManagerThread.emptyTempDir(file.getAbsolutePath());
                    }
                    if (i2 != len - 1) continue;
                    SessionManagerThread.emptyTempDir(file.getParent());
                }
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }
}

