/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.thread;

import eu.europa.esig.dss.token.utils.StringUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Calendar;
import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class DeleteLogManagerThread
extends TimerTask {
    private static final Logger logger = Logger.getLogger(DeleteLogManagerThread.class.getName());
    private AtomicInteger numCountTimeout = new AtomicInteger(0);
    private static final int maxCount = 60;

    @Override
    public void run() {
        try {
            if (this.numCountTimeout.intValue() >= 60) {
                this.numCountTimeout = new AtomicInteger(0);
                logger.info("=====> Start delete log file");
                DeleteLogManagerThread.deleteLogFile("logs/", 7);
            } else {
                this.numCountTimeout.incrementAndGet();
                logger.info("Increment numCountTimeOut to : " + this.numCountTimeout.intValue());
            }
        }
        catch (Exception ex) {
            logger.error("Co loi xay ra: ", ex);
        }
    }

    public static void main(String[] args) throws Exception {
        DeleteLogManagerThread.deleteLogFile("D:\\Users\\dungnv93\\Downloads\\Images\\Kiso", 2);
    }

    private static void deleteLogFile(String path, int num) throws Exception {
        File[] listLog;
        if (StringUtil.isNullOrEmpty(path).booleanValue() || num <= 0) {
            return;
        }
        Calendar today = Calendar.getInstance();
        File logFolder = new File(path);
        for (File log : listLog = logFolder.listFiles()) {
            if (!DeleteLogManagerThread.isDelete(log, today.getTimeInMillis(), num * 86400000)) continue;
            logger.info("Delete file: " + log.getAbsolutePath());
            System.out.println("Delete file: " + log.getAbsolutePath());
            log.delete();
        }
    }

    private static boolean isDelete(File file, long compareTime, long keepTime) throws Exception {
        BasicFileAttributes attribute = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        Long createTime = attribute.creationTime().toMillis();
        logger.info("Creation time : " + new Date(createTime));
        System.out.println("Creation time : " + new Date(createTime));
        return compareTime - createTime > keepTime;
    }
}

