/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.object;

import eu.europa.esig.dss.token.object.ProxyObject;
import eu.europa.esig.dss.token.object.UsbTokenObject;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;

public class ConfigObject {
    private String language;
    private int proxyType;
    private ProxyObject proxyObject;
    private int timeout;
    private boolean startupWithOs;
    private boolean savePassword;
    private ArrayList<UsbTokenObject> defaultCertList;
    public static final int NO_PROXY = 0;
    public static final int SYSTEM_PROXY = 1;
    public static final int MANUAL_PROXY = 2;
    public static final int DEFAULT_TIME_OUT = 60;
    public static final int MAX_STORE_USB_TOKEN_CERT = 20;

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public int getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(int proxyType) {
        this.proxyType = proxyType;
    }

    public ProxyObject getProxyObject() {
        return this.proxyObject;
    }

    public void setProxyObject(ProxyObject proxyObject) {
        this.proxyObject = proxyObject;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isStartupWithOs() {
        return this.startupWithOs;
    }

    public void setStartupWithOs(boolean startupWithOs) {
        this.startupWithOs = startupWithOs;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public ArrayList<UsbTokenObject> getDefaultCertList() {
        return this.defaultCertList;
    }

    public void setDefaultCertList(ArrayList<UsbTokenObject> defaultCertList) {
        this.defaultCertList = defaultCertList;
    }

    public ConfigObject() {
    }

    public ConfigObject(String language, int proxyType, ProxyObject proxyObject, int timeout, boolean startupWithOs, boolean savePassword, ArrayList<UsbTokenObject> defaultCertList) {
        this.language = language;
        this.proxyType = proxyType;
        this.proxyObject = proxyObject;
        this.timeout = timeout;
        this.startupWithOs = startupWithOs;
        this.savePassword = savePassword;
        this.defaultCertList = defaultCertList;
    }

    public static ConfigObject makeDefaultObject() {
        ConfigObject object = new ConfigObject();
        object.setLanguage("vi_VN");
        object.setProxyType(0);
        object.setProxyObject(null);
        object.setTimeout(60);
        object.setStartupWithOs(true);
        object.setSavePassword(true);
        return object;
    }

    public ConfigObject cloneObject() {
        return new ConfigObject(this.language, this.proxyType, this.proxyObject, this.timeout, this.startupWithOs, this.savePassword, this.defaultCertList);
    }

    public void removeDefaultCertToDefaultCertList(String usbSerial) throws Exception {
        if (StringUtil.isNullOrEmpty(usbSerial).booleanValue()) {
            throw new IllegalArgumentException("Input for function removeDefaultCertToDefaultCertList invalid");
        }
        if (this.defaultCertList == null || this.defaultCertList.isEmpty()) {
            return;
        }
        int size = this.defaultCertList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!usbSerial.equals(this.defaultCertList.get(i2).getUsbSerial())) continue;
            this.defaultCertList.remove(i2);
            break;
        }
    }

    public boolean setDefautCertToDefautCertList(String usbSerial, String certSerial, String certName, String certContent) throws Exception {
        if (StringUtil.isNullOrEmpty(usbSerial).booleanValue() || StringUtil.isNullOrEmpty(certSerial).booleanValue() || StringUtil.isNullOrEmpty(certName).booleanValue() || StringUtil.isNullOrEmpty(certContent).booleanValue()) {
            throw new IllegalArgumentException("Input for function setDefautCertToDefautCertList invalid");
        }
        if (this.defaultCertList == null) {
            this.setDefaultCertList(new ArrayList<UsbTokenObject>());
        }
        if (this.defaultCertList.isEmpty()) {
            this.defaultCertList.add(new UsbTokenObject(usbSerial, certSerial, certName, certContent, new Date()));
            return true;
        }
        int size = this.defaultCertList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!usbSerial.equals(this.defaultCertList.get(i2).getUsbSerial())) continue;
            this.defaultCertList.get(i2).setCertSerial(certSerial);
            this.defaultCertList.get(i2).setCertContent(certContent);
            this.defaultCertList.get(i2).setCertName(certName);
            this.defaultCertList.get(i2).setModifiedDate(new Date());
            return true;
        }
        if (this.defaultCertList.size() < 20) {
            this.defaultCertList.add(new UsbTokenObject(usbSerial, certSerial, certName, certContent, new Date()));
            return true;
        }
        int earliestObjectIndex = 0;
        int size2 = this.defaultCertList.size();
        for (int i3 = 1; i3 < size2; ++i3) {
            if (this.defaultCertList.get(i3).getModifiedDate().getTime() >= this.defaultCertList.get(earliestObjectIndex).getModifiedDate().getTime()) continue;
            earliestObjectIndex = i3;
        }
        this.defaultCertList.get(earliestObjectIndex).setUsbSerial(usbSerial);
        this.defaultCertList.get(earliestObjectIndex).setCertSerial(certSerial);
        this.defaultCertList.get(earliestObjectIndex).setCertName(certName);
        this.defaultCertList.get(earliestObjectIndex).setCertContent(certContent);
        this.defaultCertList.get(earliestObjectIndex).setModifiedDate(new Date());
        return true;
    }

    public static void main(String[] args) throws Exception {
    }
}

