/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.connection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.object.OutPutObject;
import eu.europa.esig.dss.token.object.SignObject;
import eu.europa.esig.dss.token.usb.UsbTokenBussiness;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.net.InetAddress;
import org.apache.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket
public class WebsocketHandler {
    private static Session sessionReal;
    private static String valueSign;
    private static final Logger logger;

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        logger.info("======> Start onClose  statusCode : " + statusCode);
        logger.info("======> Start onClose  reason : " + reason);
        logger.info("======>session == sessionReal 1 " + (session == sessionReal));
        try {
            if (Manager.getMainScreen() != null && session == sessionReal) {
                if (statusCode != 1000) {
                    Manager.closeToken();
                    Manager.stopAppSessionTimer();
                }
                if (!Manager.getConfigObject().isSavePassword()) {
                    Manager.closeToken();
                }
                Manager.stopSigning();
                Manager.getMainScreen().showJpanelAbout(false);
                Manager.getSystemTray().getItemShow().setState(false);
                WebsocketHandler.setSessionReal(null);
            }
        }
        catch (Exception e2) {
            logger.error("error on Close ", e2);
        }
    }

    @OnWebSocketError
    public void onError(Session session, Throwable t) {
        logger.info("======>start onError !");
        logger.info("======> session == sessionReal 2 " + (session == sessionReal));
        try {
            if (Manager.getMainScreen() != null && session == sessionReal) {
                if ("Timeout on Read".equalsIgnoreCase(t.getMessage())) {
                    if (Manager.getChooseCertTableFrame() != null) {
                        Manager.getChooseCertTableFrame().setVisible(false);
                    }
                    if (Manager.getSignFrame() != null) {
                        Manager.getSignFrame().setVisible(false);
                    }
                    CustomedComponentUtil.showMessageToUser("session.time.out", "error");
                }
                Manager.closeToken();
                Manager.stopAppSessionTimer();
                Manager.stopSigning();
                Manager.getMainScreen().showJpanelAbout(false);
                Manager.getSystemTray().getItemShow().setState(false);
                WebsocketHandler.setSessionReal(null);
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        logger.error("Have error: ", t);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        logger.info("=====>Start onConnect");
        String hostAddress = session.getRemoteAddress().getAddress().getHostAddress();
        logger.info("=====> hostAddress " + hostAddress);
    }

    public String getIpAddress() {
        try {
            InetAddress thisIp = InetAddress.getLocalHost();
            return thisIp.getHostAddress();
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            return "";
        }
    }

    @OnWebSocketMessage
    public void onMessage(Session session, String message) {
        block121: {
            if (session != null) {
                String hostAddress = session.getRemoteAddress().getAddress().getHostAddress();
                logger.info("Message: " + message);
                try {
                    int numUsbToken;
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.registerModule(new JavaTimeModule());
                    mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
                    SignObject signObject = mapper.readValue(message, SignObject.class);
                    if (!"Token".equals(signObject.getToken()) && !"insertCert".equals(signObject.getType())) break block121;
                    if ("sign".equals(signObject.getType())) {
                        String dataSign = signObject.getDataSign().trim();
                        String[] arrayDataSign = dataSign.split(" ");
                        String signCode = UsbTokenBussiness.signEinvoice(session, arrayDataSign, signObject.getSerialToCheck());
                        if (!StringUtil.isNullOrEmpty(signObject).booleanValue()) {
                            switch (signCode) {
                                case "VALUE_EMPTY": {
                                    WebsocketHandler.sendMessageToServer("VALUE_EMPTY");
                                    CustomedComponentUtil.showMessageToUser("message.value.empty.to.sign", "error");
                                    break;
                                }
                                case "EMPTY_INVOICE": {
                                    WebsocketHandler.sendMessageToServer("EMPTY_INVOICE");
                                    CustomedComponentUtil.showMessageToUser("empty.invoice.exist", "error");
                                    break;
                                }
                                case "NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN": {
                                    WebsocketHandler.sendMessageToServer("NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN");
                                    CustomedComponentUtil.showMessageToUser("cert.validation.connection.fail", "error");
                                    break;
                                }
                                case "HAVE_ERROR_WHEN_SIGING": {
                                    WebsocketHandler.sendMessageToServer("HAVE_ERROR_WHEN_SIGING");
                                    CustomedComponentUtil.showMessageToUser("have.error.when.signing", "error");
                                    break;
                                }
                                case "INVALID_CERT_TO_SIGN": {
                                    WebsocketHandler.sendMessageToServer("INVALID_CERT_TO_SIGN");
                                    CustomedComponentUtil.showMessageToUser("message.invalid.cert", "error");
                                    break;
                                }
                            }
                        }
                        break block121;
                    }
                    if ("getCert".equals(signObject.getType()) || "uploadCert".equals(signObject.getType())) {
                        int numUsbToken2;
                        if (sessionReal == null) {
                            WebsocketHandler.setSessionReal(session);
                        }
                        if ((numUsbToken2 = UsbTokenBussiness.getNumUsbTokenPlugIn()) == 0) {
                            try {
                                WebsocketHandler.sendMessageToServer(session, "NO_USB_TOKEN_TO_SIGN");
                                CustomedComponentUtil.showMessageToUser("no.usb.token.to.sign", "error");
                                logger.info("=====> No USB-TOKEN to sign");
                            }
                            catch (Exception ex) {
                                logger.error("Have error: ", ex);
                            }
                            return;
                        }
                        if (numUsbToken2 > 1) {
                            try {
                                WebsocketHandler.sendMessageToServer(session, "MORE_THAN_ONE_USB_TOKEN_TO_SIGN");
                                CustomedComponentUtil.showMessageToUser("two.usb.token.found.to.sign", "error");
                                logger.info("=====> More than one USB-TOKEN to sign");
                            }
                            catch (Exception ex) {
                                logger.error("Have error: ", ex);
                            }
                            return;
                        }
                        logger.info("=====> Start getCert");
                        Manager.getMainScreen().setVisible(false);
                        Manager.getSystemTray().getItemShow().setState(false);
                        Manager.setTask(signObject.getType());
                        Manager.startSigning();
                        if (Manager.isAppSessionTimerRunning()) {
                            Manager.getSignFrame().setWaitCursor();
                            String setupTableCode = Manager.getChooseCertTableFrame().setupChooseCertificateTable();
                            if (!StringUtil.isNullOrEmpty(setupTableCode).booleanValue()) {
                                switch (setupTableCode) {
                                    case "NO_CERT_IN_USB": {
                                        WebsocketHandler.sendMessageToServer("NO_CERT_IN_USB");
                                        CustomedComponentUtil.showMessageToUser("no.cert.in.usb.token", "error");
                                        break;
                                    }
                                    case "NO_INTERNET_CONNECTION_SETUP_TABLE": {
                                        WebsocketHandler.sendMessageToServer("NO_INTERNET_CONNECTION_SETUP_TABLE");
                                        CustomedComponentUtil.showMessageToUser("cert.validation.connection.fail", "error");
                                        break;
                                    }
                                    case "HAVE_ERROR": {
                                        CustomedComponentUtil.showMessageToUser("message.error", "error");
                                        WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                                        break;
                                    }
                                    case "SUCCESS": {
                                        Manager.getChooseCertTableFrame().setVisible(true);
                                        Manager.getChooseCertTableFrame().appearOnTop();
                                    }
                                }
                            } else {
                                WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                                CustomedComponentUtil.showMessageToUser("message.error", "error");
                            }
                            Manager.getSignFrame().resetCursor();
                        } else {
                            Manager.getSignFrame().clearJpasswordField();
                            Manager.getSignFrame().clearJtableChooseCert(null);
                            Manager.getSignFrame().showEnterPasswordPanel();
                            Manager.getSignFrame().focusToJPasswordField();
                            Manager.getSignFrame().appearOnTop();
                            if (!Manager.getConfigObject().isSavePassword()) {
                                Manager.closeToken();
                            }
                            Manager.startSigning();
                        }
                        break block121;
                    }
                    if ("finish".equals(signObject.getType())) {
                        logger.info("Check session equal sessionReal: " + (session == sessionReal));
                        if (sessionReal != null && sessionReal.isOpen()) {
                            sessionReal.close();
                        }
                        WebsocketHandler.setSessionReal(null);
                        if (!Manager.getConfigObject().isSavePassword()) {
                            Manager.closeToken();
                        }
                        if (null != signObject.getMessageCode()) {
                            switch (signObject.getMessageCode()) {
                                case "SIGN_SUCCESS": {
                                    break;
                                }
                                case "SIGN_ERROR": {
                                    CustomedComponentUtil.showMessageToUser("sign.invoice.fail", "error");
                                    break;
                                }
                                case "UPLOAD_CERT_SUCCESS": {
                                    CustomedComponentUtil.showMessageToUser("upload.cert.success", "info");
                                    break;
                                }
                                case "UPLOAD_CERT_ERROR": {
                                    CustomedComponentUtil.showMessageToUser("upload.certificate.fail", "error");
                                    break;
                                }
                                case "EMPTY_UPLOADED_CERT": {
                                    CustomedComponentUtil.showMessageToUser("upload.cert.usb.empty", "error");
                                    break;
                                }
                                case "EMPTY_TRANSFERED_CERT": {
                                    CustomedComponentUtil.showMessageToUser("transfered.cert.usb.empty", "error");
                                    break;
                                }
                                case "CERT_NOT_REGISTER": {
                                    CustomedComponentUtil.showMessageToUser("create.invoice.usb.token.cert.not.registered", "error");
                                    break;
                                }
                                case "CERT_INFO_NOT_FOUND": {
                                    CustomedComponentUtil.showMessageToUser("create.invoice.usb.token.cert.info.not.found", "error");
                                    break;
                                }
                                case "INVALID_CERT": {
                                    CustomedComponentUtil.showMessageToUser("create.invoice.usb.token.invalid.certificate", "error");
                                    break;
                                }
                                case "CERT_NOT_MATCH": {
                                    CustomedComponentUtil.showMessageToUser("create.invoice.usb.token.cert.not.match", "error");
                                    break;
                                }
                                case "INVOICE_PROCESSING": {
                                    CustomedComponentUtil.showMessageToUser("invoice.processing", "error");
                                    break;
                                }
                                default: {
                                    CustomedComponentUtil.showMessageToUser("message.error", "error");
                                    break;
                                }
                            }
                        } else {
                            CustomedComponentUtil.showMessageToUser("message.error", "error");
                        }
                        Manager.getChooseCertTableFrame().setVisible(false);
                        Manager.getSignFrame().setVisible(false);
                        break block121;
                    }
                    if ("signInvoices".equals(signObject.getType())) {
                        String signCode = UsbTokenBussiness.signEinvoices(session, signObject, signObject.getSerialToCheck());
                        if (!StringUtil.isNullOrEmpty(signObject).booleanValue()) {
                            switch (signCode) {
                                case "VALUE_EMPTY": {
                                    WebsocketHandler.sendMessageToServer("VALUE_EMPTY");
                                    CustomedComponentUtil.showMessageToUser("message.value.empty.to.sign", "error");
                                    break;
                                }
                                case "EMPTY_INVOICE": {
                                    WebsocketHandler.sendMessageToServer("EMPTY_INVOICE");
                                    CustomedComponentUtil.showMessageToUser("empty.invoice.exist", "error");
                                    break;
                                }
                                case "NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN": {
                                    WebsocketHandler.sendMessageToServer("NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN");
                                    CustomedComponentUtil.showMessageToUser("cert.validation.connection.fail", "error");
                                    break;
                                }
                                case "HAVE_ERROR_WHEN_SIGING": {
                                    WebsocketHandler.sendMessageToServer("HAVE_ERROR_WHEN_SIGING");
                                    CustomedComponentUtil.showMessageToUser("have.error.when.signing", "error");
                                    break;
                                }
                                case "INVALID_CERT_TO_SIGN": {
                                    WebsocketHandler.sendMessageToServer("INVALID_CERT_TO_SIGN");
                                    CustomedComponentUtil.showMessageToUser("message.invalid.cert", "error");
                                    break;
                                }
                                case "INVALID_INVOICE_USER": {
                                    WebsocketHandler.sendMessageToServer("INVALID_INVOICE_USER");
                                    break;
                                }
                            }
                        }
                        break block121;
                    }
                    if (!"insertCert".equals(signObject.getType())) break block121;
                    if (sessionReal == null) {
                        WebsocketHandler.setSessionReal(session);
                    }
                    if ((numUsbToken = UsbTokenBussiness.getNumUsbTokenPlugIn()) == 0) {
                        try {
                            WebsocketHandler.sendMessageToServer(session, "NO_USB_TOKEN_TO_SIGN");
                            CustomedComponentUtil.showMessageToUser("no.usb.token.to.sign", "error");
                            logger.info("=====> No USB-TOKEN to sign");
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                        }
                        return;
                    }
                    if (numUsbToken > 1) {
                        try {
                            WebsocketHandler.sendMessageToServer(session, "MORE_THAN_ONE_USB_TOKEN_TO_SIGN");
                            CustomedComponentUtil.showMessageToUser("two.usb.token.found.to.sign", "error");
                            logger.info("=====> More than one USB-TOKEN to sign");
                        }
                        catch (Exception ex) {
                            logger.error("Have error: ", ex);
                        }
                        return;
                    }
                    logger.info("=====> Start insertCert");
                    Manager.getMainScreen().setVisible(false);
                    Manager.getSystemTray().getItemShow().setState(false);
                    Manager.setTask(signObject.getType());
                    if (Manager.isAppSessionTimerRunning()) {
                        Manager.getSignFrame().setWaitCursor();
                        String setupTableCode = Manager.getChooseCertTableFrame().setupChooseCertificateTable(signObject.getTaxCode());
                        if (!StringUtil.isNullOrEmpty(setupTableCode).booleanValue()) {
                            switch (setupTableCode) {
                                case "NO_CERTIFICATE_WITH_TAX": {
                                    WebsocketHandler.sendMessageToServer("NO_CERTIFICATE_WITH_TAX");
                                    break;
                                }
                                case "NO_CERT_IN_USB": {
                                    WebsocketHandler.sendMessageToServer("NO_CERT_IN_USB");
                                    CustomedComponentUtil.showMessageToUser("no.cert.in.usb.token", "error");
                                    break;
                                }
                                case "NO_INTERNET_CONNECTION_SETUP_TABLE": {
                                    WebsocketHandler.sendMessageToServer("NO_INTERNET_CONNECTION_SETUP_TABLE");
                                    CustomedComponentUtil.showMessageToUser("cert.validation.connection.fail", "error");
                                    break;
                                }
                                case "HAVE_ERROR": {
                                    CustomedComponentUtil.showMessageToUser("message.error", "error");
                                    WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                                    break;
                                }
                                case "SUCCESS": {
                                    Manager.getChooseCertTableFrame().setVisible(true);
                                    Manager.getChooseCertTableFrame().appearOnTop();
                                }
                            }
                        } else {
                            WebsocketHandler.sendMessageToServer("HAVE_ERROR");
                            CustomedComponentUtil.showMessageToUser("message.error", "error");
                        }
                        Manager.getSignFrame().resetCursor();
                    } else {
                        Manager.getSignFrame().clearJpasswordField();
                        Manager.getSignFrame().clearJtableChooseCert(signObject.getTaxCode());
                        Manager.getSignFrame().showEnterPasswordPanel();
                        Manager.getSignFrame().focusToJPasswordField();
                        Manager.getSignFrame().appearOnTop();
                        if (!Manager.getConfigObject().isSavePassword()) {
                            Manager.closeToken();
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error("Have error: ", ex);
                }
            }
        }
    }

    public static void sendMessageToServer(String code) throws Exception {
        logger.info("=====> start sendMessageToServer code: " + code);
        if (WebsocketHandler.getSessionReal() != null && WebsocketHandler.getSessionReal().isOpen()) {
            OutPutObject outputResponse = new OutPutObject();
            outputResponse.setMessageCode(code);
            switch (code) {
                case "VALUE_EMPTY": {
                    outputResponse.setContent(StringUtil.getText("message.value.empty.to.sign"));
                    break;
                }
                case "EMPTY_INVOICE": {
                    outputResponse.setContent(StringUtil.getText("empty.invoice.exist"));
                    break;
                }
                case "NO_INTERNET_CONNECTION_TO_VALIDATE_CERT_TO_SIGN": {
                    outputResponse.setContent(StringUtil.getText("cert.validation.connection.fail"));
                    break;
                }
                case "HAVE_ERROR_WHEN_SIGING": {
                    outputResponse.setContent(StringUtil.getText("have.error.when.signing"));
                    break;
                }
                case "INVALID_CERT_TO_SIGN": {
                    outputResponse.setContent(StringUtil.getText("message.invalid.cert"));
                    break;
                }
                case "INVALID_INVOICE_USER": {
                    outputResponse.setContent(StringUtil.getText("message.invalid.auth.invoice.user"));
                    break;
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            String output = mapper.writeValueAsString(outputResponse);
            WebsocketHandler.getSessionReal().getRemote().sendString(output);
            WebsocketHandler.getSessionReal().close();
        }
    }

    public static void sendEmptyTextToServer() {
        try {
            logger.info("=====> start sendEmptyTextToServer");
            WebsocketHandler.sendMessageToServer("");
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    public static void sendSessionTimeOutToServer() {
        try {
            logger.info("=====> start sendSessionTimeOutToServer");
            if (WebsocketHandler.getSessionReal() != null && WebsocketHandler.getSessionReal().isOpen()) {
                WebsocketHandler.sendMessageToServer("SESSION_TIME_OUT");
                logger.info("=====> start sendSessionTimeOutToServer sessionReal" + WebsocketHandler.getSessionReal());
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    public static void sendMessageToServer(Session session, String code) throws Exception {
        logger.info("=====> start sendMessageToServer code: " + code);
        if (session != null && session.isOpen()) {
            OutPutObject outputResponse = new OutPutObject();
            outputResponse.setMessageCode(code);
            ObjectMapper mapper = new ObjectMapper();
            String output = mapper.writeValueAsString(outputResponse);
            session.getRemote().sendString(output);
            session.close();
        }
    }

    public static Session getSessionReal() {
        return sessionReal;
    }

    public static synchronized void setSessionReal(Session sessionReal) {
        try {
            if (sessionReal == null && WebsocketHandler.sessionReal != null) {
                WebsocketHandler.sessionReal.close();
            }
        }
        catch (Exception ex) {
            logger.info("Have error", ex);
        }
        WebsocketHandler.sessionReal = sessionReal;
    }

    public static String getValueSign() {
        return valueSign;
    }

    public static void setValueSign(String valueSign) {
        WebsocketHandler.valueSign = valueSign;
    }

    static {
        logger = Logger.getLogger(WebsocketHandler.class.getName());
    }
}

