/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.connection;

import com.google.gson.Gson;
import com.viettel.security.PassTranformer;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.Pkcs11SignatureToken;
import eu.europa.esig.dss.token.connection.JavaSocketConnection;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import eu.europa.esig.dss.token.object.ConfigObject;
import eu.europa.esig.dss.token.thread.DeleteLogManagerThread;
import eu.europa.esig.dss.token.thread.SessionManagerThread;
import eu.europa.esig.dss.token.thread.UsbTokenPlugedInSessionManager;
import eu.europa.esig.dss.token.utils.CustomedComponentUtil;
import eu.europa.esig.dss.token.utils.StringUtil;
import eu.europa.esig.dss.token.utils.UpdateService;
import eu.europa.esig.dss.token.view.ChooseCertificateTableFrame;
import eu.europa.esig.dss.token.view.MainJFrame;
import eu.europa.esig.dss.token.view.SignFrame;
import eu.europa.esig.dss.token.view.SystemTray;
import eu.europa.esig.dss.token.view.ViewInvoiceFrame;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.util.MultiException;

public class Manager {
    private static MainJFrame mainScreen;
    private static ViewInvoiceFrame viewInvoiceFrame;
    private static SignFrame signFrame;
    private static final SystemTray systemTray;
    private static JavaSocketConnection javaSocketConnection;
    private static ChooseCertificateTableFrame chooseCertTableFrame;
    private static ConfigObject configObject;
    private static String securityKey;
    private static boolean isSigning;
    private static int numUsbToken;
    private static String usbSerial;
    private static String usbTokenPassword;
    private static boolean appSessionRunningFlag;
    private static Timer appSessiontimer;
    private static Timer usbUnplugTimer;
    private static Timer deleteLogTimer;
    private static List<DSSPrivateKeyEntry> listSignPrivateKeys;
    private static Pkcs11SignatureToken token;
    private static String defaultCertSerial;
    private static String defaultCertContent;
    private static String defaultCertName;
    private static String task;
    private static final Logger logger;

    public static void main(String[] args) throws Exception {
        try {
            systemTray.createSystemTray();
            Manager.createUnzipDir();
            try {
                for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                    if (!"Windows".equals(info.getName())) continue;
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                logger.error("Have error: ", ex);
            }
            Manager.createMainFrame();
            Manager.createSignFrame();
            Manager.createChooseCertificateTableFrame();
            Manager.startUsbTokenPlugInSession();
            Manager.startDeleteLogFileSession();
            System.setProperty("java.net.useSystemProxies", "true");
            try {
                logger.info("================================APP VERSION=====================================");
                logger.info("===================================1.0.1========================================");
                logger.info("================================================================================");
                UpdateService updateService = new UpdateService();
                if (updateService.checkVersion()) {
                    logger.info("=====> auto update");
                    if (updateService.downloadUpdate()) {
                        logger.info("=====> download update success");
                        Runtime.getRuntime().exec("update.bat");
                        logger.info("=======================update.bat=======================: ");
                        System.exit(0);
                    }
                }
            }
            catch (Exception ex) {
                logger.error("=======================Update fail=======================: " + ex.getMessage(), ex);
            }
            javaSocketConnection.createConnection();
        }
        catch (BindException | MultiException e2) {
            logger.error("Have error ", e2);
            mainScreen.showMessageToUser("app.is.running", "error");
            System.exit(2);
        }
        catch (Exception e3) {
            logger.error("Have error: ", e3);
            mainScreen.showMessageToUser("message.error", "error");
            System.exit(3);
        }
    }

    public static int getConfigFile() {
        try {
            String configContent;
            String configFilePath;
            File configFile;
            String appDataFolderPath = System.getenv("APPDATA");
            String homeFolderPath = appDataFolderPath + "\\" + "713d7e3f12b9eecfbb26bc9d825sfsgfsfsdlozkecmkdoojl098";
            logger.info("=====> homeFolder: " + homeFolderPath);
            File homeDir = new File(homeFolderPath);
            if (!homeDir.exists()) {
                File appDataDir = new File(appDataFolderPath);
                if (!appDataDir.canWrite()) {
                    return -2;
                }
                homeDir.mkdir();
                Manager.hideFile(homeDir);
            }
            if ((configFile = new File(configFilePath = homeFolderPath + "\\" + "c3640649cd6bb07c13199b8381f611d4a61f14a9a10a2b5a624d" + ".txt")).exists()) {
                if (!configFile.canRead()) {
                    return -3;
                }
                List<String> listString = Files.readAllLines(configFile.toPath(), StandardCharsets.UTF_8);
                configContent = "";
                for (String line : listString) {
                    configContent = configContent + line;
                }
            } else {
                if (!homeDir.canWrite()) {
                    return -4;
                }
                Manager.setConfigObject(ConfigObject.makeDefaultObject());
                Manager.saveConfig(configObject, configFilePath);
                return 1;
            }
            String decryptedJsonObject = Manager.viettelDecrypt(configContent);
            Gson gson = new Gson();
            Manager.setConfigObject(gson.fromJson(decryptedJsonObject, ConfigObject.class));
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
        return -1;
    }

    private static void createMainFrame() {
        Manager.setMainScreen(new MainJFrame());
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Manager.getMainScreen().setLocation(dim.width / 2 - Manager.getMainScreen().getSize().width / 2, dim.height / 2 - Manager.getMainScreen().getSize().height / 2);
        Manager.getMainScreen().setVisible(true);
        Manager.getMainScreen().setAlwaysOnTop(false);
        Manager.getMainScreen().toFront();
        Manager.getMainScreen().setDefaultCloseOperation(0);
        Manager.getMainScreen().appearOnTop();
        Manager.getMainScreen().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                if (Manager.getMainScreen().getjPanelChooseCert().isVisible() || Manager.getMainScreen().isSigning() && Manager.getMainScreen().getjPanelPassword().isVisible()) {
                    try {
                        int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), "getCert".equals(Manager.getTask()) ? StringUtil.getText("ask.cancel.signing") : StringUtil.getText("ask.cancel.upload.cert"));
                        if (option == 1) {
                            return;
                        }
                        if (!Manager.getConfigObject().isSavePassword()) {
                            Manager.closeToken();
                        }
                        WebsocketHandler.sendMessageToServer("FORCE_CLOSE");
                        Manager.stopSigning();
                        WebsocketHandler.setSessionReal(null);
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                    }
                }
                Manager.getMainScreen().showJpanelAbout(false);
                Manager.getMainScreen().setVisible(false);
                Manager.getSystemTray().getItemShow().setSelected(false);
            }
        });
    }

    private static void createSignFrame() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Manager.setSignFrame(new SignFrame());
        Manager.getSignFrame().setVisible(false);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Manager.getSignFrame().setSize(new Dimension(Manager.getSignFrame().getSize().width, Manager.getSignFrame().getSize().height < rectangle.height ? Manager.getSignFrame().getSize().height : rectangle.height));
        Manager.getSignFrame().setLocation(dim.width / 2 - Manager.getSignFrame().getSize().width / 2, dim.height / 2 - Manager.getSignFrame().getSize().height / 2);
        Manager.getSignFrame().setAlwaysOnTop(false);
        Manager.getSignFrame().toFront();
        Manager.getSignFrame().setDefaultCloseOperation(0);
        Manager.getSignFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                super.windowClosing(e2);
                if (Manager.getSignFrame().isSigning()) {
                    try {
                        int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), "getCert".equals(Manager.getTask()) ? StringUtil.getText("ask.cancel.signing") : StringUtil.getText("ask.cancel.upload.cert"));
                        if (option == 1) {
                            return;
                        }
                        if (!Manager.getConfigObject().isSavePassword()) {
                            Manager.closeToken();
                        }
                        WebsocketHandler.sendMessageToServer("FORCE_CLOSE");
                        Manager.stopSigning();
                        WebsocketHandler.setSessionReal(null);
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                    }
                }
                Manager.getSignFrame().setVisible(false);
            }
        });
        logger.info("=====> create SignFrame");
    }

    private static void createChooseCertificateTableFrame() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Manager.setChooseCertTableFrame(new ChooseCertificateTableFrame());
        Manager.getChooseCertTableFrame().setVisible(false);
        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Manager.getChooseCertTableFrame().setSize(new Dimension(Manager.getChooseCertTableFrame().getSize().width, Manager.getChooseCertTableFrame().getSize().height < rectangle.height ? Manager.getChooseCertTableFrame().getSize().height : rectangle.height));
        Manager.getChooseCertTableFrame().setLocation(dim.width / 2 - Manager.getChooseCertTableFrame().getSize().width / 2, dim.height / 2 - Manager.getChooseCertTableFrame().getSize().height / 2);
        Manager.getChooseCertTableFrame().setAlwaysOnTop(false);
        Manager.getChooseCertTableFrame().toFront();
        Manager.getChooseCertTableFrame().setDefaultCloseOperation(0);
        Manager.getChooseCertTableFrame().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                super.windowClosing(e2);
                if (Manager.getChooseCertTableFrame().isSigning()) {
                    try {
                        int option = CustomedComponentUtil.showOptionToUser(StringUtil.getText("confirm"), "getCert".equals(Manager.getTask()) ? StringUtil.getText("ask.cancel.signing") : StringUtil.getText("ask.cancel.upload.cert"));
                        if (option == 1) {
                            return;
                        }
                        if (!Manager.getConfigObject().isSavePassword()) {
                            Manager.closeToken();
                        }
                        WebsocketHandler.sendMessageToServer("FORCE_CLOSE");
                        Manager.stopSigning();
                        WebsocketHandler.setSessionReal(null);
                    }
                    catch (Exception ex) {
                        logger.error("Have error: ", ex);
                    }
                }
                Manager.getChooseCertTableFrame().setVisible(false);
            }
        });
        logger.info("=====> create SignFrame");
    }

    public static void hideFile(File src) throws Exception {
        Files.setAttribute(src.toPath(), "dos:hidden", true, new LinkOption[0]);
    }

    public static void saveConfig(ConfigObject configObject, String configFilePath) throws Exception {
        Gson gson = new Gson();
        ConfigObject tempConfig = configObject.cloneObject();
        String jsonObject = gson.toJson(tempConfig);
        String encryptedJsonObject = Manager.viettelEncrypt(jsonObject);
        logger.info("=====> EncrypteJsonObject " + encryptedJsonObject);
        StringUtil.writeContentFromFile(encryptedJsonObject, configFilePath);
    }

    public static String viettelEncrypt(String data) throws Exception {
        PassTranformer.setInputKey(securityKey);
        return PassTranformer.encrypt(data);
    }

    public static String viettelDecrypt(String data) throws Exception {
        PassTranformer.setInputKey(securityKey);
        return PassTranformer.decrypt(data);
    }

    private static String viettelEncryptDefault(String data) throws Exception {
        return PassTranformer.encrypt(data);
    }

    private static String viettelDecryptDefault(String data) throws Exception {
        return PassTranformer.decrypt(data);
    }

    public static boolean isDefaultCertExist() {
        return StringUtil.isNullOrEmpty(Manager.getDefaultCertSerial()) == false && StringUtil.isNullOrEmpty(Manager.getDefaultCertContent()) == false && StringUtil.isNullOrEmpty(Manager.getDefaultCertName()) == false;
    }

    private static void createUnzipDir() {
        File unzipFile = new File(System.getenv("temp") + "\\" + "kdfjdjfznfl2384sdknzxlziofrhskhcmnxhsurymglgo9746hfed");
        if (!unzipFile.exists()) {
            unzipFile.mkdirs();
        }
    }

    public static void startSigning() {
        Manager.setIsSigning(true);
    }

    public static void stopSigning() {
        Manager.setIsSigning(false);
    }

    public static final synchronized void startAppSessionTimer() {
        appSessiontimer = new Timer();
        SessionManagerThread deleter = new SessionManagerThread();
        appSessiontimer.scheduleAtFixedRate((TimerTask)deleter, 0L, 60000L);
        Manager.setAppSessionRunningFlag(true);
    }

    public static final void stopAppSessionTimer() {
        try {
            if (Manager.isAppSessionTimerRunning()) {
                appSessiontimer.cancel();
                Manager.setAppSessionRunningFlag(false);
                Runtime rt = Runtime.getRuntime();
                rt.exec("taskkill /F /IM rundll32.exe");
            }
        }
        catch (IOException ex) {
            logger.error("Have error: ", ex);
        }
    }

    public static final synchronized void startUsbTokenPlugInSession() {
        usbUnplugTimer = new Timer();
        UsbTokenPlugedInSessionManager deleter = new UsbTokenPlugedInSessionManager();
        usbUnplugTimer.scheduleAtFixedRate((TimerTask)deleter, 0L, 1000L);
    }

    public static final synchronized void startDeleteLogFileSession() {
        deleteLogTimer = new Timer();
        DeleteLogManagerThread deleter = new DeleteLogManagerThread();
        deleteLogTimer.scheduleAtFixedRate((TimerTask)deleter, 0L, 60000L);
    }

    public static final void stopUsbTokenPlugInSession() {
        usbUnplugTimer.cancel();
    }

    public static boolean isAppSessionTimerRunning() {
        return Manager.isAppSessionRunningFlag();
    }

    public static void clearUsbSerial() {
        Manager.setUsbSerial("");
    }

    public static void closeToken() {
        if (Manager.getToken() != null) {
            Manager.getToken().close();
        }
        Manager.setUsbTokenPassword("");
        Manager.getListSignPrivateKeys().clear();
    }

    public static void setProxyToVMBackup2() {
        try {
            int proxyType = configObject.getProxyType();
            switch (proxyType) {
                case 0: {
                    System.clearProperty("http.proxyHost");
                    System.clearProperty("http.proxyPort");
                    break;
                }
                case 1: {
                    System.setProperty("java.net.useSystemProxies", "true");
                    List<Proxy> listProxy = ProxySelector.getDefault().select(new URI("https://www.google.com/"));
                    Proxy proxy = listProxy.get(0);
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    if (address == null) {
                        System.clearProperty("http.proxyHost");
                        System.clearProperty("http.proxyPort");
                        break;
                    }
                    System.setProperty("http.proxyHost", address.getHostName());
                    System.setProperty("http.proxyPort", String.valueOf(address.getPort()));
                    logger.info("=====> proxy hostname: " + address.getHostName());
                    logger.info("=====> proxy port: " + address.getPort());
                    break;
                }
                case 2: {
                    System.setProperty("http.proxyHost", configObject.getProxyObject().getAddress());
                    System.setProperty("http.proxyPort", String.valueOf(configObject.getProxyObject().getPort()));
                    if (!StringUtil.isNullOrEmpty(configObject.getProxyObject().getUsername()).booleanValue()) {
                        System.setProperty("http.proxyUser", configObject.getProxyObject().getUsername());
                    }
                    if (!StringUtil.isNullOrEmpty(configObject.getProxyObject().getPassword()).booleanValue()) {
                        System.setProperty("http.proxyPassword", configObject.getProxyObject().getPassword());
                    }
                    logger.info("=====> proxy address :" + configObject.getProxyObject().getAddress());
                    logger.info("=====> proxy port :" + configObject.getProxyObject().getPort());
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    public static void setProxyToVMBackup() {
        try {
            int proxyType = configObject.getProxyType();
            switch (proxyType) {
                case 0: {
                    System.getProperties().put("proxySet", "false");
                    System.getProperties().put("proxyHost", "");
                    System.getProperties().put("proxyPort", "");
                    break;
                }
                case 1: {
                    System.setProperty("java.net.useSystemProxies", "true");
                    List<Proxy> listProxy = ProxySelector.getDefault().select(new URI("https://www.google.com/"));
                    Proxy proxy = listProxy.get(0);
                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                    if (address == null) {
                        System.getProperties().put("proxySet", "false");
                        System.getProperties().put("proxyHost", "");
                        System.getProperties().put("proxyPort", "");
                        break;
                    }
                    System.getProperties().put("proxySet", "true");
                    System.getProperties().put("proxyHost", address.getHostName());
                    System.getProperties().put("proxyPort", String.valueOf(address.getPort()));
                    logger.info("proxy hostname : " + address.getHostName());
                    logger.info("proxy port : " + address.getPort());
                    break;
                }
                case 2: {
                    System.getProperties().put("proxySet", "true");
                    System.getProperties().put("proxyHost", configObject.getProxyObject().getAddress());
                    System.getProperties().put("proxyPort", String.valueOf(configObject.getProxyObject().getPort()));
                    logger.info("proxy hostname : " + configObject.getProxyObject().getAddress());
                    logger.info("proxy port : " + configObject.getProxyObject().getPort());
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.error("Have error: ", ex);
        }
    }

    public static MainJFrame getMainScreen() {
        return mainScreen;
    }

    public static synchronized void setMainScreen(MainJFrame mainScreen) {
        Manager.mainScreen = mainScreen;
    }

    public static ViewInvoiceFrame getViewInvoiceFrame() {
        return viewInvoiceFrame;
    }

    public static synchronized void setViewInvoiceFrame(ViewInvoiceFrame viewInvoiceFrame) {
        Manager.viewInvoiceFrame = viewInvoiceFrame;
    }

    public static ConfigObject getConfigObject() {
        return configObject;
    }

    public static synchronized void setConfigObject(ConfigObject configObject) {
        Manager.configObject = configObject;
    }

    public static String getSecurityKey() {
        return securityKey;
    }

    public static synchronized void setSecurityKey(String securityKey) {
        Manager.securityKey = securityKey;
    }

    public static boolean isIsSigning() {
        return isSigning;
    }

    public static synchronized void setIsSigning(boolean isSigning) {
        Manager.isSigning = isSigning;
    }

    public static int getNumUsbToken() {
        return numUsbToken;
    }

    public static synchronized void setNumUsbToken(int numUsbToken) {
        Manager.numUsbToken = numUsbToken;
    }

    public static synchronized String getUsbSerial() {
        return usbSerial;
    }

    public static synchronized void setUsbSerial(String usbSerial) {
        Manager.usbSerial = usbSerial;
    }

    public static synchronized boolean isAppSessionRunningFlag() {
        return appSessionRunningFlag;
    }

    public static synchronized void setAppSessionRunningFlag(boolean appSessionRunningFlag) {
        Manager.appSessionRunningFlag = appSessionRunningFlag;
    }

    public static synchronized String getDefaultCertSerial() {
        return defaultCertSerial;
    }

    public static synchronized void setDefaultCertSerial(String defaultCertSerial) {
        Manager.defaultCertSerial = defaultCertSerial;
    }

    public static synchronized String getDefaultCertContent() {
        return defaultCertContent;
    }

    public static synchronized void setDefaultCertContent(String defaultCertContent) {
        Manager.defaultCertContent = defaultCertContent;
    }

    public static synchronized String getDefaultCertName() {
        return defaultCertName;
    }

    public static synchronized void setDefaultCertName(String defaultCertName) {
        Manager.defaultCertName = defaultCertName;
    }

    public static synchronized String getUsbTokenPassword() {
        return usbTokenPassword;
    }

    public static synchronized void setUsbTokenPassword(String usbTokenPassword) {
        Manager.usbTokenPassword = usbTokenPassword;
    }

    public static synchronized List<DSSPrivateKeyEntry> getListSignPrivateKeys() {
        return listSignPrivateKeys;
    }

    public static synchronized void setListSignPrivateKeys(List<DSSPrivateKeyEntry> listSignPrivateKeys) {
        Manager.listSignPrivateKeys = listSignPrivateKeys;
    }

    public static synchronized Pkcs11SignatureToken getToken() {
        return token;
    }

    public static synchronized void setToken(Pkcs11SignatureToken token) {
        Manager.token = token;
    }

    public static synchronized SignFrame getSignFrame() {
        return signFrame;
    }

    public static synchronized void setSignFrame(SignFrame signFrame) {
        Manager.signFrame = signFrame;
    }

    public static synchronized ChooseCertificateTableFrame getChooseCertTableFrame() {
        return chooseCertTableFrame;
    }

    public static synchronized void setChooseCertTableFrame(ChooseCertificateTableFrame chooseCertTableFrame) {
        Manager.chooseCertTableFrame = chooseCertTableFrame;
    }

    public static synchronized SystemTray getSystemTray() {
        return systemTray;
    }

    public static synchronized String getTask() {
        return task;
    }

    public static synchronized void setTask(String task) {
        Manager.task = task;
    }

    public static synchronized JavaSocketConnection getJavaSocketConnection() {
        return javaSocketConnection;
    }

    static {
        systemTray = new SystemTray();
        logger = Logger.getLogger(Manager.class.getName());
        try {
            securityKey = Manager.viettelDecryptDefault("89bc4bccf1deb91299853168ef550728");
            Manager.getConfigFile();
            javaSocketConnection = new JavaSocketConnection();
            listSignPrivateKeys = new ArrayList<DSSPrivateKeyEntry>();
            appSessiontimer = new Timer();
            usbUnplugTimer = new Timer();
            URL log4jConfPath = Manager.class.getResource("/Config/log4j.properties");
            PropertyConfigurator.configure(log4jConfPath);
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            System.exit(-1);
        }
    }
}

