/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.connection;

import eu.europa.esig.dss.token.connection.Manager;
import eu.europa.esig.dss.token.connection.WebsocketHandler;
import java.net.BindException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class JavaSocketConnection {
    private Server server;
    private static String jksFilePassword;
    private static final Logger logger;

    public void createConnection() throws BindException, MultiException, Exception {
        this.server = new Server();
        this.initServer(this.server);
        WebSocketHandler wsHandler = new WebSocketHandler(){

            @Override
            public void configure(WebSocketServletFactory factory) {
                factory.getPolicy().setIdleTimeout(300000L);
                factory.register(WebsocketHandler.class);
            }
        };
        this.server.setHandler(wsHandler);
        this.server.setStopAtShutdown(true);
        this.server.start();
        this.server.join();
    }

    private void initServer(Server server) throws Exception {
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(8006);
        http_config.setOutputBufferSize(32768);
        http_config.setRequestHeaderSize(8192);
        http_config.setResponseHeaderSize(8192);
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(Manager.class.getResource("/Keystore/einvoiceclient.jks").toString());
        sslContextFactory.setKeyStorePassword(jksFilePassword);
        sslContextFactory.setNeedClientAuth(false);
        ServerConnector wsConnector = new ServerConnector(server);
        wsConnector.setHost("localhost");
        wsConnector.setPort(8007);
        server.addConnector(wsConnector);
        ServerConnector wssConnector = new ServerConnector(server, new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config));
        wssConnector.setHost("localhost");
        wssConnector.setPort(8006);
        server.addConnector(wssConnector);
    }

    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.join();
        }
    }

    static {
        logger = Logger.getLogger(JavaSocketConnection.class.getName());
        try {
            jksFilePassword = Manager.viettelDecrypt("3e58cb78b2275e1bc00dd04acecb5a8701a07fb9fd85000d0b50fc73886ad668");
        }
        catch (Exception e2) {
            logger.error("Error: ", e2);
            System.exit(-1);
        }
    }
}

