/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token.connection;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.europa.esig.dss.token.connection.ProxyConfig;
import java.net.Proxy;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class ApiClient {
    final Logger log = Logger.getLogger(this.getClass());

    private SimpleClientHttpRequestFactory disableSSlHttpClient() throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        Proxy proxy = ProxyConfig.getProxy();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        if (proxy != null && !"DIRECT".equals(proxy.toString())) {
            factory.setProxy(proxy);
        }
        return factory;
    }

    public Object postDataInvoice(String url, String vInvoiceToken, Object bodyObject, Class<?> objectClass) throws Exception {
        try {
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.setRequestFactory(this.disableSSlHttpClient());
            HttpEntity<Object> request = this.generatePostRequest(vInvoiceToken, bodyObject);
            ResponseEntity<Object> response = restTemplate.postForEntity(url, request, Object.class, new Object[0]);
            return this.convertData(response, objectClass);
        }
        catch (Exception ex) {
            this.log.error("Error postDataInvoice: " + ex.getMessage(), ex);
            this.log.error("Error postDataInvoice: " + url);
            throw ex;
        }
    }

    public Object getDataInvoice(String url, String vInvoiceToken, Object bodyObject, Class<?> objectClass) throws Exception {
        try {
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.setRequestFactory(this.disableSSlHttpClient());
            HttpEntity<Object> request = this.generatePostRequest(vInvoiceToken, bodyObject);
            ResponseEntity<Object> response = restTemplate.exchange(url, HttpMethod.GET, request, Object.class, new Object[0]);
            return this.convertData(response, objectClass);
        }
        catch (Exception ex) {
            this.log.error("Error postDataInvoice: " + ex.getMessage(), ex);
            this.log.error("Error postDataInvoice: " + url);
            throw ex;
        }
    }

    public Object getDataInvoice(String url, String vInvoiceToken, Object bodyObject, TypeReference<?> valueTypeRef) throws Exception {
        try {
            RestTemplate restTemplate = new RestTemplate();
            restTemplate.setRequestFactory(this.disableSSlHttpClient());
            HttpEntity<Object> request = this.generatePostRequest(vInvoiceToken, bodyObject);
            ResponseEntity<Object> response = restTemplate.exchange(url, HttpMethod.GET, request, Object.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                Gson gson = new GsonBuilder().create();
                String json = gson.toJson(((Map)response.getBody()).get("data"));
                ObjectMapper mapper = new ObjectMapper();
                mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
                JavaTimeModule module = new JavaTimeModule();
                mapper.registerModule(module);
                return mapper.readValue(json, valueTypeRef);
            }
            return null;
        }
        catch (Exception ex) {
            this.log.error("Error postDataInvoice: " + ex.getMessage(), ex);
            this.log.error("Error postDataInvoice: " + url);
            throw ex;
        }
    }

    public HttpEntity<Object> generatePostRequest(String vInvoiceToken, Object request) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/json");
        headers.add("Accept", "*/*");
        headers.add("X-USB-PLUGIN", "OK");
        if (vInvoiceToken == null || vInvoiceToken.isEmpty()) {
            return new HttpEntity<Object>(request, headers);
        }
        String token = "Basic " + vInvoiceToken;
        headers.add("Authorization", token);
        return new HttpEntity<Object>(request, headers);
    }

    private Object convertData(ResponseEntity<?> response, Object objectClass) throws Exception {
        if (response.getStatusCode() == HttpStatus.OK || response.getStatusCode() == HttpStatus.CREATED) {
            Gson gson = new GsonBuilder().create();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            JavaTimeModule module = new JavaTimeModule();
            mapper.registerModule(module);
            try {
                String json = gson.toJson(((Map)response.getBody()).get("data"));
                return mapper.readValue(json, (Class)objectClass);
            }
            catch (Exception ex) {
                this.log.error("Error convertData: " + ex.getMessage(), ex);
                try {
                    String json = gson.toJson(((Map)response.getBody()).get("data"));
                    return mapper.readValue(json, (TypeReference)objectClass);
                }
                catch (Exception ex1) {
                    this.log.error("Error convertData: " + ex1.getMessage(), ex1);
                    return null;
                }
            }
        }
        return null;
    }
}

