/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.BadPaddingException;
import org.apache.log4j.Logger;

public class Pkcs12SignatureToken
extends AbstractSignatureTokenConnection {
    private char[] password;
    private File pkcs12File;
    private byte[] pkcs12Data;
    private static final Logger logger = Logger.getLogger(Pkcs12SignatureToken.class.getName());

    public Pkcs12SignatureToken(String password, String pkcs12FilePath) {
        this(password.toCharArray(), new File(pkcs12FilePath));
    }

    public Pkcs12SignatureToken(char[] password, String pkcs12FilePath) {
        this(password, new File(pkcs12FilePath));
    }

    public Pkcs12SignatureToken(String password, File pkcs12File) {
        this(password.toCharArray(), pkcs12File);
    }

    public Pkcs12SignatureToken(char[] password, File pkcs12File) {
        this.password = password;
        if (!pkcs12File.exists()) {
            throw new DSSException("File Not Found " + pkcs12File.getAbsolutePath());
        }
        this.pkcs12File = pkcs12File;
    }

    public Pkcs12SignatureToken(char[] password, byte[] pkcs12Data) {
        this.password = password;
        if (pkcs12Data == null) {
            throw new DSSException("PKCS12 data not provided");
        }
        this.pkcs12Data = pkcs12Data;
    }

    public Pkcs12SignatureToken(String password, InputStream inputStream) {
        this.password = password.toCharArray();
        if (inputStream == null) {
            throw new RuntimeException("PKCS12 data not provided");
        }
        try {
            this.pkcs12Data = this.toByteArray(inputStream);
        }
        catch (IOException e2) {
            throw new RuntimeException("Unable to read input : " + e2.getMessage(), e2);
        }
    }

    private byte[] toByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] data = new byte[2048];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            baos.write(data, 0, nRead);
        }
        return baos.toByteArray();
    }

    @Override
    public void close() {
        for (int ii = 0; ii < this.password.length; ++ii) {
            this.password[ii] = '\u0000';
        }
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        InputStream input = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            input = this.pkcs12Data != null ? new ByteArrayInputStream(this.pkcs12Data) : new FileInputStream(this.pkcs12File);
            keyStore.load(input, this.password);
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(this.password);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, pp);
                KSPrivateKeyEntry privateKeyEntry = new KSPrivateKeyEntry(entry);
                list.add(privateKeyEntry);
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e2) {
            if (e2.getCause() instanceof BadPaddingException) {
                throw new DSSException("Bad password for PKCS12");
            }
            throw new DSSException("Can't initialize Sun PKCS#12 security provider. Reason: " + e2.getMessage(), e2);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e3) {
                    logger.error("Have error: ", e3);
                }
            }
        }
        return list;
    }
}

