/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

public class Pkcs11SignatureToken
extends AbstractSignatureTokenConnection {
    private Provider _pkcs11Provider;
    private final String _pkcs11Path;
    private KeyStore _keyStore;
    private final PasswordInputCallback callback;
    private int slotIndex;
    private int smartCardNameIndex = 0;
    private static final Logger logger = Logger.getLogger(AbstractSignatureTokenConnection.class.getName());

    public Pkcs11SignatureToken(String pkcs11Path) {
        this(pkcs11Path, (PasswordInputCallback)null);
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback) {
        this._pkcs11Path = pkcs11Path;
        this.callback = callback;
        this.slotIndex = 0;
        this._keyStore = null;
    }

    public Pkcs11SignatureToken(String pkcs11Path, char[] password) {
        this(pkcs11Path, new PrefilledPasswordCallback(password));
    }

    public Pkcs11SignatureToken(String pkcs11Path, PasswordInputCallback callback, int slotIndex) {
        this(pkcs11Path, callback);
        this.slotIndex = slotIndex;
    }

    public Pkcs11SignatureToken(String pkcs11Path, char[] password, int slotIndex) {
        this(pkcs11Path, password);
        this.slotIndex = slotIndex;
    }

    public void installProvider() {
        String aPKCS11LibraryFileName = this.getPkcs11Path();
        aPKCS11LibraryFileName = this.escapePath(aPKCS11LibraryFileName);
        String name = "SmartCard" + UUID.randomUUID().toString();
        String pkcs11ConfigSettings = "name = " + name + "\nlibrary = \"" + aPKCS11LibraryFileName + "\"\nslotListIndex = " + this.slotIndex;
        logger.info("pkcs11ConfigSettings: " + pkcs11ConfigSettings);
        byte[] pkcs11ConfigBytes = pkcs11ConfigSettings.getBytes();
        ByteArrayInputStream confStream = new ByteArrayInputStream(pkcs11ConfigBytes);
        SunPKCS11 pkcs11 = new SunPKCS11((InputStream)confStream);
        this._pkcs11Provider = pkcs11;
        int pos = Security.addProvider(this._pkcs11Provider);
        logger.info("Preference order: " + pos);
        ++this.smartCardNameIndex;
    }

    private Provider getProvider() {
        try {
            if (this._pkcs11Provider == null) {
                Provider[] providers = Security.getProviders();
                if (providers != null) {
                    for (Provider provider : providers) {
                        String providerInfo = provider.getInfo();
                        if (!providerInfo.contains(this.getPkcs11Path())) continue;
                        this._pkcs11Provider = provider;
                        logger.info("=====> Provider  installed");
                        return provider;
                    }
                }
                logger.info("=====> Provider not installed");
                this.installProvider();
            }
            return this._pkcs11Provider;
        }
        catch (ProviderException ex) {
            logger.error("Error : " + ex.getMessage());
            throw new DSSException("Not a PKCS#11 library", ex);
        }
    }

    public String escapePath(String pathToEscape) {
        if (pathToEscape != null) {
            return pathToEscape.replace("\\", "\\\\");
        }
        return "";
    }

    public KeyStore getKeyStore() throws KeyStoreException, LoginException {
        if (this._keyStore == null) {
            this._keyStore = KeyStore.getInstance("PKCS11", this.getProvider());
            try {
                this._keyStore.load(new KeyStore.LoadStoreParameter(){

                    @Override
                    public KeyStore.ProtectionParameter getProtectionParameter() {
                        return new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

                            @Override
                            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                                for (Callback c2 : callbacks) {
                                    if (!(c2 instanceof PasswordCallback)) continue;
                                    ((PasswordCallback)c2).setPassword(Pkcs11SignatureToken.this.callback.getPassword());
                                    return;
                                }
                                throw new RuntimeException("No password callback");
                            }
                        });
                    }
                });
            }
            catch (Exception e2) {
                if (e2 instanceof PKCS11Exception && "CKR_PIN_INCORRECT".equals(e2.getMessage())) {
                    throw new DSSException("Bad password for PKCS11", e2);
                }
                throw new KeyStoreException("Can't initialize Sun PKCS#11 security provider. Reason: " + e2.getMessage(), e2);
            }
        }
        return this._keyStore;
    }

    protected String getPkcs11Path() {
        return this._pkcs11Path;
    }

    @Override
    public void close() {
        AuthProvider authProvider;
        logger.info("=====> close provider: ");
        if (this._pkcs11Provider != null) {
            try {
                logger.info("=====> Provider name: " + this._pkcs11Provider.getName());
                Security.removeProvider(this._pkcs11Provider.getName());
            }
            catch (Exception ex) {
                logger.error("Error: ", ex);
            }
        }
        if (this._keyStore != null && (authProvider = (AuthProvider)this._keyStore.getProvider()) != null) {
            try {
                logger.info("=====> logout usb-token");
                authProvider.logout();
            }
            catch (LoginException e2) {
                logger.error("Error: ", e2);
            }
        }
        this._pkcs11Provider = null;
        this._keyStore = null;
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore keyStore = this.getKeyStore();
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
                list.add(new KSPrivateKeyEntry(entry));
            }
        }
        catch (Exception e2) {
            logger.error("Co loi xay ra: ", e2);
            throw new DSSException("Can't initialize Sun PKCS#11 security provider. Reason: " + e2.getMessage(), e2);
        }
        return list;
    }
}

