/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.PasswordInputCallback;
import eu.europa.esig.dss.token.PrefilledPasswordCallback;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreSpi;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSCAPISignatureToken
extends AbstractSignatureTokenConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MSCAPISignatureToken.class);

    @Override
    public void close() {
    }

    private static void _fixAliases(KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            String tmpClassName = keyStoreVeritable.getClass().getName();
            if ("sun.security.mscapi.KeyStore$MY".equals(tmpClassName)) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String alias = (String)field.get(entry);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, alias.concat(" - ").concat(hashCode));
                }
            }
        }
        catch (Exception exception) {
            LOG.error(exception.getMessage(), exception);
        }
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            CallbackPasswordProtection protectionParameter = new CallbackPasswordProtection(new PrefilledPasswordCallback("nimp".toCharArray()));
            KeyStore keyStore = KeyStore.getInstance("Windows-MY");
            keyStore.load(null, null);
            MSCAPISignatureToken._fixAliases(keyStore);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, protectionParameter);
                list.add(new KSPrivateKeyEntry(entry));
            }
        }
        catch (Exception e2) {
            throw new DSSException(e2);
        }
        return list;
    }

    private static class CallbackPasswordProtection
    extends KeyStore.PasswordProtection {
        PasswordInputCallback passwordCallback;

        public CallbackPasswordProtection(PasswordInputCallback callback) {
            super(null);
            this.passwordCallback = callback;
        }

        @Override
        public synchronized char[] getPassword() {
            if (this.passwordCallback == null) {
                throw new RuntimeException("MSCAPI: No callback provided for entering the PIN/password");
            }
            char[] password = this.passwordCallback.getPassword();
            return password;
        }
    }
}

