/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.token.AbstractSignatureTokenConnection;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JKSSignatureToken
extends AbstractSignatureTokenConnection {
    private static final Logger logger = LoggerFactory.getLogger(JKSSignatureToken.class);
    private char[] password;
    protected KeyStore keyStore = null;

    public JKSSignatureToken(InputStream ksStream, String ksPassword) {
        try {
            this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            this.password = ksPassword == null ? null : ksPassword.toCharArray();
            this.keyStore.load(ksStream, this.password);
        }
        catch (Exception e2) {
            throw new DSSException(e2);
        }
        finally {
            if (ksStream != null) {
                try {
                    ksStream.close();
                }
                catch (IOException e3) {
                    logger.error(e3.getMessage(), e3);
                }
            }
        }
    }

    @Override
    public void close() {
        for (int ii = 0; ii < this.password.length; ++ii) {
            this.password[ii] = '\u0000';
        }
    }

    @Override
    public List<DSSPrivateKeyEntry> getKeys() throws DSSException {
        ArrayList<DSSPrivateKeyEntry> list = new ArrayList<DSSPrivateKeyEntry>();
        try {
            KeyStore.PasswordProtection pp = new KeyStore.PasswordProtection(this.password);
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!this.keyStore.isKeyEntry(alias)) continue;
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.keyStore.getEntry(alias, pp);
                list.add(new KSPrivateKeyEntry(entry));
            }
        }
        catch (Exception e2) {
            throw new DSSException(e2);
        }
        return list;
    }
}

