/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.token;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import eu.europa.esig.dss.SignatureAlgorithm;
import eu.europa.esig.dss.SignatureValue;
import eu.europa.esig.dss.ToBeSigned;
import eu.europa.esig.dss.token.DSSPrivateKeyEntry;
import eu.europa.esig.dss.token.KSPrivateKeyEntry;
import eu.europa.esig.dss.token.SignatureTokenConnection;
import java.security.Signature;
import org.apache.log4j.Logger;

public abstract class AbstractSignatureTokenConnection
implements SignatureTokenConnection {
    private static final Logger logger = Logger.getLogger(AbstractSignatureTokenConnection.class.getName());

    @Override
    public SignatureValue sign(ToBeSigned toBeSigned, DigestAlgorithm digestAlgorithm, DSSPrivateKeyEntry keyEntry) throws DSSException {
        if (!(keyEntry instanceof KSPrivateKeyEntry)) {
            throw new IllegalArgumentException("Only KSPrivateKeyEntry are supported");
        }
        EncryptionAlgorithm encryptionAlgorithm = keyEntry.getEncryptionAlgorithm();
        logger.info("=====> Signature algorithm encryptionAlgorithm: " + (Object)((Object)encryptionAlgorithm));
        logger.info("=====> Signature algorithm digestAlgorithm: " + (Object)((Object)digestAlgorithm));
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getAlgorithm(encryptionAlgorithm, digestAlgorithm);
        String javaSignatureAlgorithm = signatureAlgorithm.getJCEId();
        logger.info("=====> javaSignatureAlgorithm: javaSignatureAlgorithm " + javaSignatureAlgorithm);
        try {
            Signature signature = Signature.getInstance(javaSignatureAlgorithm);
            signature.initSign(((KSPrivateKeyEntry)keyEntry).getPrivateKey());
            signature.update(toBeSigned.getBytes());
            byte[] signatureValue = signature.sign();
            SignatureValue value = new SignatureValue();
            value.setValue(signatureValue);
            return value;
        }
        catch (Exception e2) {
            throw new DSSException(e2.getMessage(), e2);
        }
    }
}

