/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.Digest;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.x509.Token;
import java.io.Serializable;
import java.security.MessageDigest;
import javax.xml.bind.DatatypeConverter;

public final class TokenIdentifier
implements Serializable {
    private Digest tokenDigest;

    TokenIdentifier(byte[] encodedToken) {
        if (encodedToken == null) {
            throw new DSSException("The encodedToken cannot be null!");
        }
        try {
            DigestAlgorithm algo = DigestAlgorithm.SHA256;
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] digestValue = md.digest(encodedToken);
            this.tokenDigest = new Digest(algo, digestValue);
        }
        catch (Exception e2) {
            throw new DSSException(e2);
        }
    }

    public TokenIdentifier(Token token) {
        this(token.getEncoded());
    }

    public String asXmlId() {
        return DatatypeConverter.printHexBinary((byte[])this.tokenDigest.getValue());
    }

    public String toString() {
        return "{id:" + this.tokenDigest + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tokenDigest == null ? 0 : this.tokenDigest.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenIdentifier other = (TokenIdentifier)obj;
        return !(this.tokenDigest == null ? other.tokenDigest != null : !this.tokenDigest.equals(other.tokenDigest));
    }
}

