/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DigestAlgorithm;
import eu.europa.esig.dss.EncryptionAlgorithm;
import java.util.HashMap;
import java.util.Map;

public enum SignatureAlgorithm {
    RSA_SHA1(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA1),
    RSA_SHA224(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA224),
    RSA_SHA256(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA256),
    RSA_SHA384(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA384),
    RSA_SHA512(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA512),
    RSA_RIPEMD160(EncryptionAlgorithm.RSA, DigestAlgorithm.RIPEMD160),
    RSA_MD5(EncryptionAlgorithm.RSA, DigestAlgorithm.MD5),
    RSA_MD2(EncryptionAlgorithm.RSA, DigestAlgorithm.MD2),
    RSA_SSA_PSS(EncryptionAlgorithm.RSA, DigestAlgorithm.SHA1),
    ECDSA_SHA1(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA1),
    ECDSA_SHA224(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA224),
    ECDSA_SHA256(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA256),
    ECDSA_SHA384(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA384),
    ECDSA_SHA512(EncryptionAlgorithm.ECDSA, DigestAlgorithm.SHA512),
    ECDSA_RIPEMD160(EncryptionAlgorithm.ECDSA, DigestAlgorithm.RIPEMD160),
    DSA_SHA1(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA1),
    DSA_SHA256(EncryptionAlgorithm.DSA, DigestAlgorithm.SHA256),
    HMAC_SHA1(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA1),
    HMAC_SHA224(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA224),
    HMAC_SHA256(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA256),
    HMAC_SHA384(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA384),
    HMAC_SHA512(EncryptionAlgorithm.HMAC, DigestAlgorithm.SHA512),
    HMAC_RIPEMD160(EncryptionAlgorithm.HMAC, DigestAlgorithm.RIPEMD160);

    private final EncryptionAlgorithm encryptionAlgo;
    private final DigestAlgorithm digestAlgo;
    private static final Map<String, SignatureAlgorithm> XML_ALGORITHMS;
    private static final Map<SignatureAlgorithm, String> XML_ALGORITHMS_FOR_KEY;
    private static final Map<String, SignatureAlgorithm> OID_ALGORITHMS;
    private static final Map<String, SignatureAlgorithm> JAVA_ALGORITHMS;
    private static final Map<SignatureAlgorithm, String> JAVA_ALGORITHMS_FOR_KEY;

    private static Map<String, SignatureAlgorithm> registerXmlAlgorithms() {
        HashMap<String, SignatureAlgorithm> xmlAlgorithms = new HashMap<String, SignatureAlgorithm>();
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", RSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", RSA_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", RSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", RSA_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", RSA_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", RSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more/rsa-ripemd160", RSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-md5", RSA_MD5);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#rsa-md2", RSA_MD2);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", ECDSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", ECDSA_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", ECDSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", ECDSA_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", ECDSA_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", ECDSA_RIPEMD160);
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", DSA_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2009/xmldsig11#dsa-sha256", DSA_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", HMAC_SHA1);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha224", HMAC_SHA224);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", HMAC_SHA256);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", HMAC_SHA384);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", HMAC_SHA512);
        xmlAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160", HMAC_RIPEMD160);
        return xmlAlgorithms;
    }

    private static Map<SignatureAlgorithm, String> registerXmlAlgorithmsForKey() {
        HashMap<SignatureAlgorithm, String> xmlAlgorithms = new HashMap<SignatureAlgorithm, String>();
        for (Map.Entry<String, SignatureAlgorithm> entry : XML_ALGORITHMS.entrySet()) {
            xmlAlgorithms.put(entry.getValue(), entry.getKey());
        }
        return xmlAlgorithms;
    }

    private static Map<String, SignatureAlgorithm> registerOIDAlgorithms() {
        HashMap<String, SignatureAlgorithm> oidAlgorithms = new HashMap<String, SignatureAlgorithm>();
        oidAlgorithms.put("1.2.840.113549.1.1.5", RSA_SHA1);
        oidAlgorithms.put("1.3.14.3.2.29", RSA_SHA1);
        oidAlgorithms.put("1.2.840.113549.1.1.14", RSA_SHA224);
        oidAlgorithms.put("1.2.840.113549.1.1.11", RSA_SHA256);
        oidAlgorithms.put("1.2.840.113549.1.1.12", RSA_SHA384);
        oidAlgorithms.put("1.2.840.113549.1.1.13", RSA_SHA512);
        oidAlgorithms.put("1.3.36.3.3.1.2", RSA_RIPEMD160);
        oidAlgorithms.put("1.2.840.113549.1.1.4", RSA_MD5);
        oidAlgorithms.put("1.2.840.113549.1.1.2", RSA_MD2);
        oidAlgorithms.put("1.2.840.10045.4.1", ECDSA_SHA1);
        oidAlgorithms.put("1.2.840.10045.4.3.1", ECDSA_SHA224);
        oidAlgorithms.put("1.2.840.10045.4.3.2", ECDSA_SHA256);
        oidAlgorithms.put("1.2.840.10045.4.3.3", ECDSA_SHA384);
        oidAlgorithms.put("1.2.840.10045.4.3.4", ECDSA_SHA512);
        oidAlgorithms.put("0.4.0.127.0.7.1.1.4.1.6", ECDSA_RIPEMD160);
        oidAlgorithms.put("1.2.840.10040.4.3", DSA_SHA1);
        oidAlgorithms.put("1.2.14888.3.0.1", DSA_SHA1);
        oidAlgorithms.put("2.16.840.1.101.3.4.3.2", DSA_SHA256);
        oidAlgorithms.put("1.2.840.113549.2.7", HMAC_SHA1);
        oidAlgorithms.put("1.2.840.113549.2.8", HMAC_SHA224);
        oidAlgorithms.put("1.2.840.113549.2.9", HMAC_SHA256);
        oidAlgorithms.put("1.2.840.113549.2.10", HMAC_SHA384);
        oidAlgorithms.put("1.2.840.113549.2.11", HMAC_SHA512);
        oidAlgorithms.put("1.3.6.1.5.5.8.1.4", HMAC_RIPEMD160);
        oidAlgorithms.put("1.2.840.113549.1.1.10", RSA_SSA_PSS);
        return oidAlgorithms;
    }

    private static Map<String, SignatureAlgorithm> registerJavaAlgorithms() {
        HashMap<String, SignatureAlgorithm> javaAlgorithms = new HashMap<String, SignatureAlgorithm>();
        javaAlgorithms.put("SHA1withRSA", RSA_SHA1);
        javaAlgorithms.put("SHA224withRSA", RSA_SHA224);
        javaAlgorithms.put("SHA256withRSA", RSA_SHA256);
        javaAlgorithms.put("SHA384withRSA", RSA_SHA384);
        javaAlgorithms.put("SHA512withRSA", RSA_SHA512);
        javaAlgorithms.put("RIPEMD160withRSA", RSA_RIPEMD160);
        javaAlgorithms.put("MD5withRSA", RSA_MD5);
        javaAlgorithms.put("MD2withRSA", RSA_MD2);
        javaAlgorithms.put("SHA1withECDSA", ECDSA_SHA1);
        javaAlgorithms.put("SHA224withECDSA", ECDSA_SHA224);
        javaAlgorithms.put("SHA256withECDSA", ECDSA_SHA256);
        javaAlgorithms.put("SHA384withECDSA", ECDSA_SHA384);
        javaAlgorithms.put("SHA512withECDSA", ECDSA_SHA512);
        javaAlgorithms.put("RIPEMD160withECDSA", ECDSA_RIPEMD160);
        javaAlgorithms.put("SHA1withDSA", DSA_SHA1);
        javaAlgorithms.put("SHA256withDSA", DSA_SHA256);
        javaAlgorithms.put("SHA1withHMAC", HMAC_SHA1);
        javaAlgorithms.put("SHA224withHMAC", HMAC_SHA224);
        javaAlgorithms.put("SHA256withHMAC", HMAC_SHA256);
        javaAlgorithms.put("SHA384withHMAC", HMAC_SHA384);
        javaAlgorithms.put("SHA512withHMAC", HMAC_SHA512);
        javaAlgorithms.put("RIPEMD160withHMAC", HMAC_RIPEMD160);
        return javaAlgorithms;
    }

    private static Map<SignatureAlgorithm, String> registerJavaAlgorithmsForKey() {
        HashMap<SignatureAlgorithm, String> javaAlgorithms = new HashMap<SignatureAlgorithm, String>();
        for (Map.Entry<String, SignatureAlgorithm> entry : JAVA_ALGORITHMS.entrySet()) {
            javaAlgorithms.put(entry.getValue(), entry.getKey());
        }
        return javaAlgorithms;
    }

    public static SignatureAlgorithm forXML(String xmlName) {
        SignatureAlgorithm algorithm = XML_ALGORITHMS.get(xmlName);
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + xmlName);
        }
        return algorithm;
    }

    public static SignatureAlgorithm forXML(String xmlName, SignatureAlgorithm defaultValue) {
        SignatureAlgorithm algorithm = XML_ALGORITHMS.get(xmlName);
        if (algorithm == null) {
            return defaultValue;
        }
        return algorithm;
    }

    public static SignatureAlgorithm forOID(String oid) {
        SignatureAlgorithm algorithm = OID_ALGORITHMS.get(oid);
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + oid);
        }
        return algorithm;
    }

    public static SignatureAlgorithm forJAVA(String javaName) {
        SignatureAlgorithm algorithm = JAVA_ALGORITHMS.get(javaName);
        if (algorithm == null) {
            throw new DSSException("Unsupported algorithm: " + javaName);
        }
        return algorithm;
    }

    public static SignatureAlgorithm getAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        String digestAlgorithm_ = digestAlgorithm.getName();
        digestAlgorithm_ = digestAlgorithm_.replace("-", "");
        String javaName = digestAlgorithm_ + "with" + encryptionAlgorithm.getName();
        return JAVA_ALGORITHMS.get(javaName);
    }

    private SignatureAlgorithm(EncryptionAlgorithm encryptionAlgorithm, DigestAlgorithm digestAlgorithm) {
        this.encryptionAlgo = encryptionAlgorithm;
        this.digestAlgo = digestAlgorithm;
    }

    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgo;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgo;
    }

    public String getXMLId() {
        return XML_ALGORITHMS_FOR_KEY.get((Object)this);
    }

    public String getJCEId() {
        return JAVA_ALGORITHMS_FOR_KEY.get((Object)this);
    }

    static {
        XML_ALGORITHMS = SignatureAlgorithm.registerXmlAlgorithms();
        XML_ALGORITHMS_FOR_KEY = SignatureAlgorithm.registerXmlAlgorithmsForKey();
        OID_ALGORITHMS = SignatureAlgorithm.registerOIDAlgorithms();
        JAVA_ALGORITHMS = SignatureAlgorithm.registerJavaAlgorithms();
        JAVA_ALGORITHMS_FOR_KEY = SignatureAlgorithm.registerJavaAlgorithmsForKey();
    }
}

