/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSDocument;
import eu.europa.esig.dss.MimeType;
import java.io.Serializable;
import java.util.Arrays;

public class RemoteDocument
implements Serializable {
    private byte[] bytes;
    private String name = "RemoteDocument";
    private String absolutePath = "RemoteDocument";
    private MimeType mimeType;

    public RemoteDocument() {
    }

    public RemoteDocument(DSSDocument document) {
        byte[] originalBytes = document.getBytes();
        this.bytes = Arrays.copyOf(originalBytes, originalBytes.length);
        this.mimeType = document.getMimeType();
        this.name = document.getName();
        this.absolutePath = document.getAbsolutePath();
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public void setAbsolutePath(String absolutePath) {
        this.absolutePath = absolutePath;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolutePath == null ? 0 : this.absolutePath.hashCode());
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteDocument other = (RemoteDocument)obj;
        if (this.absolutePath == null ? other.absolutePath != null : !this.absolutePath.equals(other.absolutePath)) {
            return false;
        }
        if (!Arrays.equals(this.bytes, other.bytes)) {
            return false;
        }
        if (this.mimeType == null ? other.mimeType != null : !this.mimeType.equals(other.mimeType)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "RemoteDocument [bytes=" + Arrays.toString(this.bytes) + ", name=" + this.name + ", absolutePath=" + this.absolutePath + ", mimeType=" + this.mimeType + "]";
    }
}

