/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import javax.security.auth.x500.X500Principal;
import port.org.bouncycastle.asn1.ASN1Encodable;
import port.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import port.org.bouncycastle.asn1.ASN1Sequence;
import port.org.bouncycastle.asn1.DERBMPString;
import port.org.bouncycastle.asn1.DERIA5String;
import port.org.bouncycastle.asn1.DERPrintableString;
import port.org.bouncycastle.asn1.DERT61String;
import port.org.bouncycastle.asn1.DERT61UTF8String;
import port.org.bouncycastle.asn1.DERUTF8String;
import port.org.bouncycastle.asn1.DLSequence;
import port.org.bouncycastle.asn1.DLSet;

public final class Normalizer {
    public static X500Principal getNormalizedX500Principal(X500Principal x500Principal) {
        String utf8Name = Normalizer.getUtf8String(x500Principal);
        X500Principal x500PrincipalNormalized = new X500Principal(utf8Name);
        return x500PrincipalNormalized;
    }

    public static String getUtf8String(X500Principal x500Principal) {
        byte[] encoded = x500Principal.getEncoded();
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance(encoded);
        ASN1Encodable[] asn1Encodables = asn1Sequence.toArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int ii = asn1Encodables.length - 1; ii >= 0; --ii) {
            ASN1Encodable asn1Encodable = asn1Encodables[ii];
            DLSet dlSet = (DLSet)asn1Encodable;
            for (int jj = 0; jj < dlSet.size(); ++jj) {
                DLSequence dlSequence = (DLSequence)dlSet.getObjectAt(jj);
                if (dlSequence.size() != 2) {
                    throw new DSSException("The DLSequence must contains exactly 2 elements.");
                }
                ASN1Encodable attributeType = dlSequence.getObjectAt(0);
                ASN1Encodable attributeValue = dlSequence.getObjectAt(1);
                String string = Normalizer.getString(attributeValue);
                string = string.replace("\"", "\\\"");
                string = string.replace("#", "\\#");
                string = string.replace("+", "\\+");
                string = string.replace(",", "\\,");
                string = string.replace(";", "\\;");
                string = string.replace("<", "\\<");
                string = string.replace("=", "\\=");
                string = string.replace(">", "\\>");
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(attributeType).append('=').append(string);
            }
        }
        return stringBuilder.toString();
    }

    private static String getString(ASN1Encodable attributeValue) {
        String string;
        if (attributeValue instanceof DERUTF8String) {
            string = ((DERUTF8String)attributeValue).getString();
        } else if (attributeValue instanceof DERPrintableString) {
            string = ((DERPrintableString)attributeValue).getString();
        } else if (attributeValue instanceof DERBMPString) {
            string = ((DERBMPString)attributeValue).getString();
        } else if (attributeValue instanceof DERT61String) {
            string = ((DERT61String)attributeValue).getString();
        } else if (attributeValue instanceof DERIA5String) {
            string = ((DERIA5String)attributeValue).getString();
        } else if (attributeValue instanceof ASN1ObjectIdentifier) {
            string = ((ASN1ObjectIdentifier)attributeValue).getId();
        } else if (attributeValue instanceof DERT61UTF8String) {
            string = ((DERT61UTF8String)attributeValue).getString();
        } else if (attributeValue instanceof DLSequence) {
            StringBuffer buffer = new StringBuffer();
            DLSequence sequence = (DLSequence)attributeValue;
            for (int i2 = 0; i2 < sequence.size(); ++i2) {
                buffer.append(Normalizer.getString(sequence.getObjectAt(1)));
            }
            string = buffer.toString();
        } else {
            throw new DSSException("Unknown encoding ; " + attributeValue.getClass().getSimpleName());
        }
        return string;
    }
}

