/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class MimeType
implements Serializable {
    private static Map<String, MimeType> mimeTypes = new HashMap<String, MimeType>();
    public static final MimeType BINARY = new MimeType("application/octet-stream");
    public static final MimeType XML = new MimeType("text/xml");
    public static final MimeType PDF = new MimeType("application/pdf");
    public static final MimeType PKCS7 = new MimeType("application/pkcs7-signature");
    public static final MimeType ASICS = new MimeType("application/vnd.etsi.asic-s+zip");
    public static final MimeType ASICE = new MimeType("application/vnd.etsi.asic-e+zip");
    public static final MimeType TEXT = new MimeType("text/plain");
    private String mimeTypeString;
    private static Map<String, MimeType> fileExtensions = new HashMap<String, MimeType>(){
        {
            this.put("xml", XML);
            this.put("pdf", PDF);
            this.put("asics", ASICS);
            this.put("scs", ASICS);
            this.put("asice", ASICE);
            this.put("bdoc", ASICE);
            this.put("sce", ASICE);
            this.put("txt", TEXT);
            this.put("zip", ASICE);
        }
    };

    public MimeType() {
    }

    private MimeType(String mimeTypeString) {
        if (!mimeTypeString.matches("([\\w])*/([\\w\\-\\+\\.])*")) {
            throw new DSSException("'" + mimeTypeString + "' is not conformant mime-type string!");
        }
        if (mimeTypes.get(mimeTypeString) != null) {
            throw new DSSException("'" + mimeTypeString + "' corresponding MimeType exists already! Use #fromMimeTypeString method to obtain the corresponding object.");
        }
        this.mimeTypeString = mimeTypeString;
        mimeTypes.put(mimeTypeString, this);
    }

    public MimeType(String mimeTypeString, String extension) {
        this(mimeTypeString);
        fileExtensions.put(extension, this);
    }

    public String getMimeTypeString() {
        return this.mimeTypeString;
    }

    public void setMimeTypeString(String mimeTypeString) {
        this.mimeTypeString = mimeTypeString;
    }

    public static MimeType fromFileName(String fileName) {
        String inLowerCaseName = fileName.toLowerCase();
        String fileExtension = MimeType.getFileExtension(inLowerCaseName);
        MimeType mimeType = fileExtensions.get(fileExtension);
        if (mimeType != null) {
            return mimeType;
        }
        return BINARY;
    }

    public static String getExtension(MimeType mimeType) {
        for (Map.Entry<String, MimeType> entry : fileExtensions.entrySet()) {
            if (!mimeType.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return "";
    }

    public static String getFileExtension(String path) {
        String extension = null;
        int lastIndexOf = path.lastIndexOf(46);
        if (lastIndexOf > 0) {
            extension = path.substring(lastIndexOf + 1);
        }
        return extension;
    }

    public static MimeType fromFile(File file) {
        String fileName = file.getName();
        MimeType mimeType = MimeType.fromFileName(fileName);
        return mimeType;
    }

    public static MimeType fromMimeTypeString(String mimeTypeString) {
        MimeType mimeType = mimeTypes.get(mimeTypeString);
        if (mimeType == null) {
            mimeType = new MimeType(mimeTypeString);
        }
        return mimeType;
    }

    public void defineFileExtension(String extension) {
        fileExtensions.put(extension, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mimeTypeString == null ? 0 : this.mimeTypeString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeType other = (MimeType)obj;
        return !(this.mimeTypeString == null ? other.mimeTypeString != null : !this.mimeTypeString.equals(other.mimeTypeString));
    }
}

