/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss;

import eu.europa.esig.dss.DSSException;
import eu.europa.esig.dss.DateAdapter;
import eu.europa.esig.dss.Policy;
import eu.europa.esig.dss.SignerLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class BLevelParameters
implements Serializable {
    private boolean trustAnchorBPPolicy = true;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Date signingDate = new Date();
    private List<String> claimedSignerRoles;
    private List<String> certifiedSignerRoles;
    private Policy signaturePolicy;
    private List<String> commitmentTypeIndication;
    private SignerLocation signerLocation;

    public boolean isTrustAnchorBPPolicy() {
        return this.trustAnchorBPPolicy;
    }

    public void setTrustAnchorBPPolicy(boolean trustAnchorBPPolicy) {
        this.trustAnchorBPPolicy = trustAnchorBPPolicy;
    }

    public Policy getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(Policy signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public Date getSigningDate() {
        return this.signingDate;
    }

    public void setSigningDate(Date signingDate) {
        this.signingDate = signingDate;
    }

    public List<String> getClaimedSignerRoles() {
        return this.claimedSignerRoles;
    }

    public void addClaimedSignerRole(String claimedSignerRole) {
        if (claimedSignerRole == null || claimedSignerRole.length() == 0) {
            throw new NullPointerException("claimedSignerRole");
        }
        if (this.claimedSignerRoles == null) {
            this.claimedSignerRoles = new ArrayList<String>();
        }
        this.claimedSignerRoles.add(claimedSignerRole);
    }

    public List<String> getCertifiedSignerRoles() {
        return this.certifiedSignerRoles;
    }

    public void addCertifiedSignerRole(String certifiedSignerRole) {
        throw new DSSException("eu.europa.esig.dss.BLevelParameters.addCertifiedSignerRole");
    }

    public List<String> getCommitmentTypeIndications() {
        return this.commitmentTypeIndication;
    }

    public void setCommitmentTypeIndications(List<String> commitmentTypeIndication) {
        this.commitmentTypeIndication = commitmentTypeIndication;
    }

    public SignerLocation getSignerLocation() {
        return this.signerLocation;
    }

    public void setSignerLocation(SignerLocation signerLocation) {
        this.signerLocation = signerLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.certifiedSignerRoles == null ? 0 : this.certifiedSignerRoles.hashCode());
        result = 31 * result + (this.claimedSignerRoles == null ? 0 : this.claimedSignerRoles.hashCode());
        result = 31 * result + (this.commitmentTypeIndication == null ? 0 : this.commitmentTypeIndication.hashCode());
        result = 31 * result + (this.signaturePolicy == null ? 0 : this.signaturePolicy.hashCode());
        result = 31 * result + (this.signerLocation == null ? 0 : this.signerLocation.hashCode());
        result = 31 * result + (this.signingDate == null ? 0 : this.signingDate.hashCode());
        result = 31 * result + (this.trustAnchorBPPolicy ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BLevelParameters other = (BLevelParameters)obj;
        if (this.certifiedSignerRoles == null ? other.certifiedSignerRoles != null : !this.certifiedSignerRoles.equals(other.certifiedSignerRoles)) {
            return false;
        }
        if (this.claimedSignerRoles == null ? other.claimedSignerRoles != null : !this.claimedSignerRoles.equals(other.claimedSignerRoles)) {
            return false;
        }
        if (this.commitmentTypeIndication == null ? other.commitmentTypeIndication != null : !this.commitmentTypeIndication.equals(other.commitmentTypeIndication)) {
            return false;
        }
        if (this.signaturePolicy == null ? other.signaturePolicy != null : !this.signaturePolicy.equals(other.signaturePolicy)) {
            return false;
        }
        if (this.signerLocation == null ? other.signerLocation != null : !this.signerLocation.equals(other.signerLocation)) {
            return false;
        }
        if (this.signingDate == null ? other.signingDate != null : !this.signingDate.equals(other.signingDate)) {
            return false;
        }
        return this.trustAnchorBPPolicy == other.trustAnchorBPPolicy;
    }

    public String toString() {
        return "BLevelParameters [trustAnchorBPPolicy=" + this.trustAnchorBPPolicy + ", signingDate=" + this.signingDate + ", claimedSignerRoles=" + this.claimedSignerRoles + ", certifiedSignerRoles=" + this.certifiedSignerRoles + ", signaturePolicy=" + this.signaturePolicy + ", commitmentTypeIndication=" + this.commitmentTypeIndication + ", signerLocation=" + this.signerLocation + "]";
    }
}

