/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class X509VerificationUtil {
    private static final Logger logger = Logger.getLogger(X509VerificationUtil.class.getName());

    private X509VerificationUtil() {
    }

    public static String verifyCertificate(X509Certificate cert) {
        return X509VerificationUtil.verifyCertificate(cert, null, null);
    }

    public static String verifyCertificate(X509Certificate cert, Calendar calendar) {
        return X509VerificationUtil.verifyCertificate(cert, null, calendar);
    }

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls) {
        return X509VerificationUtil.verifyCertificate(cert, crls, null);
    }

    public static String verifyCertificate(X509Certificate cert, Collection<CRL> crls, Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        if (cert.hasUnsupportedCriticalExtension()) {
            return "Has unsupported critical extension";
        }
        try {
            cert.checkValidity(calendar.getTime());
            if (crls != null) {
                for (CRL crl : crls) {
                    if (!crl.isRevoked(cert)) continue;
                    return "Certificate revoked";
                }
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return null;
    }

    public static String verifyCertificate(X509Certificate certificate, KeyStore keyStore) {
        Certificate[] chain = new Certificate[]{certificate};
        return X509VerificationUtil.verifyCertificates(chain, keyStore, null, null);
    }

    public static String verifyCertificate(X509Certificate certificate, KeyStore keyStore, Collection<CRL> crls, Calendar calendar) {
        Certificate[] chain = new Certificate[]{certificate};
        return X509VerificationUtil.verifyCertificates(chain, keyStore, crls, calendar);
    }

    public static Object[] verifyCertificates(Certificate[] chain, Certificate externalCert) {
        return X509VerificationUtil.verifyCertificates(chain, externalCert, null, null);
    }

    public static Object[] verifyCertificates(Certificate[] chain, Certificate externalCert, Collection<CRL> crls) {
        return X509VerificationUtil.verifyCertificates(chain, externalCert, crls, null);
    }

    public static Object[] verifyCertificates(Certificate[] chain, Certificate externalCert, Calendar calendar) {
        return X509VerificationUtil.verifyCertificates(chain, externalCert, null, calendar);
    }

    public static Object[] verifyCertificates(Certificate[] chain, Certificate externalCert, Collection<CRL> crls, Calendar calendar) {
        int length = chain.length;
        for (int k2 = 0; k2 < length; ++k2) {
            X509Certificate cert = (X509Certificate)chain[k2];
            String err = X509VerificationUtil.verifyCertificate(cert, crls, calendar);
            if (err != null) {
                return new Object[]{cert, err};
            }
            try {
                cert.verify(externalCert.getPublicKey());
                return null;
            }
            catch (Exception e2) {
                logger.error("Have error: ", e2);
                int j2 = k2 + 1;
                if (j2 >= chain.length) continue;
                X509Certificate nextCert = (X509Certificate)chain[j2];
                try {
                    cert.verify(nextCert.getPublicKey());
                    continue;
                }
                catch (Exception e3) {
                    logger.error("Have error: ", e3);
                    return new Object[]{null, "Invalid certificate chain"};
                }
            }
        }
        return new Object[]{null, "CA certificate can not verify user"};
    }

    public static String verifyCertificates(Certificate[] chain, KeyStore keyStore) {
        return X509VerificationUtil.verifyCertificates(chain, keyStore, null, null);
    }

    public static String verifyCertificates(Certificate[] chain, KeyStore keyStore, Collection<CRL> crls, Calendar calendar) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                X509Certificate caCertificate;
                Object[] results;
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias) || (results = X509VerificationUtil.verifyCertificates(chain, caCertificate = (X509Certificate)keyStore.getCertificate(alias), crls, calendar)) != null) continue;
                return null;
            }
            return "Chain verification fails";
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
            return e2.getMessage();
        }
    }

    public static String verifyCertificate(Certificate[] chain) {
        int length = chain.length;
        for (int i2 = 0; i2 < length; ++i2) {
            X509Certificate innercert = (X509Certificate)chain[i2];
            String res = X509VerificationUtil.verifyCertificate(innercert);
            if (res != null) {
                return res;
            }
            int j2 = i2 + 1;
            if (j2 >= length) continue;
            X509Certificate cacert = (X509Certificate)chain[j2];
            try {
                innercert.verify(cacert.getPublicKey());
                continue;
            }
            catch (Exception e2) {
                logger.error("Have error: ", e2);
                return e2.getMessage();
            }
        }
        return null;
    }
}

