/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;

public class X509ExtensionUtil {
    private static final Logger logger = Logger.getLogger(X509ExtensionUtil.class.getName());

    private X509ExtensionUtil() {
    }

    public static String getSubject(X509Certificate certificate) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(certificate);
            Vector vector = principal.getValues(X509Principal.CN);
            if (vector.size() != 1) {
                return "";
            }
            return vector.firstElement().toString();
        }
        catch (CertificateEncodingException e2) {
            logger.error("Have error : ", e2);
            return "";
        }
    }

    public static String getOrganization(X509Certificate certificate) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(certificate);
            Vector vector = principal.getValues(X509Principal.O);
            if (vector.size() != 1) {
                return "";
            }
            return vector.firstElement().toString();
        }
        catch (CertificateEncodingException e2) {
            logger.error("Have error: ", e2);
            return "";
        }
    }

    public static String getOrganizationUnit(X509Certificate certificate) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(certificate);
            Vector vector = principal.getValues(X509Principal.OU);
            if (vector.size() != 1) {
                return "";
            }
            return vector.firstElement().toString();
        }
        catch (CertificateEncodingException e2) {
            logger.error("Have error: ", e2);
            return "";
        }
    }

    public static String getLocation(X509Certificate certificate) {
        try {
            X509Principal principal = PrincipalUtil.getSubjectX509Principal(certificate);
            Vector vector = principal.getValues(X509Principal.L);
            if (vector.size() != 1) {
                return "";
            }
            return vector.firstElement().toString();
        }
        catch (CertificateEncodingException e2) {
            logger.error("Have error: ", e2);
            return "";
        }
    }

    public static String getIssuerName(X509Certificate certificate) {
        try {
            X509Principal principal = PrincipalUtil.getIssuerX509Principal(certificate);
            Vector vector = principal.getValues(X509Principal.CN);
            if (vector.size() != 1) {
                return "";
            }
            return vector.firstElement().toString();
        }
        catch (CertificateEncodingException e2) {
            logger.error("Have error: ", e2);
            return "";
        }
    }

    public static String getCRLURL(X509Certificate certificate) {
        try {
            ASN1Primitive obj = X509ExtensionUtil.getExtensionValue(certificate, X509Extensions.CRLDistributionPoints.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence accessDescriptions = (ASN1Sequence)obj;
            int size = accessDescriptions.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ASN1Sequence accessDescription = (ASN1Sequence)accessDescriptions.getObjectAt(i2);
                if (size != 2 || !(accessDescription.getObjectAt(0) instanceof ASN1Primitive)) continue;
                String accessLocation = X509ExtensionUtil.getStringFromGeneralName((ASN1Primitive)accessDescription.getObjectAt(0));
                if (accessLocation == null) {
                    return "";
                }
                return accessLocation;
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return null;
    }

    public static String getOCSPURL(X509Certificate certificate) {
        try {
            ASN1Primitive obj = X509ExtensionUtil.getExtensionValue(certificate, X509Extensions.AuthorityInfoAccess.getId());
            if (obj == null) {
                return null;
            }
            ASN1Sequence accessDescriptions = (ASN1Sequence)obj;
            for (int i2 = 0; i2 < accessDescriptions.size(); ++i2) {
                ASN1Sequence accessDescription = (ASN1Sequence)accessDescriptions.getObjectAt(i2);
                if (accessDescription.size() != 2 || !(accessDescription.getObjectAt(0) instanceof DERObjectIdentifier) || !"1.3.6.1.5.5.7.48.1".equals(((DERObjectIdentifier)accessDescription.getObjectAt(0)).getId())) continue;
                String accessLocation = X509ExtensionUtil.getStringFromGeneralName((ASN1Primitive)accessDescription.getObjectAt(1));
                if (accessLocation == null) {
                    return "";
                }
                return accessLocation;
            }
        }
        catch (Exception e2) {
            logger.error("Have error: ", e2);
        }
        return null;
    }

    private static ASN1Primitive getExtensionValue(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(bytes));
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(new ByteArrayInputStream(octs.getOctets()));
        return aIn.readObject();
    }

    private static String getStringFromGeneralName(ASN1Primitive names) throws IOException {
        DERTaggedObject taggedObject = (DERTaggedObject)names;
        return new String(ASN1OctetString.getInstance(taggedObject, false).getOctets(), "ISO-8859-1");
    }
}

