/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import eu.europa.esig.dss.token.utils.XMLDocumentUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VerifySignature {
    private static final Logger logger = Logger.getLogger(VerifySignature.class.getName());

    public static void main(String[] args) throws Exception {
        DOMValidateContext valContext;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLDocumentUtils.disableUnsafeEntity(dbf);
        dbf.setNamespaceAware(true);
        String filePath = "D:\\Users\\tuannh8\\Desktop\\30098_8000059020_05112015-AD_16E4188907\\LDZMWKZIXP-VA_16E0000276\\LDZMWKZIXP-VA_16E0000276.xml";
        Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(filePath));
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = fac.unmarshalXMLSignature(valContext = new DOMValidateContext(new X509KeySelector(), nl.item(0)));
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            System.err.println("Signature failed core validation");
            boolean sv = signature.getSignatureValue().validate(valContext);
            logger.info("signature validation status: " + sv);
        } else {
            logger.info("Signature passed core validation");
        }
    }

    public boolean verifySignature(String file) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            boolean bl = this.verifySignature(is);
            return bl;
        }
    }

    public boolean verifySignature(InputStream is) throws Exception {
        NodeList nl;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLDocumentUtils.disableUnsafeEntity(dbf);
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(is);
        NodeList nodeHD = doc.getElementsByTagName("DLHDon");
        if (nodeHD.getLength() > 0) {
            ((Element)nodeHD.item(0)).setIdAttribute("Id", true);
        }
        if ((nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature")).getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        logger.info("Signature length: " + nl.getLength());
        while (nl.getLength() > 0) {
            Node signatureNode = nl.item(nl.getLength() - 1);
            boolean verify = this.verifySingleSignature(signatureNode);
            if (!verify) {
                return false;
            }
            Node parentNode = signatureNode.getParentNode();
            parentNode.removeChild(signatureNode);
        }
        return true;
    }

    public boolean verifySingleSignature(Node node) throws Exception {
        DOMValidateContext valContext;
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = fac.unmarshalXMLSignature(valContext = new DOMValidateContext(new X509KeySelector(), node));
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            logger.warn("Signature failed core validation");
            boolean sv = signature.getSignatureValue().validate(valContext);
            logger.info("signature validation status: " + sv);
        }
        return coreValidity;
    }

    public int getNumberOfSignature(String file) throws Exception {
        try (FileInputStream is = new FileInputStream(file);){
            int n2 = this.getNumberOfSignature(is);
            return n2;
        }
    }

    public int getNumberOfSignature(InputStream is) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        XMLDocumentUtils.disableUnsafeEntity(dbf);
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(is);
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        return nl.getLength();
    }

    public static class X509KeySelector
    extends KeySelector {
        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            for (XMLStructure info : keyInfo.getContent()) {
                if (!(info instanceof X509Data)) continue;
                X509Data x509Data = (X509Data)info;
                for (Object o2 : x509Data.getContent()) {
                    if (!(o2 instanceof X509Certificate)) continue;
                    final PublicKey key = ((X509Certificate)o2).getPublicKey();
                    if (!X509KeySelector.algEquals(method.getAlgorithm(), key.getAlgorithm())) continue;
                    return new KeySelectorResult(){

                        @Override
                        public Key getKey() {
                            return key;
                        }
                    };
                }
            }
            throw new KeySelectorException("No key found!");
        }

        static boolean algEquals(String algURI, String algName) {
            return "DSA".equalsIgnoreCase(algName) && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || "RSA".equalsIgnoreCase(algName) && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

