/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import com.viettel.einvoice.verify.CheckOcspOrCrl;
import com.viettel.einvoice.verify.VerifySignatureOutput;
import eu.europa.esig.dss.token.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import sun.security.x509.X500Name;

public class SearchInvoiceService
implements Serializable {
    private static final Logger logger = Logger.getLogger(SearchInvoiceService.class.getName());

    public String createSecurityCertificateFile(String content, String pathDownloadFile, boolean isSeller) throws Exception {
        StringBuilder certificatePathBuilder = new StringBuilder(pathDownloadFile).append("\\");
        if (isSeller) {
            certificatePathBuilder.append("certificate.cer");
        } else {
            certificatePathBuilder.append("certificate-buyer.cer");
        }
        String certificateFilePath = certificatePathBuilder.toString();
        File file = new File(certificateFilePath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(content.getBytes());
        outputStream.flush();
        outputStream.close();
        return certificateFilePath;
    }

    public boolean checkCertificateValid(InputStream is) throws ConnectException, SocketTimeoutException, Exception {
        VerifySignatureOutput output = CheckOcspOrCrl.checkCertificateValid(is);
        if ("CONNECTION_TO_CRL_SERVER_FAIL".equals(output.getErrorCode())) {
            throw new ConnectException(output.getErrorCode());
        }
        logger.info("=====> ERROR CODE : " + output.getErrorCode());
        return StringUtil.isNullOrEmpty(output.getErrorCode());
    }

    public String parseCertificateFileToGetCertificateOwner(String certificate) throws Exception {
        String[] arrCaCert;
        logger.info("=====> start parseCertificateFileToGetCertificateOwner");
        logger.info("=====> input : " + certificate);
        if (StringUtil.isNullOrEmpty(certificate).booleanValue()) {
            logger.info("=====> Input for parseCertificateFileToGetCertificateOwner null");
            return "";
        }
        certificate = "-----BEGIN CERTIFICATE-----\n" + certificate + "-----END CERTIFICATE-----";
        logger.info("=====> input : " + certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream in = new ByteArrayInputStream(certificate.getBytes());
        X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(in);
        X500Name vietteldn = (X500Name)x509Certificate.getSubjectDN();
        String caCert = vietteldn.getName();
        if (caCert != null && caCert.contains(",") && (arrCaCert = caCert.split(",")) != null && arrCaCert.length > 0) {
            for (String strTemp : arrCaCert) {
                if (strTemp == null || !strTemp.contains("CN") || !strTemp.contains("=")) continue;
                logger.info(" start parseCertificateFileToGetCertificateOwner");
                return strTemp.split("=")[1];
            }
        }
        logger.info("finish parseCertificateFileToGetCertificateOwner");
        return "";
    }
}

