/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import com.viettel.einvoice.verify.ExceptionConverter;
import com.viettel.einvoice.verify.X509VerificationUtil;
import eu.europa.esig.dss.token.connection.Manager;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.CertificateStatus;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.ocsp.UnknownStatus;

public class OcspClientBouncyCastle {
    private X509Certificate rootCert;
    private X509Certificate checkCert;
    private String url;

    public OcspClientBouncyCastle(X509Certificate checkCert, X509Certificate rootCert, String url) {
        this.checkCert = checkCert;
        this.rootCert = rootCert;
        this.url = url;
    }

    private static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws OCSPException, IOException {
        Security.addProvider(new BouncyCastleProvider());
        CertificateID id = new CertificateID("1.3.14.3.2.26", issuerCert, serialNumber);
        OCSPReqGenerator gen = new OCSPReqGenerator();
        gen.addRequest(id);
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Vector<ASN1ObjectIdentifier> oids = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> values = new Vector<X509Extension>();
        oids.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        values.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(nonce.toByteArray())));
        gen.setRequestExtensions(new X509Extensions(oids, values));
        return gen.generate();
    }

    public byte[] getEncoded() {
        try {
            SingleResp[] responses;
            OCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(this.rootCert, this.checkCert.getSerialNumber());
            byte[] array = request.getEncoded();
            URL urlt = new URL(this.url);
            HttpURLConnection con = (HttpURLConnection)urlt.openConnection();
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(array);
            dataOut.flush();
            dataOut.close();
            if (con.getResponseCode() / 100 != 2) {
                throw new IOException("invalid http response");
            }
            InputStream in = (InputStream)con.getContent();
            OCSPResp ocspResponse = new OCSPResp(in);
            if (ocspResponse.getStatus() != 0) {
                throw new IOException("invalid status");
            }
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
            if (basicResponse != null && (responses = basicResponse.getResponses()).length == 1) {
                SingleResp resp = responses[0];
                Object status = resp.getCertStatus();
                if (status == CertificateStatus.GOOD) {
                    return basicResponse.getEncoded();
                }
                if (status instanceof RevokedStatus) {
                    throw new IOException("ocsp status is revoked");
                }
                throw new IOException("ocsp status is unknown");
            }
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
        return null;
    }

    public CertificateStatus checkOCSP() throws ConnectException, SocketTimeoutException, ExceptionConverter {
        try {
            SingleResp[] responses;
            HttpURLConnection con;
            OCSPReq request = OcspClientBouncyCastle.generateOCSPRequest(this.rootCert, this.checkCert.getSerialNumber());
            byte[] array = request.getEncoded();
            URL urlt = new URL(this.url);
            int proxyType = Manager.getConfigObject().getProxyType();
            switch (proxyType) {
                case 0: {
                    con = (HttpURLConnection)urlt.openConnection(Proxy.NO_PROXY);
                    con.setConnectTimeout(20000);
                    break;
                }
                case 1: {
                    System.setProperty("java.net.useSystemProxies", "true");
                    List<Proxy> listProxy = ProxySelector.getDefault().select(new URI("http://ocsp.viettel-ca.vn"));
                    Proxy systemProxy = listProxy.get(0);
                    InetSocketAddress address = (InetSocketAddress)systemProxy.address();
                    if (address != null) {
                        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(address.getHostName(), address.getPort()));
                        con = (HttpURLConnection)urlt.openConnection(proxy);
                        con.setConnectTimeout(20000);
                        break;
                    }
                    con = (HttpURLConnection)urlt.openConnection();
                    con.setConnectTimeout(20000);
                    break;
                }
                case 2: {
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(Manager.getConfigObject().getProxyObject().getAddress(), Manager.getConfigObject().getProxyObject().getPort()));
                    con = (HttpURLConnection)urlt.openConnection(proxy);
                    con.setConnectTimeout(20000);
                    break;
                }
                default: {
                    con = (HttpURLConnection)urlt.openConnection();
                    con.setConnectTimeout(20000);
                }
            }
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            con.setRequestProperty("Accept", "application/ocsp-response");
            con.setDoOutput(true);
            OutputStream out = con.getOutputStream();
            DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));
            dataOut.write(array);
            dataOut.flush();
            dataOut.close();
            if (con.getResponseCode() / 100 != 2) {
                throw new IOException("invalid http response");
            }
            InputStream in = (InputStream)con.getContent();
            OCSPResp ocspResponse = new OCSPResp(in);
            if (ocspResponse.getStatus() != 0) {
                throw new IOException("invalid status");
            }
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
            if (basicResponse != null && this.checkResponse(basicResponse, this.rootCert) && (responses = basicResponse.getResponses()).length == 1) {
                SingleResp resp = responses[0];
                Object status = resp.getCertStatus();
                if (status == CertificateStatus.GOOD) {
                    CertificateStatus certificateStatus = CertificateStatus.GOOD;
                    return certificateStatus;
                }
                if (status instanceof RevokedStatus) {
                    RevokedStatus revokedStatus = (RevokedStatus)status;
                    return revokedStatus;
                }
                UnknownStatus unknownStatus = (UnknownStatus)status;
                return unknownStatus;
            }
        }
        catch (ConnectException | SocketTimeoutException e2) {
            throw e2;
        }
        catch (Exception ex) {
            throw new ExceptionConverter(ex);
        }
        finally {
            System.setProperty("java.net.useSystemProxies", "false");
        }
        return null;
    }

    private boolean checkResponse(BasicOCSPResp resp, X509Certificate certificate) throws Exception {
        Object[] object;
        Certificate[] cert = resp.getCerts("BC");
        return cert != null && (object = X509VerificationUtil.verifyCertificates(cert, certificate)) == null;
    }

    public static void main(String[] args) {
    }
}

