/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.verify;

import com.viettel.einvoice.verify.VerifySignatureOutput;
import eu.europa.esig.dss.token.utils.XMLDocumentUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CheckOcspOrCrl {
    private static final String VIETTEL_CERT_FILE = "D:\\signature\\viettel-ca.cer";
    private static final String GITHUB_CERT_REVOKE_FILE = "D:\\signature\\github.cer";
    private static final Logger logger = Logger.getLogger(CheckOcspOrCrl.class.getName());
    private static final int NUM_RETRY = 3;

    public static VerifySignatureOutput checkCertificateValid(InputStream is) throws ParserConfigurationException, SAXException, IOException, ParseException, CertificateException, DatatypeConfigurationException, URISyntaxException, ConnectException, SocketTimeoutException {
        Calendar issuedDate;
        VerifySignatureOutput output = new VerifySignatureOutput();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        XMLDocumentUtils.disableUnsafeEntity(dbFactory);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(is);
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("inv:invoice");
        Map<String, String> mapValueXml = CheckOcspOrCrl.getIssuedDateAndCert(nodeList);
        NodeList NLapList = doc.getElementsByTagName("NLap");
        if (mapValueXml.get("inv:invoiceIssuedDate") == null && NLapList.getLength() == 0) {
            output.setErrorCode("INVOCIE_ISSUED_DATE_IS_NULL");
            output.setDescription("InvocieIssuedDate is null");
            return output;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (mapValueXml.get("inv:invoiceIssuedDate") != null) {
            issuedDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(mapValueXml.get("inv:invoiceIssuedDate")).toGregorianCalendar();
        } else {
            issuedDate = Calendar.getInstance();
            issuedDate.setTime(df.parse(NLapList.item(0).getTextContent()));
        }
        String x509Certificate = "-----BEGIN CERTIFICATE-----\n" + (mapValueXml.get("X509Certificate") != null ? mapValueXml.get("X509Certificate") : doc.getElementsByTagName("X509Certificate").item(0).getTextContent()) + "\n" + "-----END CERTIFICATE-----";
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate inner = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(x509Certificate.getBytes()));
        logger.info("inner before : " + inner.getNotBefore());
        logger.info("inner after : " + inner.getNotAfter());
        logger.info(inner.getSubjectDN().getName());
        logger.info("serial:" + inner.getSerialNumber().toString(16));
        try {
            inner.checkValidity(issuedDate.getTime());
        }
        catch (CertificateExpiredException e2) {
            logger.error("Have error1!", e2);
            output.setErrorCode("VERIFY_INVOICE_ERROR");
            output.setDescription(e2.getMessage());
            return output;
        }
        catch (CertificateNotYetValidException e3) {
            logger.error("Have error1!", e3);
            output.setErrorCode("VERIFY_INVOICE_ERROR");
            output.setDescription(e3.getMessage());
            return output;
        }
        catch (Exception e4) {
            logger.error("Have error1!", e4);
            output.setErrorCode("VERIFY_INVOICE_ERROR");
            output.setDescription(e4.getMessage());
            return output;
        }
        logger.info("==============>Do not check ocsp<==============");
        return output;
    }

    public static boolean checkCertificateOCSP(X509Certificate cert) throws ConnectException, Exception {
        logger.info("==============>Do not check ocsp<==============");
        return true;
    }

    public static Certificate getCertificate(String fileName) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCertificate(CheckOcspOrCrl.class.getResourceAsStream(fileName));
        }
        catch (CertificateException e2) {
            logger.error("Have error! ", e2);
            return null;
        }
    }

    public static X509Certificate getX509Cert(String CertStr) {
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e2) {
            logger.error("GetX509Cert:", e2);
        }
        if (cf == null) {
            return null;
        }
        if (!CertStr.isEmpty()) {
            try {
                return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decode(CertStr.getBytes())));
            }
            catch (CertificateException e3) {
                logger.error("GetX509Cert:" + e3);
            }
        }
        return null;
    }

    public static X509Certificate getX509Cert(byte[] certBinary) throws Exception {
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e2) {
            logger.error("GetX509Cert: " + e2);
        }
        if (cf == null) {
            return null;
        }
        if (null != certBinary) {
            try {
                return (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBinary));
            }
            catch (CertificateException e3) {
                logger.error("GetX509Cert:" + e3);
            }
        }
        return null;
    }

    public static Map<String, String> getIssuedDateAndCert(NodeList nList) {
        ConcurrentHashMap<String, String> mapValueXml = new ConcurrentHashMap<String, String>();
        try {
            int length = nList.getLength();
            for (int temp = 0; temp < length; ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                logger.info("=====> nNode.getNodeType()" + nNode.getNodeType());
                Element eElement = (Element)nNode;
                if (eElement.getElementsByTagName("inv:invoiceIssuedDate") != null) {
                    mapValueXml.put("inv:invoiceIssuedDate", eElement.getElementsByTagName("inv:invoiceIssuedDate").item(0).getTextContent());
                }
                if (eElement.getElementsByTagName("X509Certificate") == null) continue;
                mapValueXml.put("X509Certificate", eElement.getElementsByTagName("X509Certificate").item(0).getTextContent());
            }
        }
        catch (Exception e2) {
            logger.error("Have error!", e2);
        }
        return mapValueXml;
    }

    public static void main(String[] args) {
    }
}

