/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.crl;

import com.viettel.einvoice.crl.CRLVerifier;
import com.viettel.einvoice.crl.CertificateVerificationException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CertificateVerifier {
    private static final String VIETTEL_CERT_FILE = "C:/Users/gpvt_khavn/Desktop/viettel.cer";
    private static final String USER_CERT_FILE = "C:/Users/gpvt_khavn/Desktop/user.cer";
    private static final String MIC_CERT_FILE = "C:/Users/gpvt_khavn/Desktop/MIC_National_Root_CA.cer";
    private static final Logger logger = Logger.getLogger(CertificateVerifier.class.getName());

    public static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<X509Certificate> additionalCerts) {
        try {
            if (CertificateVerifier.isSelfSigned(cert)) {
                throw new CertificateVerificationException("The certificate is self-signed.");
            }
            HashSet<X509Certificate> trustedRootCerts = new HashSet<X509Certificate>();
            HashSet<X509Certificate> intermediateCerts = new HashSet<X509Certificate>();
            for (X509Certificate additionalCert : additionalCerts) {
                if (CertificateVerifier.isSelfSigned(additionalCert)) {
                    trustedRootCerts.add(additionalCert);
                    continue;
                }
                intermediateCerts.add(additionalCert);
            }
            PKIXCertPathBuilderResult verifiedCertChain = CertificateVerifier.verifyCertificate(cert, trustedRootCerts, intermediateCerts);
            CRLVerifier.verifyCertificateCRLs(cert);
            return verifiedCertChain;
        }
        catch (CertPathBuilderException certPathEx) {
            logger.error("Have error: ", certPathEx);
        }
        catch (CertificateVerificationException certPathEx) {
            logger.error("Have error: ", certPathEx);
        }
        catch (IOException | GeneralSecurityException | NamingException ex) {
            logger.error("Have error: ", ex);
        }
        return null;
    }

    public static boolean isSelfSigned(X509Certificate cert) throws CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            PublicKey key = cert.getPublicKey();
            cert.verify(key);
            return true;
        }
        catch (InvalidKeyException | SignatureException sigEx) {
            logger.error("Have error: ", sigEx);
            return false;
        }
    }

    private static PKIXCertPathBuilderResult verifyCertificate(X509Certificate cert, Set<X509Certificate> trustedRootCerts, Set<X509Certificate> intermediateCerts) throws GeneralSecurityException, IOException {
        X509CertSelector selector = new X509CertSelector();
        selector.setCertificate(cert);
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (X509Certificate trustedRootCert : trustedRootCerts) {
            trustAnchors.add(new TrustAnchor(trustedRootCert, null));
        }
        PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAnchors, (CertSelector)selector);
        pkixParams.setRevocationEnabled(false);
        CertStore intermediateCertStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(intermediateCerts), "BC");
        pkixParams.addCertStore(intermediateCertStore);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
        PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(pkixParams);
        return result;
    }

    public static Certificate getCertificate(String fileName) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCertificate(new FileInputStream(fileName));
        }
        catch (FileNotFoundException | CertificateException e2) {
            logger.error("Have error: ", e2);
            return null;
        }
    }

    public static void main(String[] args) {
        boolean isBCProviderInstalled = false;
        for (int i2 = 0; i2 < Security.getProviders().length; ++i2) {
            if (!"BC".equalsIgnoreCase(Security.getProviders()[i2].getName())) continue;
            isBCProviderInstalled = true;
            logger.info("BCProvider Installed");
            break;
        }
        if (!isBCProviderInstalled) {
            logger.info("Install BCProvider ");
            if (Security.addProvider(new BouncyCastleProvider()) < 0) {
                logger.info("Could not install BC provider");
                Security.removeProvider("BC");
                if (Security.addProvider(new BouncyCastleProvider()) < 0) {
                    logger.info("Cannot even install BC provider again!");
                }
            }
        }
        System.getProperties().put("proxySet", "true");
        System.getProperties().put("proxyHost", "10.61.11.38");
        System.getProperties().put("proxyPort", "3128");
        HashSet<X509Certificate> additionalCerts = new HashSet<X509Certificate>();
        additionalCerts.add((X509Certificate)CertificateVerifier.getCertificate(MIC_CERT_FILE));
        additionalCerts.add((X509Certificate)CertificateVerifier.getCertificate(VIETTEL_CERT_FILE));
        CertificateVerifier.verifyCertificate((X509Certificate)CertificateVerifier.getCertificate(USER_CERT_FILE), additionalCerts);
    }
}

