/*
 * Decompiled with CFR 0.152.
 */
package com.viettel.einvoice.crl;

import com.viettel.einvoice.crl.CertificateVerificationException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.log4j.Logger;

public class CRLVerifier {
    private static final String USER_CERT_FILE = "D:\\Users\\dungnv93\\Documents\\NetBeansProjects\\sd-dss-master\\sd-dss-master\\dss-token\\src\\main\\resources\\RootCa\\viettel-root-ca.cer";
    private static final Logger logger = Logger.getLogger(CRLVerifier.class.getName());

    public static boolean verifyCertificateCRLs(X509Certificate cert) throws CertificateVerificationException, CertificateParsingException, IOException, CertificateException, CRLException, NamingException, ConnectException {
        List<String> crlDistPoints = CRLVerifier.getCrlDistributionPoints(cert);
        Iterator<String> iterator = crlDistPoints.iterator();
        if (iterator.hasNext()) {
            String crlDP = iterator.next();
            X509CRL crl = CRLVerifier.downloadCRL(crlDP);
            if (crl.isRevoked(cert)) {
                logger.info("The certificate is revoked by CRL: " + crlDP);
                return false;
            }
            logger.info("The certificate is NOT revoked by CRL: " + crlDP);
            return true;
        }
        return false;
    }

    private static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException, ConnectException {
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            X509CRL crl = CRLVerifier.downloadCRLFromWeb(crlURL);
            return crl;
        }
        if (crlURL.startsWith("ldap://")) {
            X509CRL crl = CRLVerifier.downloadCRLFromLDAP(crlURL);
            return crl;
        }
        throw new CertificateVerificationException("Can not download CRL from certificate distribution point: " + crlURL);
    }

    private static X509CRL downloadCRLFromLDAP(String ldapURL) throws CertificateException, NamingException, CRLException, CertificateVerificationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(env);
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get("certificateRevocationList;binary");
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new CertificateVerificationException("Can not download CRL from: " + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509CRL crl = (X509CRL)cf.generateCRL(inStream);
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL downloadCRLFromWeb(String crlURL) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL url = new URL(crlURL);
        try (InputStream crlStream = url.openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)cf.generateCRL(crlStream);
            logger.info("crlURL " + crlURL);
            X509CRL x509CRL = crl;
            return x509CRL;
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate cert) throws CertificateParsingException, IOException {
        ArrayList<String> crlUrls = new ArrayList<String>();
        return crlUrls;
    }

    public static Certificate getCertificate(String fileName) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return cf.generateCertificate(new FileInputStream(fileName));
        }
        catch (FileNotFoundException | CertificateException e2) {
            logger.error("Have error: ", e2);
            return null;
        }
    }
}

