/*
 * Decompiled with CFR 0.152.
 */
package Test;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class JettyWebSocketClient {
    private static final Logger logger = Logger.getLogger(JettyWebSocketClient.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(URI destinationUri) throws IOException {
        SslContextFactory sslContextFactory = new SslContextFactory();
        Resource keyStoreResource = Resource.newResource(JettyWebSocketClient.class.getClassLoader().getResource("einvoice.jks"));
        sslContextFactory.setKeyStoreResource(keyStoreResource);
        sslContextFactory.setKeyStorePassword("einvoicegw@123");
        sslContextFactory.setKeyManagerPassword("einvoicegw@123");
        WebSocketClient client = new WebSocketClient(sslContextFactory);
        MyWebSocket socket = new MyWebSocket();
        try {
            client.start();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            client.connect(socket, destinationUri, request);
            socket.awaitClose(5, TimeUnit.SECONDS);
        }
        catch (Throwable ex) {
            logger.error("Exception", ex);
        }
        finally {
            try {
                client.stop();
            }
            catch (Exception e2) {
                logger.error("Exception", e2);
            }
        }
    }

    @WebSocket
    public class MyWebSocket {
        private final CountDownLatch closeLatch = new CountDownLatch(1);

        @OnWebSocketConnect
        public void onConnect(Session session) {
            try {
                session.getRemote().sendString("Hi Server");
            }
            catch (IOException e2) {
                logger.error("Exception", e2);
            }
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
        }

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
        }

        public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
            return this.closeLatch.await(duration, unit);
        }
    }
}

