/*
 * Decompiled with CFR 0.152.
 */
package Test;

import Test.MyWebSocketHandler;
import Test.WebSocketServer;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.resource.FileResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class JavaSocket {
    private Server server;
    private String host;
    private int port;
    private Resource keyStoreResource;
    private String keyStorePassword;
    private String keyManagerPassword;
    private List<Handler> webSocketHandlerList = new ArrayList<Handler>();
    private static final Logger logger = Logger.getLogger(JavaSocket.class.getName());

    public static void main(String[] args) throws Exception {
        WebSocketServer webSocketServer = new WebSocketServer();
        webSocketServer.setHost("localhost");
        webSocketServer.setPort(3004);
        webSocketServer.setKeyStoreResource(new FileResource(JavaSocket.class.getClassLoader().getResource("einvoice_token.jks")));
        webSocketServer.setKeyStorePassword("einvoice232#@~)&%x20");
        webSocketServer.setKeyManagerPassword("einvoice232#@~)&%x20");
        webSocketServer.addWebSocket(MyWebSocketHandler.class, "/");
        webSocketServer.initialize();
        webSocketServer.start();
    }

    public void initialize() {
        this.server = new Server();
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStoreResource(this.keyStoreResource);
        sslContextFactory.setKeyStorePassword(this.keyStorePassword);
        sslContextFactory.setKeyManagerPassword(this.keyManagerPassword);
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory(new HttpConfiguration());
        ServerConnector sslConnector = new ServerConnector(this.server, sslConnectionFactory, httpConnectionFactory);
        sslConnector.setHost(this.host);
        sslConnector.setPort(this.port);
        this.server.addConnector(sslConnector);
        HandlerCollection handlerCollection = new HandlerCollection();
        handlerCollection.setHandlers(this.webSocketHandlerList.toArray(new Handler[0]));
        this.server.setHandler(handlerCollection);
    }

    public void addWebSocket(final Class<?> webSocket, String pathSpec) {
        WebSocketHandler wsHandler = new WebSocketHandler(){

            @Override
            public void configure(WebSocketServletFactory webSocketServletFactory) {
                webSocketServletFactory.register(webSocket);
            }
        };
        ContextHandler wsContextHandler = new ContextHandler();
        wsContextHandler.setHandler(wsHandler);
        wsContextHandler.setContextPath(pathSpec);
        this.webSocketHandlerList.add(wsHandler);
    }

    public void start() throws Exception {
        this.server.start();
        this.server.join();
    }

    public void stop() throws Exception {
        this.server.stop();
        this.server.join();
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeyStoreResource(Resource keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
    }
}

